/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.SpanToolbarLayoutManager;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDropInfo;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarSlimDropLayer;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ToolbarDockStation
extends AbstractToolbarDockStation {
    public static final String TITLE_ID = "toolbar";
    public static final String DISPLAYER_ID = "toolbar";
    public static final PropertyKey<Integer> GAP = new PropertyKey("dock.toolbar.gap", (PropertyFactory)new ConstantPropertyFactory((Object)2), true);
    public static final PropertyKey<Integer> SIDE_GAP = new PropertyKey("dock.toolbar.sidegap", (PropertyFactory)new ConstantPropertyFactory((Object)4), true);
    protected DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private OverpaintablePanelBase mainPanel;
    private int lateralNodropZoneSize = 2;
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            ToolbarDockStation.this.dockables.setStrategy(newValue);
        }
    };
    private DockableShowingManager visibility;
    private VisibleListener visibleListener;
    private SpanToolbarLayoutManager layoutManager;
    private DropInfo dropInfo;
    private PropertyValue<Integer> gap = new PropertyValue<Integer>(GAP){

        protected void valueChanged(Integer oldValue, Integer newValue) {
            ToolbarDockStation.this.layoutManager.setGap(newValue);
        }
    };
    private PropertyValue<Integer> sideGap = new PropertyValue<Integer>(SIDE_GAP){

        protected void valueChanged(Integer oldValue, Integer newValue) {
            ToolbarDockStation.this.layoutManager.setSideGap(newValue);
        }
    };

    public ToolbarDockStation() {
        this.init();
    }

    protected void init() {
        super.init("dock.background.station.toolbar");
        this.mainPanel = this.createMainPanel();
        this.mainPanel.setupLayout();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar", (DockStation)this);
        this.setOrientation(this.getOrientation());
        this.displayerFactory = this.createDisplayerFactory();
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, this.getDisplayerId());
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            public void discard(DockableDisplayer displayer) {
                ToolbarDockStation.this.discard(displayer);
            }

            public void moveableElementChanged(DockableDisplayer displayer) {
            }
        });
        this.setTitleIcon(null);
        this.visibility = new DockableShowingManager(this.listeners);
        this.visibleListener = new VisibleListener();
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (ToolbarDockStation.this.getDockParent() == null) {
                        ToolbarDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    ToolbarDockStation.this.visibility.fire();
                }
            }
        });
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler((DockComponentRoot)this, this.displayers);
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    public void configureDisplayerHints(DockableDisplayerHints hints) {
        super.configureDisplayerHints(hints);
        if (hints != null && hints.getStation() instanceof ScreenDockStation) {
            hints.setShowBorderHint(Boolean.TRUE);
        }
    }

    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    public Dockable getDockable(int index) {
        return ((StationChildHandle)this.dockables.dockables().get(index)).getDockable();
    }

    public String getFactoryID() {
        return "ToolbarDockStationFactory";
    }

    public void setLateralNodropZoneSize(int lateralNodropZoneSize) {
        if (lateralNodropZoneSize < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.lateralNodropZoneSize = lateralNodropZoneSize;
    }

    public int getLateralNodropZoneSize() {
        return this.lateralNodropZoneSize;
    }

    public void setDockParent(DockStation station) {
        DockStation old = this.getDockParent();
        if (old != null) {
            old.removeDockStationListener((DockStationListener)this.visibleListener);
        }
        super.setDockParent(station);
        if (station != null) {
            station.addDockStationListener((DockStationListener)this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController controller) {
        if (this.getController() != controller) {
            if (this.getController() != null) {
                this.dockables.unbind();
            }
            for (StationChildHandle handle : this.dockables.dockables()) {
                handle.setTitleRequest(null);
            }
            super.setController(controller);
            this.title = controller == null ? null : this.registerTitle(controller);
            this.paint.setController(controller);
            this.placeholderStrategy.setProperties(controller);
            this.displayerFactory.setController(controller);
            this.displayers.setController(controller);
            this.mainPanel.setController(controller);
            this.layoutManager.setController(controller);
            this.gap.setProperties(controller);
            this.sideGap.setProperties(controller);
            if (controller != null) {
                this.dockables.bind();
            }
            for (StationChildHandle handle : this.dockables.dockables()) {
                handle.setTitleRequest(this.title, true);
            }
            this.visibility.fire();
        }
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.fireOrientingEvent();
        this.mainPanel.revalidate();
    }

    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new ToolbarSlimDropLayer(this)};
    }

    public boolean accept(Dockable child) {
        return this.getToolbarStrategy().isToolbarPart(child);
    }

    public boolean accept(DockStation station) {
        return this.getToolbarStrategy().isToolbarGroupPartParent(station, this, false);
    }

    public boolean accept(DockStation base, Dockable neighbor) {
        return false;
    }

    public StationDropOperation prepareDrop(StationDropItem item) {
        DockController controller = this.getController();
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            return null;
        }
        Dockable dockable = item.getDockable();
        if (this.accept(dockable) && dockable.accept((DockStation)this)) {
            if (controller != null && !controller.getAcceptance().accept((DockStation)this, dockable)) {
                return null;
            }
            Point mouse = new Point(item.getMouseX(), item.getMouseY());
            SwingUtilities.convertPointFromScreen(mouse, this.mainPanel.getDockablePane());
            int index = this.layoutManager.getInsertionIndex(mouse.x, mouse.y);
            DropInfo info = new DropInfo(dockable, index);
            if (info.hasNoEffect()) {
                return null;
            }
            return info;
        }
        return null;
    }

    public void drop(Dockable dockable) {
        this.drop(dockable, this.getDockableCount(), true);
    }

    public boolean drop(Dockable dockable, int index) {
        return this.drop(dockable, index, false);
    }

    protected boolean drop(Dockable dockable, int index, boolean force) {
        if (force || this.accept(dockable)) {
            if (!force) {
                Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (replacement == null) {
                    return false;
                }
                if (replacement != dockable) {
                    replacement.asDockStation().drop(dockable);
                    dockable = replacement;
                }
            }
            this.add(dockable, index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(Dockable dockable, int index) {
        DockController controller = this.getController();
        try {
            int current;
            if (controller != null) {
                controller.freezeLayout();
            }
            if ((current = this.indexOf(dockable)) == -1) {
                throw new IllegalArgumentException("dockable is not known to this station");
            }
            if (current < index) {
                --index;
            }
            if (current != index) {
                this.add(dockable, index);
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    protected void add(Dockable dockable, int index) {
        this.add(dockable, index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Dockable dockable, int index, Path placeholder) {
        DockUtilities.ensureTreeValidity((DockStation)this, (Dockable)dockable);
        DockUtilities.checkLayoutLocked();
        Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (replacement != dockable) {
            replacement.asDockStation().drop(dockable);
            dockable = replacement;
        }
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            DockStation stack = this.getDockable(0).asDockStation();
            stack.drop(dockable, (DockableProperty)new StackDockProperty(index, placeholder));
        } else {
            DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking((DockStation)this, (Dockable)dockable);
            try {
                this.listeners.fireDockableAdding(dockable);
                int inserted = -1;
                StationChildHandle handle = new StationChildHandle((DockStation)this, this.displayers, dockable, this.title);
                handle.updateDisplayer();
                if (placeholder != null && this.dockables.getDockableAt(placeholder) == null) {
                    inserted = this.dockables.put(placeholder, (PlaceholderListItem)handle);
                } else if (placeholder != null) {
                    index = this.dockables.getDockableIndex(placeholder);
                }
                if (inserted == -1) {
                    this.getDockables().add(index, (Object)handle);
                } else {
                    index = inserted;
                }
                this.insertAt(handle, index);
                this.listeners.fireDockableAdded(dockable);
                this.fireDockablesRepositioned(index + 1);
            }
            finally {
                token.release();
            }
        }
    }

    protected void insertAt(StationChildHandle handle, int index) {
        Dockable dockable = handle.getDockable();
        dockable.setDockParent((DockStation)this);
        this.mainPanel.getDockablePane().add(handle.getDisplayer().getComponent(), index);
        this.mainPanel.getDockablePane().invalidate();
        this.mainPanel.revalidate();
        this.mainPanel.getContentPane().repaint();
    }

    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.remove(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        int index = this.indexOf(dockable);
        StationChildHandle handle = (StationChildHandle)this.dockables.dockables().get(index);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking((DockStation)this, (Dockable)dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            this.dockables.remove(index);
            this.mainPanel.getDockablePane().remove(handle.getDisplayer().getComponent());
            this.mainPanel.doLayout();
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            handle.destroy();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(index);
        }
        finally {
            token.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int index) {
        DockUtilities.checkLayoutLocked();
        StationChildHandle handle = (StationChildHandle)this.dockables.dockables().get(index);
        Dockable dockable = this.getDockable(index);
        if (this.getFrontDockable() == dockable) {
            this.setFrontDockable(null);
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking((DockStation)this, (Dockable)dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            this.dockables.remove(index);
            this.mainPanel.getDockablePane().remove(handle.getDisplayer().getComponent());
            this.mainPanel.doLayout();
            this.mainPanel.getContentPane().revalidate();
            this.mainPanel.getContentPane().repaint();
            handle.destroy();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(index);
        }
        finally {
            token.release();
        }
    }

    public void replace(Dockable old, Dockable next) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        if (controller != null) {
            controller.freezeLayout();
        }
        int index = this.indexOf(old);
        this.remove(old);
        this.add(next, index);
        controller.meltLayout();
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme((DockStation)this, (DockFactory)new ToolbarDockStationFactory());
    }

    @Override
    protected DefaultDisplayerFactoryValue createDisplayerFactory() {
        return new DefaultDisplayerFactoryValue("dock.displayer.toolbar", (DockStation)this);
    }

    protected String getDisplayerId() {
        return "toolbar";
    }

    @Override
    protected DockTitleVersion registerTitle(DockController controller) {
        return controller.getDockTitleManager().getVersion("toolbar", BasicDockTitleFactory.FACTORY);
    }

    @Override
    protected void discard(DockableDisplayer displayer) {
        Dockable dockable = displayer.getDockable();
        int index = this.indexOf(dockable);
        if (index < 0) {
            throw new IllegalArgumentException("displayer is not a child of this station: " + displayer);
        }
        StationChildHandle handle = (StationChildHandle)this.dockables.dockables().get(index);
        this.mainPanel.getDockablePane().remove(handle.getDisplayer().getComponent());
        handle.updateDisplayer();
        this.insertAt(handle, index);
    }

    protected OverpaintablePanelBase createMainPanel() {
        return new OverpaintablePanelBase();
    }

    @Override
    protected JPanel createBackgroundPanel() {
        return new SizeFixedPanel();
    }

    protected DockableProperty getDockableProperty(Dockable child, Dockable target, int index, Path placeholder) {
        return new ToolbarProperty(index, placeholder);
    }

    protected boolean isValidProperty(DockableProperty property) {
        return property instanceof ToolbarProperty;
    }

    protected int getIndex(DockableProperty property) {
        return ((ToolbarProperty)property).getIndex();
    }

    protected Path getPlaceholder(DockableProperty property) {
        return ((ToolbarProperty)property).getPlaceholder();
    }

    protected PlaceholderList.Filter<StationChildHandle> getDockables() {
        return this.dockables.dockables();
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> children) {
        final PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        return this.dockables.toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            public ConvertedPlaceholderListItem convert(int index, StationChildHandle handle) {
                Path placeholder;
                Dockable dockable = handle.getDockable();
                Integer id = (Integer)children.get(dockable);
                if (id == null) {
                    return null;
                }
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", id.intValue());
                item.putInt("index", index);
                if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable)) != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap map, final Map<Integer, Dockable> children) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("must not have any children");
        }
        DockController controller = this.getController();
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            DockablePlaceholderList next = new DockablePlaceholderList();
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = next;
            } else {
                this.dockables = next;
            }
            next.read(map, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
                private DockHierarchyLock.Token token;
                private int index = 0;

                public StationChildHandle convert(ConvertedPlaceholderListItem item) {
                    int id = item.getInt("id");
                    Dockable dockable = (Dockable)children.get(id);
                    if (dockable != null) {
                        DockUtilities.ensureTreeValidity((DockStation)ToolbarDockStation.this, (Dockable)dockable);
                        this.token = DockHierarchyLock.acquireLinking((DockStation)ToolbarDockStation.this, (Dockable)dockable);
                        ToolbarDockStation.this.listeners.fireDockableAdding(dockable);
                        return new StationChildHandle((DockStation)ToolbarDockStation.this, ToolbarDockStation.this.displayers, dockable, ToolbarDockStation.this.title);
                    }
                    return null;
                }

                public void added(StationChildHandle handle) {
                    try {
                        handle.updateDisplayer();
                        ToolbarDockStation.this.insertAt(handle, this.index++);
                        ToolbarDockStation.this.listeners.fireDockableAdded(handle.getDockable());
                    }
                    finally {
                        this.token.release();
                    }
                }
            });
            if (this.getController() != null) {
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            }
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            public DockableProperty getLocationAt(Path placeholder) {
                int index = ToolbarDockStation.this.dockables.getDockableIndex(placeholder);
                return new ToolbarProperty(index, placeholder);
            }
        };
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("only allowed if there are not children present");
        }
        try {
            DockablePlaceholderList next = new DockablePlaceholderList(placeholders);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = next;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = next;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return (PlaceholderStrategy)this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategy.setValue((Object)strategy);
    }

    public DockableProperty getDockableProperty(Dockable child, Dockable target) {
        int index = this.indexOf(child);
        Path placeholder = null;
        PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(target == null ? child : target)) != null) {
            this.dockables.dockables().addPlaceholder(index, placeholder);
        }
        return this.getDockableProperty(child, target, index, placeholder);
    }

    public void aside(AsideRequest request) {
        int index = -1;
        int resultIndex = -1;
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            DockStation stack = this.getDockable(0).asDockStation();
            AsideAnswer answer = request.forward(stack);
            if (answer.isCanceled()) {
                return;
            }
            DockableProperty answerLocation = answer.getLocation();
            if (answerLocation instanceof StackDockProperty) {
                resultIndex = ((StackDockProperty)answerLocation).getIndex();
            }
        }
        DockableProperty location = request.getLocation();
        Path newPlaceholder = request.getPlaceholder();
        if (location instanceof ToolbarProperty) {
            ToolbarProperty toolbarLocation = (ToolbarProperty)location;
            index = this.dockables.getNextListIndex(toolbarLocation.getIndex(), toolbarLocation.getPlaceholder());
            if (newPlaceholder != null) {
                this.dockables.list().insertPlaceholder(index, newPlaceholder);
            }
        } else {
            index = this.dockables.dockables().size();
            if (newPlaceholder != null) {
                this.dockables.dockables().insertPlaceholder(index, newPlaceholder);
            }
        }
        if (resultIndex == -1) {
            resultIndex = index;
        }
        request.answer((DockableProperty)new ToolbarProperty(index, newPlaceholder));
    }

    public boolean drop(Dockable dockable, DockableProperty property) {
        if (this.isValidProperty(property)) {
            DockStation child;
            DockStation station;
            StationChildHandle preset;
            boolean acceptable = this.acceptable(dockable);
            boolean result = false;
            int index = Math.min(this.getDockableCount(), this.getIndex(property));
            Path placeholder = this.getPlaceholder(property);
            if (placeholder != null && property.getSuccessor() != null && (preset = (StationChildHandle)this.dockables.getDockableAt(placeholder)) != null && (station = preset.getDockable().asDockStation()) != null && station.drop(dockable, property.getSuccessor())) {
                this.dockables.removeAll(placeholder);
                result = true;
            }
            if (!result && placeholder != null && acceptable && this.dockables.hasPlaceholder(placeholder)) {
                this.add(dockable, index, placeholder);
                result = true;
            }
            if (!result && this.dockables.dockables().size() == 0 && acceptable) {
                this.drop(dockable);
                result = true;
            }
            if (!result && index < this.dockables.dockables().size() && property.getSuccessor() != null && (child = this.getDockable(index).asDockStation()) != null) {
                result = child.drop(dockable, property.getSuccessor());
            }
            if (!result && acceptable) {
                result = this.drop(dockable, index);
            }
            return result;
        }
        return false;
    }

    public void move(Dockable dockable, DockableProperty property) {
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            if (dockable == ToolbarDockStation.this) {
                ToolbarDockStation.this.visibility.fire();
            }
        }
    }

    protected class OverpaintablePanelBase
    extends SecureContainer {
        private static final long serialVersionUID = -4399008463139189130L;
        private JComponent dockablePane;

        public OverpaintablePanelBase() {
            this.setSolid(false);
        }

        public void setupLayout() {
            this.setDockablePane(ToolbarDockStation.this.createBackgroundPanel());
            this.setBasePane(this.dockablePane);
        }

        public void setDockablePane(JComponent pane) {
            if (this.dockablePane != null) {
                throw new IllegalStateException("dockablePane is already set");
            }
            this.dockablePane = pane;
            ToolbarDockStation.this.layoutManager = new SpanToolbarLayoutManager(ToolbarDockStation.this, this.dockablePane){

                @Override
                protected void revalidate() {
                    OverpaintablePanelBase.this.dockablePane.revalidate();
                }
            };
            this.dockablePane.setLayout(ToolbarDockStation.this.layoutManager);
        }

        public JComponent getDockablePane() {
            return this.dockablePane;
        }

        public Dimension getPreferredSize() {
            return this.getBasePane().getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        private Insets subtractComponent(JComponent component, Insets insets) {
            Point topLeft = new Point(0, 0);
            topLeft = SwingUtilities.convertPoint(component, topLeft, (Component)((Object)this));
            insets.left += topLeft.x;
            insets.top += topLeft.y;
            insets.right += this.getWidth() - component.getWidth() - topLeft.x;
            insets.bottom += this.getHeight() - component.getHeight() - topLeft.y;
            return insets;
        }

        protected void paintOverlay(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            this.paintRemoval(g);
            if (ToolbarDockStation.this.dropInfo != null) {
                int height;
                int y;
                int width;
                int x;
                Insets insets = this.dockablePane.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                insets = this.subtractComponent(this.dockablePane, insets);
                int index = ToolbarDockStation.this.dropInfo.getIndex();
                if (ToolbarDockStation.this.getOrientation() == Orientation.HORIZONTAL) {
                    x = index == 0 ? insets.left : this.dockablePane.getComponent(index - 1).getX() + this.dockablePane.getComponent(index - 1).getWidth();
                    width = index == this.dockablePane.getComponentCount() ? this.getWidth() - x - insets.right : this.dockablePane.getComponent(index).getX() - x;
                    y = insets.top;
                    height = this.getHeight() - insets.top - insets.bottom;
                } else {
                    y = index == 0 ? insets.top : this.dockablePane.getComponent(index - 1).getY() + this.dockablePane.getComponent(index - 1).getHeight();
                    height = index == this.dockablePane.getComponentCount() ? this.getHeight() - y - insets.top : this.dockablePane.getComponent(index).getY() - y;
                    x = insets.left;
                    width = this.getWidth() - insets.left - insets.right;
                }
                if (width > 0 && height > 0) {
                    Rectangle stationBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    ToolbarDockStation.this.paint.drawInsertion((Graphics)g2D, stationBounds, new Rectangle(x, y, width, height));
                }
            }
        }

        private void paintRemoval(Graphics g) {
            Dockable removal = ToolbarDockStation.this.getRemoval();
            if (removal != null) {
                for (StationChildHandle handle : ToolbarDockStation.this.dockables.dockables()) {
                    if (handle.getDockable() != removal) continue;
                    Dimension size = handle.getDisplayer().getComponent().getSize();
                    Point location = new Point(0, 0);
                    location = SwingUtilities.convertPoint(handle.getDisplayer().getComponent(), location, (Component)((Object)this));
                    Rectangle bounds = new Rectangle(location, size);
                    ToolbarDockStation.this.paint.drawRemoval(g, bounds, bounds);
                    break;
                }
            }
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    protected class SizeFixedPanel
    extends ConfiguredBackgroundPanel {
        public SizeFixedPanel() {
            super(Transparency.SOLID);
            this.setBackground(ToolbarDockStation.this.getBackgroundAlgorithm());
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            return pref;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class DropInfo
    extends ToolbarDropInfo {
        public DropInfo(Dockable dockable, int index) {
            super(dockable, ToolbarDockStation.this, index);
        }

        public void execute() {
            ToolbarDockStation.this.dropInfo = null;
            ToolbarDockStation.this.layoutManager.setExpandedSpan(-1, false);
            if (this.isMove()) {
                ToolbarDockStation.this.move(this.getItem(), this.getIndex());
            } else {
                ToolbarDockStation.this.drop(this.getItem(), this.getIndex());
            }
        }

        public void destroy(StationDropOperation next) {
            if (ToolbarDockStation.this.dropInfo == this) {
                ToolbarDockStation.this.dropInfo = null;
            }
            if (next == null || next.getTarget() != this.getTarget()) {
                ToolbarDockStation.this.layoutManager.setExpandedSpan(-1, true);
            }
            ToolbarDockStation.this.mainPanel.repaint();
        }

        public void draw() {
            ToolbarDockStation.this.dropInfo = this;
            ToolbarDockStation.this.layoutManager.setSpanSize(this.getItem());
            ToolbarDockStation.this.layoutManager.setExpandedSpan(this.getIndex(), true);
            ToolbarDockStation.this.mainPanel.repaint();
        }
    }
}

