/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.split.DefaultSplitDividerStrategy;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDividerStrategy;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.NoSpanFactory;
import bibliothek.gui.dock.wizard.CellDivider;
import bibliothek.gui.dock.wizard.ColumnDividier;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardColumnModel;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSpanStrategy;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class WizardSplitDockStation
extends SplitDockStation
implements Scrollable {
    private WizardLayoutManager layoutManager;
    private WizardSpanStrategy wizardSpanStrategy;
    private Side side;
    private boolean onRevalidating = false;
    private int sideGap = 3;
    private boolean resizeOnRemove = false;
    private WizardNodeMap.Column columnToResize = null;
    private Dockable dockableCausingResize = null;
    private int maxColumnCount = -1;

    public WizardSplitDockStation(Side side) {
        this.side = side;
        this.layoutManager = new WizardLayoutManager();
        this.wizardSpanStrategy = new WizardSpanStrategy(this);
        this.setSplitLayoutManager((SplitLayoutManager)this.layoutManager);
        this.setDividerStrategy((SplitDividerStrategy)new WizardDividerStrategy());
        this.setAllowSideSnap(true);
        this.getSpanStrategy().getFactory().setDelegate((Object)new NoSpanFactory());
        this.addDockStationListener(new DockStationListener(){

            public void dockablesRepositioned(DockStation station, Dockable[] dockables) {
                WizardSplitDockStation.this.revalidateOutside();
            }

            public void dockableShowingChanged(DockStation station, Dockable dockable, boolean showing) {
                WizardSplitDockStation.this.revalidateOutside();
            }

            public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
            }

            public void dockableRemoving(DockStation station, Dockable dockable) {
                WizardSplitDockStation.this.storeColumnToResize(dockable);
            }

            public void dockableRemoved(DockStation station, Dockable dockable) {
                WizardSplitDockStation.this.resizeStoredColumn();
            }

            public void dockableAdding(DockStation station, Dockable dockable) {
            }

            public void dockableAdded(DockStation station, Dockable dockable) {
                WizardSplitDockStation.this.revalidateOutside();
            }
        });
    }

    public void revalidateOutside() {
        if (!this.onRevalidating) {
            this.revalidate();
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (WizardSplitDockStation.this.getParent() instanceof JViewport) {
                            Container parent;
                            for (parent = WizardSplitDockStation.this.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                            }
                            if (parent != null && (parent = parent.getParent()) instanceof JComponent) {
                                ((JComponent)parent).revalidate();
                            }
                        }
                        try {
                            WizardSplitDockStation.this.onRevalidating = true;
                            WizardSplitDockStation.this.updateBounds();
                        }
                        finally {
                            WizardSplitDockStation.this.onRevalidating = false;
                        }
                    }
                });
            }
        }
    }

    public String getFactoryID() {
        return "WizardSplitDockStationFactory";
    }

    public WizardLayoutManager getWizardSplitLayoutManager() {
        return this.layoutManager;
    }

    public WizardSpanStrategy getWizardSpanStrategy() {
        return this.wizardSpanStrategy;
    }

    public void setDividerSize(int dividerSize) {
        super.setDividerSize(dividerSize);
        if (this.wizardSpanStrategy != null) {
            this.wizardSpanStrategy.reset();
        }
    }

    public void setResizeOnRemove(boolean resizeOnRemove) {
        this.resizeOnRemove = resizeOnRemove;
    }

    public boolean isResizeOnRemove() {
        return this.resizeOnRemove;
    }

    public void setController(DockController controller) {
        this.wizardSpanStrategy.setController(controller);
        super.setController(controller);
    }

    protected void setPut(PutInfo info) {
        this.wizardSpanStrategy.setPut(info);
        if (info != null) {
            this.storeColumnToResize(info.getDockable());
        }
    }

    protected void unsetPut() {
        this.wizardSpanStrategy.unsetPut();
    }

    protected boolean dropAside(SplitNode neighbor, PutInfo.Put put, Dockable dockable, Leaf leaf, double divider, DockHierarchyLock.Token token) {
        if (super.dropAside(neighbor, put, dockable, leaf, divider, token)) {
            this.resizeStoredColumn();
            return true;
        }
        return false;
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty property, CombinerSource source, CombinerTarget target) {
        if (super.dropOver(leaf, dockable, property, source, target)) {
            this.resizeStoredColumn();
            return true;
        }
        return false;
    }

    private void storeColumnToResize(Dockable dockable) {
        if (this.resizeOnRemove && dockable.getDockParent() == this) {
            this.columnToResize = this.layoutManager.getMap().getColumn(dockable);
            if (this.columnToResize != null && this.columnToResize.getCellCount() == 1) {
                this.columnToResize = null;
            } else {
                this.dockableCausingResize = dockable;
            }
        } else {
            this.columnToResize = null;
        }
    }

    private void resizeStoredColumn() {
        if (this.columnToResize != null) {
            WizardNodeMap map = this.layoutManager.getMap();
            WizardNodeMap.Column newColumn = map.getColumn(this.dockableCausingResize);
            PersistentColumn column = null;
            if (newColumn == null || newColumn.getIndex() > this.columnToResize.getIndex()) {
                column = map.getPersistentColumn(this.columnToResize.getIndex());
            } else if (newColumn.getCellCount() == 1) {
                column = map.getPersistentColumn(this.columnToResize.getIndex() + 1);
            } else if (newColumn.getIndex() != this.columnToResize.getIndex()) {
                column = map.getPersistentColumn(this.columnToResize.getIndex());
            }
            if (column != null) {
                column.setSize(column.getPreferredSize());
            }
            this.columnToResize = null;
            this.dockableCausingResize = null;
        }
        this.revalidateOutside();
    }

    public int getSideGap() {
        return this.sideGap;
    }

    public void setSideGap(int sideGap) {
        if (sideGap < 0) {
            throw new IllegalArgumentException("sideGap must be at least 0: " + sideGap);
        }
        this.sideGap = sideGap;
        this.revalidate();
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        if (side == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.side != side) {
            boolean rotate = this.side.getHeaderOrientation() != side.getHeaderOrientation();
            this.side = side;
            if (rotate) {
                this.root().visit(new SplitNodeVisitor(){

                    public void handleRoot(Root root) {
                    }

                    public void handlePlaceholder(Placeholder placeholder) {
                    }

                    public void handleNode(Node node) {
                        switch (node.getOrientation()) {
                            case HORIZONTAL: {
                                node.setOrientation(SplitDockStation.Orientation.VERTICAL);
                                break;
                            }
                            case VERTICAL: {
                                node.setOrientation(SplitDockStation.Orientation.HORIZONTAL);
                            }
                        }
                    }

                    public void handleLeaf(Leaf leaf) {
                    }
                });
            }
            this.resetToPreferredSizes();
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.side == Side.LEFT || this.side == Side.RIGHT) {
            return true;
        }
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.side == Side.TOP || this.side == Side.BOTTOM) {
            return true;
        }
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.layoutManager == null) {
            return super.getPreferredSize();
        }
        return this.layoutManager.getPreferredSize();
    }

    protected void paintOverlay(Graphics g) {
        PutInfo putInfo = this.getDropInfo();
        if (putInfo != null) {
            DefaultStationPaintValue paint = this.getPaint();
            if (putInfo.getNode() == null) {
                Insets insets = this.getInsets();
                Rectangle bounds = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                paint.drawInsertion(g, bounds, bounds);
            } else {
                CombinerTarget target = putInfo.getCombinerTarget();
                if (target == null) {
                    Rectangle bounds = putInfo.getNode().getBounds();
                    int gap = this.getWizardSpanStrategy().getGap();
                    if (putInfo.getPut() == PutInfo.Put.LEFT) {
                        bounds.x -= gap;
                        bounds.width = gap;
                        bounds.x = Math.max(0, bounds.x);
                    } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
                        bounds.x += bounds.width;
                        bounds.width = gap;
                        bounds.x = Math.min(bounds.x, this.getWidth() - gap - 1);
                    } else if (putInfo.getPut() == PutInfo.Put.TOP) {
                        bounds.y -= gap;
                        bounds.height = gap;
                        bounds.y = Math.max(0, bounds.y);
                    } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
                        bounds.y += bounds.height;
                        bounds.height = gap;
                        bounds.y = Math.min(bounds.y, this.getHeight() - gap - 1);
                    }
                    paint.drawInsertion(g, putInfo.getNode().getBounds(), bounds);
                } else {
                    Rectangle bounds = putInfo.getNode().getBounds();
                    StationPaint stationPaint = (StationPaint)paint.get();
                    if (stationPaint != null) {
                        target.paint(g, this.getComponent(), stationPaint, bounds, bounds);
                    }
                }
            }
        }
        this.getDividerStrategy().paint((SplitDockStation)this, g);
    }

    private Leaf resizeableLeafAt(int x, int y) {
        block3: {
            int gap;
            Leaf[] leafs;
            block2: {
                leafs = this.layoutManager.getLastLeafOfColumns();
                gap = this.getDividerSize();
                if (this.side != Side.RIGHT && this.side != Side.LEFT) break block2;
                for (Leaf leaf : leafs) {
                    Rectangle bounds = leaf.getBounds();
                    if (bounds.x > x || bounds.x + bounds.width < x || bounds.y + bounds.height > y || bounds.y + bounds.height + gap < y) continue;
                    return leaf;
                }
                break block3;
            }
            if (this.side != Side.BOTTOM && this.side != Side.TOP) break block3;
            for (Leaf leaf : leafs) {
                Rectangle bounds = leaf.getBounds();
                if (bounds.y > y || bounds.y + bounds.height < y || bounds.x + bounds.width > x || bounds.x + bounds.width + gap < x) continue;
                return leaf;
            }
        }
        return null;
    }

    public PersistentColumn[] getPersistentColumns() {
        return this.layoutManager.model.getPersistentColumns();
    }

    public void setPersistentColumns(Dockable[][] columnsAndCells, int[][] cellSizes, int[] columnSizes) {
        this.layoutManager.model.setPersistentColumns(columnsAndCells, cellSizes, columnSizes);
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public void setMaxColumnCount(int maxColumnCount) {
        if (maxColumnCount != -1 && maxColumnCount < 1) {
            throw new IllegalArgumentException("maxColumnCount is out of bounds");
        }
        this.maxColumnCount = maxColumnCount;
    }

    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty property) {
        SplitNode node = this.getRoot().getPlaceholderNode(property.getPlaceholder());
        if (!(node == null || node instanceof Leaf || node instanceof Root || !(node instanceof Placeholder) && ((Node)node).getOrientation() != this.side.getHeaderOrientation())) {
            this.pushIntoHeader(node);
        }
        return super.drop(dockable, property);
    }

    private void pushIntoHeader(SplitNode node) {
        SplitNode parent;
        while ((parent = node.getParent()) != null && !this.layoutManager.model.isHeaderLevel(parent, false)) {
            if (!(parent instanceof Node)) continue;
            Node n = (Node)parent;
            SplitNode superParent = parent.getParent();
            if (superParent instanceof Root) {
                n.setOrientation(this.side.getHeaderOrientation());
                return;
            }
            if (superParent instanceof Node) {
                SplitNode old;
                Node s = (Node)superParent;
                if (n.getLeft() == node) {
                    if (s.getLeft() == n) {
                        s.setLeft(node);
                        old = s.getRight();
                        s.setRight((SplitNode)n);
                        n.setLeft(old);
                    } else {
                        n.setLeft(s.getLeft());
                        s.setLeft(node);
                    }
                } else if (s.getRight() == n) {
                    s.setRight(node);
                    old = s.getLeft();
                    s.setLeft((SplitNode)n);
                    n.setRight(old);
                } else {
                    n.setRight(s.getRight());
                    s.setRight(node);
                }
                n.setOrientation(this.side.getColumnOrientation());
                s.setOrientation(this.side.getHeaderOrientation());
            }
            node = node.getParent();
        }
        return;
    }

    public void resetToPreferredSizes() {
        this.layoutManager.model.resetToPreferredSizes();
    }

    private class WizardDividerStrategy
    extends DefaultSplitDividerStrategy {
        private WizardDividerStrategy() {
        }

        protected DefaultSplitDividerStrategy.Handler createHandlerFor(SplitDockStation station) {
            return new CustomHandler(station);
        }

        private class CustomHandler
        extends DefaultSplitDividerStrategy.Handler {
            public CustomHandler(SplitDockStation station) {
                super(station);
            }

            protected void setDivider(Divideable node, double dividier) {
                WizardSplitDockStation.this.layoutManager.setDivider(node, dividier);
            }

            protected Divideable getDividerNode(int x, int y) {
                Divideable node = super.getDividerNode(x, y);
                if (node == null) {
                    int gap = WizardSplitDockStation.this.getDividerSize();
                    if (WizardSplitDockStation.this.side == Side.RIGHT && x <= gap) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.LEFT && x >= WizardSplitDockStation.this.getWidth() - gap - 1) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.TOP && y >= WizardSplitDockStation.this.getHeight() - gap - 1) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    if (WizardSplitDockStation.this.side == Side.BOTTOM && y <= gap) {
                        return new ColumnDividier(WizardSplitDockStation.this);
                    }
                    Leaf leaf = WizardSplitDockStation.this.resizeableLeafAt(x, y);
                    if (leaf != null) {
                        return new CellDivider(WizardSplitDockStation.this, leaf);
                    }
                }
                return node;
            }
        }
    }

    public class WizardLayoutManager
    extends DefaultSplitLayoutManager {
        private WizardColumnModel model;

        public WizardLayoutManager() {
            this.model = new WizardColumnModel(WizardSplitDockStation.this);
        }

        public PutInfo validatePutInfo(SplitDockStation station, PutInfo putInfo) {
            if ((putInfo = this.ensureDropLocation(putInfo)) != null) {
                return super.validatePutInfo(station, putInfo);
            }
            return null;
        }

        public Leaf[] getLastLeafOfColumns() {
            return this.model.getLastLeafOfColumns();
        }

        protected PutInfo calculateSideSnap(SplitDockStation station, int x, int y, Leaf leaf, Dockable drop) {
            int i;
            WizardSpanStrategy spanStrategy = WizardSplitDockStation.this.getWizardSpanStrategy();
            WizardLayoutManager layout = WizardSplitDockStation.this.getWizardSplitLayoutManager();
            WizardNodeMap map = layout.getMap();
            WizardNodeMap.Column[] columns = map.getSortedColumns();
            int columnCount = map.getColumnCount();
            int first = 0;
            int total = 0;
            if (columnCount > 0) {
                total = first = spanStrategy.getGap(0);
                for (i = 1; i < columnCount; ++i) {
                    total += spanStrategy.getGap(i);
                }
            }
            if (WizardSplitDockStation.this.side.getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                for (i = 0; i < columnCount; ++i) {
                    Rectangle bounds = columns[i].getBounds();
                    if (x < bounds.x || x > bounds.x + bounds.width) continue;
                    if (y < bounds.y) {
                        return new PutInfo(columns[i].getRoot(), PutInfo.Put.TOP, drop, false);
                    }
                    if (y > bounds.y + bounds.height) {
                        return new PutInfo(columns[i].getRoot(), PutInfo.Put.BOTTOM, drop, false);
                    }
                    if (x < bounds.x + bounds.width / 2) {
                        return new PutInfo(columns[i].getRoot(), PutInfo.Put.LEFT, drop, false);
                    }
                    return new PutInfo(columns[i].getRoot(), PutInfo.Put.RIGHT, drop, false);
                }
                int width = WizardSplitDockStation.this.getWidth() - total;
                if ((x -= first) < width / 2) {
                    return new PutInfo(this.leftMost((SplitNode)WizardSplitDockStation.this.getRoot()), PutInfo.Put.LEFT, drop, false);
                }
                return new PutInfo(this.rightMost((SplitNode)WizardSplitDockStation.this.getRoot()), PutInfo.Put.RIGHT, drop, false);
            }
            for (i = 0; i < columnCount; ++i) {
                Rectangle bounds = columns[i].getBounds();
                if (y < bounds.y || y > bounds.y + bounds.height) continue;
                if (x < bounds.x) {
                    return new PutInfo(columns[i].getRoot(), PutInfo.Put.LEFT, drop, false);
                }
                if (x > bounds.x + bounds.width) {
                    return new PutInfo(columns[i].getRoot(), PutInfo.Put.RIGHT, drop, false);
                }
                if (y < bounds.y + bounds.height / 2) {
                    return new PutInfo(columns[i].getRoot(), PutInfo.Put.TOP, drop, false);
                }
                return new PutInfo(columns[i].getRoot(), PutInfo.Put.BOTTOM, drop, false);
            }
            int height = WizardSplitDockStation.this.getHeight() - total;
            if ((y -= first) < height / 2) {
                return new PutInfo(this.leftMost((SplitNode)WizardSplitDockStation.this.getRoot()), PutInfo.Put.TOP, drop, false);
            }
            return new PutInfo(this.rightMost((SplitNode)WizardSplitDockStation.this.getRoot()), PutInfo.Put.BOTTOM, drop, false);
        }

        private SplitNode leftMost(SplitNode node) {
            while (node.getMaxChildrenCount() > 0) {
                node = node.getChild(0);
            }
            return node;
        }

        private SplitNode rightMost(SplitNode node) {
            int max;
            while ((max = node.getMaxChildrenCount()) > 0) {
                node = node.getChild(max - 1);
            }
            return node;
        }

        private PutInfo ensureDropLocation(PutInfo putInfo) {
            if (putInfo != null) {
                boolean header;
                if (WizardSplitDockStation.this.side.getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    header = putInfo.getPut() == PutInfo.Put.LEFT || putInfo.getPut() == PutInfo.Put.RIGHT;
                } else {
                    boolean bl = header = putInfo.getPut() == PutInfo.Put.TOP || putInfo.getPut() == PutInfo.Put.BOTTOM;
                }
                if (header) {
                    SplitNode node;
                    boolean canHaveNewColumns;
                    int columnCount = this.getMap().getColumnCount();
                    boolean bl = canHaveNewColumns = WizardSplitDockStation.this.maxColumnCount == -1 || columnCount < WizardSplitDockStation.this.maxColumnCount;
                    if (!canHaveNewColumns) {
                        return null;
                    }
                    for (node = putInfo.getNode(); node != null && !this.model.isHeaderLevel(node); node = node.getParent()) {
                    }
                    putInfo.setNode(node);
                }
            }
            return putInfo;
        }

        public void updateBounds(Root root, double x, double y, double factorW, double factorH) {
            this.model.setFactors(factorW, factorH);
            this.model.updateBounds(x, y);
        }

        public double validateDivider(SplitDockStation station, double divider, Node node) {
            return this.model.validateDivider(divider, node);
        }

        public double validateDivider(double divider, Leaf leaf) {
            return this.model.validateDivider(divider, leaf);
        }

        public double validateColumnDivider(double divider) {
            return this.model.validateColumnDivider(divider);
        }

        public Dimension getPreferredSize() {
            return this.model.getPreferredSize();
        }

        public void setDivider(Divideable node, double divider) {
            this.model.setDivider(node, divider);
            WizardSplitDockStation.this.revalidate();
        }

        public WizardNodeMap getMap() {
            return this.model.getMap();
        }
    }

    public static enum Side {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public SplitDockStation.Orientation getHeaderOrientation() {
            switch (this) {
                case LEFT: 
                case RIGHT: {
                    return SplitDockStation.Orientation.HORIZONTAL;
                }
                case TOP: 
                case BOTTOM: {
                    return SplitDockStation.Orientation.VERTICAL;
                }
            }
            throw new IllegalStateException("unknown: " + (Object)((Object)this));
        }

        public SplitDockStation.Orientation getColumnOrientation() {
            switch (this) {
                case LEFT: 
                case RIGHT: {
                    return SplitDockStation.Orientation.VERTICAL;
                }
                case TOP: 
                case BOTTOM: {
                    return SplitDockStation.Orientation.HORIZONTAL;
                }
            }
            throw new IllegalStateException("unknown: " + (Object)((Object)this));
        }
    }
}

