/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

public enum ExpandedState {
    EXPANDED,
    STRETCHED,
    SHRUNK;


    public static ExpandedState getOrdered(int size) {
        switch (size) {
            case 0: {
                return SHRUNK;
            }
            case 1: {
                return STRETCHED;
            }
            case 2: {
                return EXPANDED;
            }
        }
        throw new IllegalArgumentException("size out of bounds: " + size);
    }

    public int getOrder() {
        switch (this) {
            case SHRUNK: {
                return 0;
            }
            case STRETCHED: {
                return 1;
            }
            case EXPANDED: {
                return 2;
            }
        }
        throw new IllegalStateException("never happens");
    }

    public ExpandedState smaller() {
        int order = this.getOrder() - 1;
        if (order < 0) {
            return this;
        }
        return ExpandedState.getOrdered(order);
    }

    public ExpandedState larger() {
        int order = this.getOrder() + 1;
        if (order >= ExpandedState.values().length) {
            return this;
        }
        return ExpandedState.getOrdered(order);
    }
}

