/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import java.util.ArrayList;
import java.util.List;

public class DefaultExpandableToolbarItemStrategy
implements ExpandableToolbarItemStrategy {
    private final List<ExpandableToolbarItemStrategyListener> listeners = new ArrayList<ExpandableToolbarItemStrategyListener>();
    private DockController controller;
    private final DockRegisterListener registerListener = new DockRegisterAdapter(){

        public void dockStationRegistered(DockController controller, DockStation station) {
            DefaultExpandableToolbarItemStrategy.this.handleAdd(station);
        }

        public void dockableRegistered(DockController controller, Dockable dockable) {
            DefaultExpandableToolbarItemStrategy.this.handleAdd(dockable);
        }

        public void dockStationUnregistered(DockController controller, DockStation station) {
            DefaultExpandableToolbarItemStrategy.this.handleRemove(station);
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DefaultExpandableToolbarItemStrategy.this.handleRemove(dockable);
        }
    };
    private final ExpandableToolbarItemListener expandableListener = new ExpandableToolbarItemListener(){

        @Override
        public void changed(ExpandableToolbarItem item, ExpandedState oldState, ExpandedState newState) {
            DefaultExpandableToolbarItemStrategy.this.fire(item, newState);
        }

        @Override
        public void enablementChanged(ExpandableToolbarItem item, ExpandedState state, boolean enabled) {
            for (ExpandableToolbarItemStrategyListener listener : DefaultExpandableToolbarItemStrategy.this.listeners()) {
                listener.enablementChanged(item, state, enabled);
            }
        }
    };

    protected void handleAdd(Dockable dockable) {
        if (dockable.asDockStation() == null && dockable instanceof ExpandableToolbarItem) {
            ExpandableToolbarItem item = (ExpandableToolbarItem)dockable;
            item.addExpandableListener(this.expandableListener);
            this.fire(item);
        }
    }

    protected void handleAdd(DockStation station) {
        if (station instanceof ExpandableToolbarItem) {
            ExpandableToolbarItem item = (ExpandableToolbarItem)station;
            item.addExpandableListener(this.expandableListener);
            this.fire(item);
        }
    }

    private void fire(ExpandableToolbarItem item) {
        this.fire(item, this.getState(item));
        for (ExpandedState state : ExpandedState.values()) {
            boolean enabled = this.isEnabled(item, state);
            for (ExpandableToolbarItemStrategyListener listener : this.listeners()) {
                listener.enablementChanged(item, state, enabled);
            }
        }
    }

    private void fire(ExpandableToolbarItem item, ExpandedState state) {
        switch (state) {
            case EXPANDED: {
                for (ExpandableToolbarItemStrategyListener listener : this.listeners()) {
                    listener.expanded(item);
                }
                break;
            }
            case SHRUNK: {
                for (ExpandableToolbarItemStrategyListener listener : this.listeners()) {
                    listener.shrunk(item);
                }
                break;
            }
            case STRETCHED: {
                for (ExpandableToolbarItemStrategyListener listener : this.listeners()) {
                    listener.stretched(item);
                }
                break;
            }
        }
    }

    protected void handleRemove(Dockable dockable) {
        if (dockable.asDockStation() == null && dockable instanceof ExpandableToolbarItem) {
            ((ExpandableToolbarItem)dockable).removeExpandableListener(this.expandableListener);
        }
    }

    protected void handleRemove(DockStation station) {
        if (station instanceof ExpandableToolbarItem) {
            ((ExpandableToolbarItem)station).addExpandableListener(this.expandableListener);
        }
    }

    @Override
    public void install(DockController controller) {
        if (this.controller != null) {
            throw new IllegalStateException("this strategy is already installed");
        }
        this.controller = controller;
        DockRegister register = controller.getRegister();
        register.addDockRegisterListener(this.registerListener);
        int n = register.getStationCount();
        for (int i = 0; i < n; ++i) {
            this.handleAdd(register.getStation(i));
        }
    }

    @Override
    public void uninstall(DockController controller) {
        if (this.controller != controller) {
            throw new IllegalStateException("this strategy is not installed at '" + controller + "'");
        }
        DockRegister register = controller.getRegister();
        register.removeDockRegisterListener(this.registerListener);
        int n = register.getStationCount();
        for (int i = 0; i < n; ++i) {
            this.handleRemove(register.getStation(i));
        }
    }

    @Override
    public boolean isEnabled(Dockable item, ExpandedState state) {
        if (item instanceof ExpandableToolbarItem) {
            return ((ExpandableToolbarItem)item).isEnabled(state);
        }
        return false;
    }

    @Override
    public ExpandedState getState(Dockable item) {
        if (item instanceof ExpandableToolbarItem) {
            return ((ExpandableToolbarItem)item).getExpandedState();
        }
        return null;
    }

    @Override
    public void setState(Dockable item, ExpandedState state) {
        ((ExpandableToolbarItem)item).setExpandedState(state);
    }

    @Override
    public void addExpandedListener(ExpandableToolbarItemStrategyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeExpandedListener(ExpandableToolbarItemStrategyListener listener) {
        this.listeners.remove(listener);
    }

    protected ExpandableToolbarItemStrategyListener[] listeners() {
        return this.listeners.toArray(new ExpandableToolbarItemStrategyListener[this.listeners.size()]);
    }
}

