/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LineDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.AbstractMultiDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ColumnDockTitle
extends AbstractMultiDockTitle {
    private List<ButtonPanel> itemPanels = new ArrayList<ButtonPanel>();
    private ButtonPanel directPanel;
    private ColumnDockActionSource source;
    private ColumnDockActionSourceListener listener = new ColumnDockActionSourceListener(){

        @Override
        public void reshaped(ColumnDockActionSource source) {
            ColumnDockTitle.this.revalidate();
        }

        @Override
        public void removed(ColumnDockActionSource source, DockActionSource item, int index) {
            if (ColumnDockTitle.this.isBound()) {
                ButtonPanel panel = (ButtonPanel)ColumnDockTitle.this.itemPanels.remove(index);
                panel.set(null);
                panel.setController(null);
                ColumnDockTitle.this.remove((Component)panel);
                ColumnDockTitle.this.revalidate();
            }
        }

        @Override
        public void inserted(ColumnDockActionSource source, DockActionSource item, int index) {
            if (ColumnDockTitle.this.isBound()) {
                ColumnDockTitle.this.createPanel(item, index);
            }
        }
    };

    public ColumnDockTitle(Dockable dockable, DockTitleVersion origin) {
        this.init(dockable, origin);
        this.directPanel = new ButtonPanel(true){

            protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
                return ColumnDockTitle.this.createItemFor(action, dockable);
            }
        };
        this.add((Component)this.directPanel);
    }

    private void createPanel(DockActionSource item, int index) {
        ButtonPanel panel = new ButtonPanel(true){

            protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
                return ColumnDockTitle.this.createItemFor(action, dockable);
            }
        };
        panel.set(this.getDockable(), item);
        panel.setController(this.getDockable().getController());
        panel.setOrientation(this.getOrientation());
        panel.setToolTipText(this.getToolTipText());
        this.itemPanels.add(index, panel);
        this.add((Component)panel);
        this.revalidate();
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.getOrientation() != orientation) {
            super.setOrientation(orientation);
            for (ButtonPanel panel : this.itemPanels) {
                panel.setOrientation(orientation);
            }
            this.directPanel.setOrientation(orientation);
            this.revalidate();
        }
    }

    protected abstract ColumnDockActionSource getSourceFor(Dockable var1);

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return new LineDockActionSource(dockable.getGlobalActionOffers());
    }

    public void bind() {
        if (!this.isBound()) {
            Dockable dockable = this.getDockable();
            this.source = this.getSourceFor(dockable);
            if (this.source != null) {
                int n = this.source.getSourceCount();
                for (int i = 0; i < n; ++i) {
                    this.createPanel(this.source.getSource(i), i);
                }
                this.source.addListener(this.listener);
            }
            this.directPanel.set(dockable, this.getActionSourceFor(dockable));
        }
        super.bind();
    }

    public void unbind() {
        super.unbind();
        if (!this.isBound() && this.source != null) {
            this.source.removeListener(this.listener);
            for (ButtonPanel panel : this.itemPanels) {
                panel.set(null);
                panel.setController(null);
                this.remove((Component)panel);
            }
            this.directPanel.set(null);
            this.itemPanels.clear();
            this.revalidate();
            this.source = null;
        }
    }

    protected void updateIcon() {
    }

    protected void updateText() {
    }

    private int getOffset(int sourceIndex) {
        int offset = this.source.getSourceOffset(sourceIndex);
        Component dockable = this.getDockable().getComponent();
        Point point = new Point(offset, offset);
        if (SwingUtilities.getRoot((Component)((Object)this)) == SwingUtilities.getRoot(dockable)) {
            point = SwingUtilities.convertPoint(dockable, point, (Component)((Object)this));
        }
        if (this.source.getOrientation() == Orientation.VERTICAL) {
            return point.x;
        }
        return point.y;
    }

    protected void doTitleLayout() {
        if (this.source == null) {
            return;
        }
        Insets insets = this.titleInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        boolean horizontal = this.getOrientation().isHorizontal();
        int n = this.source.getSourceCount();
        for (int i = 0; i < n; ++i) {
            int j;
            int remaining;
            int j2;
            int delta;
            int size;
            int start = this.getOffset(i);
            int length = this.source.getSourceLength(i);
            ButtonPanel items = this.itemPanels.get(i);
            Dimension[] preferred = items.getPreferredSizes();
            Dimension[] directPreferred = null;
            if (i + 1 == n) {
                directPreferred = this.directPanel.getPreferredSizes();
                length = horizontal ? (length -= directPreferred[0].width) : (length -= directPreferred[0].height);
            }
            if (horizontal) {
                size = 0;
                delta = 0;
                for (j2 = preferred.length - 1; j2 >= 0; --j2) {
                    if (preferred[j2].width > length) continue;
                    size = j2;
                    delta = length - preferred[j2].width;
                    break;
                }
                items.setVisibleActions(size);
                items.setBounds(start, y, length - delta, height);
                if (i + 1 != n) continue;
                remaining = width - start - length + delta;
                size = 0;
                delta = 0;
                for (j = directPreferred.length - 1; j >= 0; --j) {
                    if (directPreferred[j].width > remaining) continue;
                    size = j;
                    delta = remaining - directPreferred[j].width;
                    break;
                }
                this.directPanel.setVisibleActions(size);
                this.directPanel.setBounds(x + width - remaining + delta, y, remaining - delta, height);
                continue;
            }
            size = 0;
            delta = 0;
            for (j2 = preferred.length - 1; j2 >= 0; --j2) {
                if (preferred[j2].height > length) continue;
                size = j2;
                delta = length - preferred[j2].height;
                break;
            }
            items.setVisibleActions(size);
            items.setBounds(x, start, width, length - delta);
            if (i + 1 != n) continue;
            remaining = height - start - length + delta;
            size = 0;
            delta = 0;
            for (j = directPreferred.length - 1; j >= 0; --j) {
                if (directPreferred[j].height > remaining) continue;
                size = j;
                delta = remaining - directPreferred[j].height;
                break;
            }
            this.directPanel.setVisibleActions(size);
            this.directPanel.setBounds(x, y + height - remaining + delta, width, remaining - delta);
        }
    }

    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        if (this.source != null) {
            int i;
            if (this.getOrientation().isHorizontal()) {
                int n = this.source.getSourceCount();
                for (i = 0; i < n; ++i) {
                    w = Math.max(w, this.getOffset(i) + this.source.getSourceLength(i));
                    h = Math.max(h, this.itemPanels.get((int)i).getPreferredSize().height);
                }
            } else {
                int n = this.source.getSourceCount();
                for (i = 0; i < n; ++i) {
                    w = Math.max(w, this.itemPanels.get((int)i).getPreferredSize().width);
                    h = Math.max(h, this.getOffset(i) + this.source.getSourceLength(i));
                }
            }
        }
        w = Math.max(w, 5);
        h = Math.max(h, 5);
        Insets insets = this.titleInsets();
        return new Dimension(w += insets.left + insets.right, h += insets.top + insets.bottom);
    }
}

