/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.station.toolbar.menu.GroupedCustomizationMenuTitle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class GroupedCustomizationMenuContent
implements CustomizationMenuContent {
    private int columns = 5;
    private List<Group> groups = new ArrayList<Group>();
    private JPanel view;
    private DockController controller;
    private CustomizationMenuCallback callback;
    private Insets insets = new Insets(2, 2, 2, 2);

    public Group addGroup(String title) {
        Group group = new Group(new GroupedCustomizationMenuTitle(title));
        this.addGroup(group);
        return group;
    }

    public void addGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        if (this.groups.contains(group)) {
            throw new IllegalArgumentException("group was already added to this menu");
        }
        if (group.getOwner() != this) {
            throw new IllegalArgumentException("group was not created using this menu object");
        }
        this.groups.add(group);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Group getGroup(int index) {
        return this.groups.get(index);
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void removeGroup(int index) {
        this.groups.remove(index);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            if (this.callback != null) {
                for (Group group : this.groups) {
                    group.setController(controller);
                }
            }
        }
    }

    @Override
    public void bind(CustomizationMenuCallback callback) {
        this.callback = callback;
        for (Group group : this.groups) {
            group.setController(this.controller);
            group.bind(callback);
        }
        this.view = new JPanel(new GridBagLayout());
        int offset = 0;
        for (Group group : this.groups) {
            offset += group.insertItems(offset);
        }
    }

    @Override
    public void unbind() {
        for (Group group : this.groups) {
            group.unbind();
            group.setController(null);
        }
    }

    public class Group {
        private CustomizationMenuContent title;
        private List<CustomizationMenuContent> items = new ArrayList<CustomizationMenuContent>();

        public Group(CustomizationMenuContent title) {
            this.title = title;
        }

        public void setTitle(CustomizationMenuContent title) {
            this.title = title;
        }

        public CustomizationMenuContent getTitle() {
            return this.title;
        }

        private GroupedCustomizationMenuContent getOwner() {
            return GroupedCustomizationMenuContent.this;
        }

        private void setController(DockController controller) {
            if (this.title != null) {
                this.title.setController(controller);
            }
            for (CustomizationMenuContent item : this.items) {
                item.setController(controller);
            }
        }

        private void bind(CustomizationMenuCallback callback) {
            if (this.title != null) {
                this.title.bind(callback);
            }
            for (CustomizationMenuContent item : this.items) {
                item.bind(callback);
            }
        }

        private int insertItems(int offset) {
            int begin = offset;
            if (this.title != null) {
                GroupedCustomizationMenuContent.this.view.add(this.title.getView(), new GridBagConstraints(0, offset, GroupedCustomizationMenuContent.this.columns, 1, 1.0, 0.01, 10, 2, GroupedCustomizationMenuContent.this.insets, 0, 0));
                ++offset;
            }
            int index = 0;
            int length = this.items.size();
            while (index < length) {
                for (int i = 0; i < GroupedCustomizationMenuContent.this.columns && index < length; ++i) {
                    GroupedCustomizationMenuContent.this.view.add(this.items.get(index++).getView(), new GridBagConstraints(i, offset, 1, 1, 1.0, 1.0, 10, 1, GroupedCustomizationMenuContent.this.insets, 0, 0));
                }
                ++offset;
            }
            return offset - begin;
        }

        private void unbind() {
            if (this.title != null) {
                this.title.unbind();
            }
            for (CustomizationMenuContent item : this.items) {
                item.unbind();
            }
        }

        public void add(CustomizationMenuContent item) {
            this.add(this.getItemCount(), item);
        }

        public void add(int index, CustomizationMenuContent item) {
            this.items.add(index, item);
        }

        public void remove(CustomizationMenuContent item) {
            if (this.items.remove(item)) {
                // empty if block
            }
        }

        public void remove(int index) {
            this.items.remove(index);
        }

        public int getItemCount() {
            return this.items.size();
        }

        public CustomizationMenuContent getItem(int index) {
            return this.items.get(index);
        }
    }
}

