/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationToolbarButton;
import javax.swing.Icon;

public class EagerCustomizationToolbarButton
extends CustomizationToolbarButton {
    private Dockable dockable;
    private DockableListener listener = new DockableAdapter(){

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            EagerCustomizationToolbarButton.this.setIcon(newIcon);
        }

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            EagerCustomizationToolbarButton.this.setText(newTitle);
        }

        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            EagerCustomizationToolbarButton.this.setDescription(newTooltip);
        }
    };

    public EagerCustomizationToolbarButton(Dockable dockable) {
        this.dockable = dockable;
    }

    @Override
    protected boolean hasDockable() {
        return true;
    }

    @Override
    protected Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public void bind(CustomizationMenuCallback callback) {
        this.dockable.addDockableListener(this.listener);
        if (this.dockable.getTitleIcon() != null) {
            this.setIcon(this.dockable.getTitleIcon());
        } else {
            this.setText(this.dockable.getTitleText());
        }
        this.setDescription(this.dockable.getTitleToolTip());
        super.bind(callback);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.dockable.removeDockableListener(this.listener);
        this.setIcon(null);
        this.setDescription(null);
        this.setText(null);
    }
}

