/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToggleButton;

public abstract class CustomizationToolbarButton
implements CustomizationMenuContent {
    private DockController controller;
    private Icon icon;
    private String description;
    private String text;
    private JLayeredPane base;
    private JToggleButton button;
    private JLabel elsewhere;
    private CustomizationMenuCallback callback;
    private DockIcon elsewhereIcon = new DockIcon("toolbar.customization.check", DockIcon.KIND_ICON){

        protected void changed(Icon oldValue, Icon newValue) {
            if (CustomizationToolbarButton.this.elsewhere != null) {
                CustomizationToolbarButton.this.elsewhere.setIcon(newValue);
            }
        }
    };

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        if (this.callback != null) {
            this.elsewhereIcon.setController(controller);
        }
    }

    @Override
    public Component getView() {
        return this.base;
    }

    @Override
    public void bind(CustomizationMenuCallback callback) {
        this.callback = callback;
        this.button = new JToggleButton();
        this.button.setIcon(this.icon);
        this.button.setToolTipText(this.description);
        this.button.setText(this.text);
        this.button.setOpaque(false);
        this.elsewhere = new JLabel();
        this.elsewhereIcon.setController(this.controller);
        this.elsewhere.setIcon((Icon)this.elsewhereIcon.value());
        this.elsewhere.setVisible(false);
        this.base = new JLayeredPane();
        this.base.add(this.button);
        this.base.add(this.elsewhere);
        this.base.setLayer(this.button, JLayeredPane.DEFAULT_LAYER);
        this.base.setLayer(this.elsewhere, JLayeredPane.MODAL_LAYER);
        this.base.setLayout(new LayoutManager(){

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(((CustomizationToolbarButton)CustomizationToolbarButton.this).button.getPreferredSize().width + ((CustomizationToolbarButton)CustomizationToolbarButton.this).elsewhere.getPreferredSize().width + 1, ((CustomizationToolbarButton)CustomizationToolbarButton.this).button.getPreferredSize().height);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return CustomizationToolbarButton.this.button.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                if (parent.getComponentCount() == 2) {
                    int width = parent.getWidth();
                    int height = parent.getHeight();
                    Dimension preferred = CustomizationToolbarButton.this.elsewhere.getPreferredSize();
                    int labelWidth = Math.min(preferred.width, width - 1);
                    int labelHeight = Math.min(preferred.height, height - 1);
                    CustomizationToolbarButton.this.button.setBounds(labelWidth + 2, 0, width - labelWidth - 2, height);
                    CustomizationToolbarButton.this.elsewhere.setBounds(1, 0, labelWidth, labelHeight);
                }
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemLocation location = CustomizationToolbarButton.this.getItemLocation();
                CustomizationToolbarButton.this.setItemVisible(location != ItemLocation.HERE);
            }
        });
        this.select();
    }

    private void select() {
        ItemLocation location = this.getItemLocation();
        this.elsewhere.setVisible(location == ItemLocation.HERE || location == ItemLocation.ELSEWHERE);
        this.button.setSelected(location == ItemLocation.HERE);
    }

    protected ItemLocation getItemLocation() {
        if (this.callback == null) {
            throw new IllegalStateException("this information is only available if the button has been bound");
        }
        if (!this.hasDockable()) {
            return ItemLocation.INVISIBLE;
        }
        Dockable item = this.getDockable();
        DockStation parent = item.getDockParent();
        if (parent == null) {
            return ItemLocation.INVISIBLE;
        }
        DockStation owner = this.callback.getOwner();
        while (parent != null) {
            if (parent == owner) {
                return ItemLocation.HERE;
            }
            item = parent.asDockable();
            if (item == null) {
                parent = null;
                continue;
            }
            parent = item.getDockParent();
        }
        return ItemLocation.ELSEWHERE;
    }

    protected void setItemVisible(boolean visible) {
        Dockable item = this.getDockable();
        DockStation parent = item.getDockParent();
        if (parent != null) {
            parent.drag(item);
        }
        if (visible) {
            this.callback.append(item);
        }
        this.select();
    }

    @Override
    public void unbind() {
        this.base = null;
        this.button = null;
        this.elsewhere = null;
        this.elsewhereIcon.setController(null);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.button != null) {
            this.button.setText(text);
        }
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.button != null) {
            this.button.setToolTipText(description);
        }
    }

    protected abstract boolean hasDockable();

    protected abstract Dockable getDockable();

    public static enum ItemLocation {
        INVISIBLE,
        ELSEWHERE,
        HERE;

    }
}

