/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategyFactory;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DefaultToolbarGroupDividierStrategy
implements ToolbarGroupDividerStrategy {
    public static final ToolbarGroupDividerStrategyFactory FACTORY = new ToolbarGroupDividerStrategyFactory(){

        @Override
        public ToolbarGroupDividerStrategy create(ToolbarGroupDockStation station) {
            return new DefaultToolbarGroupDividierStrategy(station);
        }
    };
    private ToolbarGroupDockStation station;

    public DefaultToolbarGroupDividierStrategy(ToolbarGroupDockStation station) {
        this.station = station;
    }

    @Override
    public int getColumn(int index) {
        return 1;
    }

    @Override
    public int getLine(int column, int index) {
        if (index == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public void paint(Component parent, Graphics g, ToolbarGridLayoutManager<StationChildHandle> layoutManager) {
        g.setColor(parent.getForeground());
        Orientation orientation = this.station.getOrientation();
        ToolbarColumnModel<Dockable, StationChildHandle> model = this.station.getColumnModel();
        int n = model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ToolbarColumn<Dockable, StationChildHandle> column = model.getColumn((Dockable)i);
            int m = column.getDockableCount();
            for (int j = 0; j < m; ++j) {
                Rectangle bounds = layoutManager.getBounds(i, j);
                if (j == 0) {
                    switch (orientation) {
                        case HORIZONTAL: {
                            g.drawRect(bounds.x, bounds.y - 1, bounds.width, bounds.height + 1);
                            break;
                        }
                        case VERTICAL: {
                            g.drawRect(bounds.x - 1, bounds.y, bounds.width + 1, bounds.height);
                        }
                    }
                    continue;
                }
                g.drawRect(bounds.x - 1, bounds.y - 1, bounds.width + 1, bounds.height + 1);
            }
        }
    }
}

