/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSourceListener;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractToolbarGroupActions<P, C extends Column>
implements ColumnDockActionSource {
    private ToolbarColumnModel<Dockable, P> model;
    private List<C> columns = new ArrayList<C>();
    private List<ColumnDockActionSourceListener> listeners = new ArrayList<ColumnDockActionSourceListener>();
    private ToolbarGroupDockStation station;
    private ToolbarColumnModelListener<Dockable, P> modelListener = new ToolbarColumnModelListener<Dockable, P>(){

        @Override
        public void removed(ToolbarColumnModel<Dockable, P> model, ToolbarColumn<Dockable, P> column, int index) {
            Column col = (Column)AbstractToolbarGroupActions.this.columns.remove(index);
            for (ColumnDockActionSourceListener listener : AbstractToolbarGroupActions.this.listeners()) {
                listener.removed(AbstractToolbarGroupActions.this, col.getSource(), index);
            }
            col.destroy();
        }

        @Override
        public void inserted(ToolbarColumnModel<Dockable, P> model, ToolbarColumn<Dockable, P> column, int index) {
            Object col = AbstractToolbarGroupActions.this.createColumn(column);
            AbstractToolbarGroupActions.this.columns.add(index, col);
            for (ColumnDockActionSourceListener listener : AbstractToolbarGroupActions.this.listeners()) {
                listener.inserted(AbstractToolbarGroupActions.this, ((Column)col).getSource(), index);
            }
            int n = column.getDockableCount();
            for (int i = 0; i < n; ++i) {
                ((Column)col).inserted(i, column.getItem(i));
            }
        }
    };
    private ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            for (ColumnDockActionSourceListener listener : AbstractToolbarGroupActions.this.listeners()) {
                listener.reshaped(AbstractToolbarGroupActions.this);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            for (ColumnDockActionSourceListener listener : AbstractToolbarGroupActions.this.listeners()) {
                listener.reshaped(AbstractToolbarGroupActions.this);
            }
        }
    };

    public AbstractToolbarGroupActions(ToolbarGroupDockStation station) {
        this.station = station;
    }

    @Override
    public void addListener(ColumnDockActionSourceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ColumnDockActionSourceListener listener) {
        this.listeners.remove(listener);
    }

    protected ColumnDockActionSourceListener[] listeners() {
        return this.listeners.toArray(new ColumnDockActionSourceListener[this.listeners.size()]);
    }

    public void setModel(ToolbarColumnModel<Dockable, P> model) {
        if (this.model != model) {
            int i;
            if (this.model != null) {
                this.model.removeListener(this.modelListener);
                for (i = this.columns.size() - 1; i >= 0; --i) {
                    Column column = (Column)this.columns.get(i);
                    this.modelListener.removed(model, column.getColumn(), i);
                }
            }
            this.model = model;
            if (model != null) {
                model.addListener(this.modelListener);
                int n = model.getColumnCount();
                for (i = 0; i < n; ++i) {
                    this.modelListener.inserted(model, model.getColumn((Dockable)i), i);
                }
            }
        }
    }

    public ToolbarColumnModel<Dockable, P> getModel() {
        return this.model;
    }

    protected List<C> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getSourceCount() {
        return this.getColumnCount();
    }

    @Override
    public DockActionSource getSource(int index) {
        return ((Column)this.getColumn(index)).getSource();
    }

    @Override
    public Orientation getOrientation() {
        return this.station.getOrientation();
    }

    public C getColumn(int index) {
        return (C)((Column)this.columns.get(index));
    }

    protected C getColumn(Dockable dockable) {
        for (Column column : this.columns) {
            if (!column.getDockables().contains(dockable)) continue;
            return (C)column;
        }
        return null;
    }

    @Override
    public int getSourceOffset(int index) {
        Rectangle boundaries = ((Column)this.getColumn(index)).getColumnBoundaries();
        if (boundaries == null) {
            return -1;
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            return boundaries.x;
        }
        return boundaries.y;
    }

    @Override
    public int getSourceLength(int index) {
        Rectangle boundaries = ((Column)this.getColumn(index)).getColumnBoundaries();
        if (boundaries == null) {
            return 0;
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            return boundaries.width;
        }
        return boundaries.height;
    }

    protected abstract C createColumn(ToolbarColumn<Dockable, P> var1);

    protected abstract Rectangle getBoundaries(P var1);

    protected abstract void installListener(P var1, ComponentListener var2);

    protected abstract void uninstallListener(P var1, ComponentListener var2);

    protected abstract class Column {
        private ToolbarColumn<Dockable, P> column;
        private boolean created = false;
        private DockActionSource source;
        private List<P> items = new ArrayList();
        private List<Dockable> dockables = new ArrayList<Dockable>();
        private ToolbarColumnListener<Dockable, P> listener = new ToolbarColumnListener<Dockable, P>(){

            @Override
            public void removed(ToolbarColumn<Dockable, P> column, P item, Dockable dockable, int index) {
                Column.this.items.remove(index);
                Column.this.dockables.remove(index);
                AbstractToolbarGroupActions.this.uninstallListener(item, AbstractToolbarGroupActions.this.componentListener);
                Column.this.removed(index, item);
            }

            @Override
            public void inserted(ToolbarColumn<Dockable, P> column, P item, Dockable dockable, int index) {
                Column.this.items.add(index, item);
                Column.this.dockables.add(index, dockable);
                AbstractToolbarGroupActions.this.installListener(item, AbstractToolbarGroupActions.this.componentListener);
                Column.this.inserted(index, item);
            }
        };

        public Column(ToolbarColumn<Dockable, P> column) {
            if (column != null) {
                this.init(column);
            }
        }

        protected void init(ToolbarColumn<Dockable, P> column) {
            this.column = column;
            this.column.addListener(this.listener);
            int n = column.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.listener.inserted(column, column.getItem(i), column.getDockable(i), i);
            }
        }

        public DockActionSource getSource() {
            if (!this.created) {
                this.created = true;
                this.source = this.createSource();
            }
            return this.source;
        }

        public List<P> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        public List<Dockable> getDockables() {
            return Collections.unmodifiableList(this.dockables);
        }

        public ToolbarColumn<Dockable, P> getColumn() {
            return this.column;
        }

        public Rectangle getColumnBoundaries() {
            Rectangle result = null;
            for (Object item : this.getItems()) {
                Rectangle next = AbstractToolbarGroupActions.this.getBoundaries(item);
                if (result == null) {
                    result = new Rectangle(next);
                    continue;
                }
                result = result.union(next);
            }
            return result;
        }

        protected abstract DockActionSource createSource();

        protected abstract void inserted(int var1, P var2);

        protected abstract void removed(int var1, P var2);

        private void destroy() {
            this.column.removeListener(this.listener);
            for (Object item : this.getItems()) {
                AbstractToolbarGroupActions.this.uninstallListener(item, AbstractToolbarGroupActions.this.componentListener);
            }
            this.removed();
        }

        protected abstract void removed();
    }
}

