/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarGroupDockStationFactory
implements DockFactory<ToolbarGroupDockStation, ToolbarGroupDockPerspective, ToolbarGroupDockStationLayout> {
    public static final String ID = "ToolbarGroupDockStationFactory";

    public String getID() {
        return ID;
    }

    public ToolbarGroupDockStationLayout getLayout(ToolbarGroupDockStation element, Map<Dockable, Integer> children) {
        PlaceholderMap map = element.getPlaceholders(children);
        return new ToolbarGroupDockStationLayout(map, element.getExpandedState());
    }

    public ToolbarGroupDockStationLayout getPerspectiveLayout(ToolbarGroupDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        return new ToolbarGroupDockStationLayout(element.toMap(children), element.getExpandedState());
    }

    public void setLayout(ToolbarGroupDockStation element, ToolbarGroupDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        element.setExpandedState(layout.getState(), false);
        element.setPlaceholders(layout.getPlaceholders(), children);
    }

    public void setLayout(ToolbarGroupDockStation element, ToolbarGroupDockStationLayout layout, PlaceholderStrategy placeholders) {
        element.setExpandedState(layout.getState(), false);
    }

    public void write(ToolbarGroupDockStationLayout layout, DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_1);
        layout.getPlaceholders().write(out);
        out.writeUTF(layout.getState().name());
    }

    public void write(ToolbarGroupDockStationLayout layout, XElement element) {
        XElement xplaceholders = element.addElement("placeholders");
        layout.getPlaceholders().write(xplaceholders);
        element.addElement("expanded").setString(layout.getState().name());
    }

    public ToolbarGroupDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read((DataInputStream)in);
        version.checkCurrent();
        PlaceholderMap map = new PlaceholderMap(in, placeholders);
        map.setPlaceholderStrategy(null);
        ExpandedState state = ExpandedState.valueOf(in.readUTF());
        return new ToolbarGroupDockStationLayout(map, state);
    }

    public ToolbarGroupDockStationLayout read(XElement element, PlaceholderStrategy strategy) {
        XElement xplaceholders = element.getElement("placeholders");
        XElement xexpanded = element.getElement("expanded");
        PlaceholderMap map = new PlaceholderMap(xplaceholders, strategy);
        map.setPlaceholderStrategy(null);
        ExpandedState state = ExpandedState.SHRUNK;
        if (xexpanded != null) {
            state = ExpandedState.valueOf(xexpanded.getString());
        }
        return new ToolbarGroupDockStationLayout(map, state);
    }

    public void estimateLocations(ToolbarGroupDockStationLayout layout, final LocationEstimationMap children) {
        DockablePlaceholderList.simulatedRead((PlaceholderMap)layout.getPlaceholders(), (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, Dockable>(){

            public Dockable convert(ConvertedPlaceholderListItem item) {
                final int column = item.getInt("index");
                DockablePlaceholderList.simulatedRead((PlaceholderMap)item.getPlaceholderMap(), (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, Dockable>(){

                    public Dockable convert(ConvertedPlaceholderListItem item) {
                        int id = item.getInt("id");
                        int line = item.getInt("index");
                        Path placeholder = null;
                        if (item.contains("placeholder")) {
                            placeholder = new Path(item.getString("placeholder"));
                        }
                        children.setLocation(id, (DockableProperty)new ToolbarGroupProperty(column, line, placeholder));
                        int n = children.getSubChildCount(id);
                        for (int i = 0; i < n; ++i) {
                            DockLayoutInfo info = children.getSubChild(id, i);
                            info.setLocation((DockableProperty)new ToolbarGroupProperty(column, line, info.getPlaceholder()));
                        }
                        return null;
                    }
                });
                return null;
            }
        });
    }

    public ToolbarGroupDockStation layout(ToolbarGroupDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        ToolbarGroupDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    public ToolbarGroupDockStation layout(ToolbarGroupDockStationLayout layout, PlaceholderStrategy placeholders) {
        ToolbarGroupDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    public ToolbarGroupDockPerspective layoutPerspective(ToolbarGroupDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        return new ToolbarGroupDockPerspective(layout, children);
    }

    public void layoutPerspective(ToolbarGroupDockPerspective perspective, ToolbarGroupDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout, children);
    }

    protected ToolbarGroupDockStation createStation() {
        return new ToolbarGroupDockStation();
    }
}

