/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.toolbar.ToolbarLineBorder;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ToolbarDockableDisplayer
extends BasicDockableDisplayer {
    public static final DisplayerFactory FACTORY = new DisplayerFactory(){

        public void request(DisplayerRequest request) {
            ToolbarDockableDisplayer displayer = new ToolbarDockableDisplayer(request.getParent(), request.getTarget(), request.getTitle());
            displayer.setDefaultBorderHint(false);
            displayer.setRespectBorderHint(true);
            request.answer((DockableDisplayer)displayer);
        }
    };
    private OrientationObserver observer;
    private JPanel dockable;
    private BasicDockableDisplayer.DisplayerBorder toolbarBorder;

    public ToolbarDockableDisplayer(DockStation station, Dockable dockable, DockTitle title) {
        super(station);
        this.setTransparency(Transparency.TRANSPARENT);
        this.setDockable(dockable);
        this.setTitle(title);
    }

    protected Component getComponent(Dockable dockable) {
        this.ensureDockable();
        return this.dockable;
    }

    private void ensureDockable() {
        if (this.dockable == null) {
            this.dockable = new JPanel(new GridLayout(1, 1));
            this.dockable.setOpaque(false);
            this.toolbarBorder = new BasicDockableDisplayer.DisplayerBorder((BasicDockableDisplayer)this, (JComponent)this.dockable, "toolbar");
        }
    }

    protected Border getDefaultBorder() {
        return new ToolbarLineBorder(this);
    }

    protected void updateBorder() {
        if (this.isSingleTabShowing()) {
            super.updateBorder();
        } else {
            this.ensureDockable();
            this.setBaseBorder(null);
            this.setContentBorder(null);
            boolean show = this.isRespectBorderHint() ? this.getHints().getShowBorderHint() : this.getDefaultBorderHint();
            if (show) {
                this.toolbarBorder.setBorder(this.getDefaultBorder());
            } else {
                this.toolbarBorder.setBorder(null);
            }
        }
    }

    public void setController(DockController controller) {
        super.setController(controller);
        this.toolbarBorder.setController(controller);
    }

    public void setDockable(Dockable dockable) {
        Dockable oldDockable = this.getDockable();
        if (oldDockable != dockable) {
            if (this.observer != null) {
                this.observer.destroy();
                this.observer = null;
            }
            super.setDockable(dockable);
            this.ensureDockable();
            this.dockable.removeAll();
            if (dockable != null) {
                this.dockable.add(dockable.getComponent());
                this.observer = new OrientationObserver(dockable){

                    @Override
                    protected void orientationChanged(Orientation current) {
                        ToolbarDockableDisplayer.this.setOrientation(current);
                    }
                };
                this.setOrientation(this.getOrientation());
            }
        }
    }

    public Insets getDockableInsets() {
        Insets insets = super.getDockableInsets();
        Border border = this.dockable.getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(this.dockable);
            insets.left += borderInsets.left;
            insets.right += borderInsets.right;
            insets.top += borderInsets.top;
            insets.bottom += borderInsets.bottom;
        }
        return insets;
    }

    protected Orientation getOrientation() {
        Orientation result;
        if (this.observer != null && (result = this.observer.getOrientation()) != null) {
            return result;
        }
        Dockable dockable = this.getDockable();
        if (dockable == null) {
            return null;
        }
        if (dockable instanceof OrientedDockStation) {
            return ((OrientedDockStation)dockable).getOrientation();
        }
        return null;
    }

    protected void setOrientation(Orientation orientation) {
        if (orientation != null) {
            if (orientation == Orientation.HORIZONTAL) {
                this.setTitleLocation(DockableDisplayer.Location.LEFT);
            } else {
                this.setTitleLocation(DockableDisplayer.Location.TOP);
            }
        }
    }
}

