/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ToolbarContainerDropInfo
implements StationDropOperation {
    private final Dockable dragDockable;
    private final ToolbarContainerDockStation stationHost;
    private final DockablePlaceholderList<StationChildHandle> associateToolbars;
    private final int mouseX;
    private final int mouseY;
    private Dockable dockableBeneathMouse = null;
    private Position sideDockableBeneathMouse = null;
    private Position dragDockablePosition;

    public ToolbarContainerDropInfo(Dockable dockable, ToolbarContainerDockStation stationHost, DockablePlaceholderList<StationChildHandle> associateToolbars, int mouseX, int mouseY) {
        this.dragDockable = dockable;
        this.stationHost = stationHost;
        this.associateToolbars = associateToolbars;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public Dockable getItem() {
        return this.dragDockable;
    }

    public DockStation getTarget() {
        return this.stationHost;
    }

    public CombinerTarget getCombination() {
        return null;
    }

    public DisplayerCombinerTarget getDisplayerCombination() {
        return null;
    }

    public boolean isMove() {
        return this.getItem().getDockParent() == this.getTarget();
    }

    public abstract int getIndex();

    public Dockable getDockableBeneathMouse() {
        if (this.dockableBeneathMouse == null) {
            this.dockableBeneathMouse = this.computeDockableBeneathMouse();
        }
        return this.dockableBeneathMouse;
    }

    public Position getSideDockableBeneathMouse() {
        if (this.sideDockableBeneathMouse == null) {
            this.sideDockableBeneathMouse = this.computeSideDockableBeneathMouse();
        }
        return this.sideDockableBeneathMouse;
    }

    public Position getItemPositionVSBeneathDockable() {
        if (this.dragDockablePosition == null) {
            this.dragDockablePosition = this.computeItemPositionVSBeneathDockable();
        }
        return this.dragDockablePosition;
    }

    private Position computeSideDockableBeneathMouse() {
        Dockable dockableBeneathMouse = this.getDockableBeneathMouse();
        if (dockableBeneathMouse == null) {
            return null;
        }
        Point mouseCoordinate = new Point(this.mouseX, this.mouseY);
        switch (this.stationHost.getOrientation()) {
            case VERTICAL: {
                SwingUtilities.convertPointFromScreen(mouseCoordinate, dockableBeneathMouse.getComponent());
                double middleY = (dockableBeneathMouse.getComponent().getBounds().getMinY() + dockableBeneathMouse.getComponent().getBounds().getMaxY()) / 2.0;
                if (Math.abs(mouseCoordinate.getY()) <= middleY) {
                    return Position.NORTH;
                }
                return Position.SOUTH;
            }
            case HORIZONTAL: {
                SwingUtilities.convertPointFromScreen(mouseCoordinate, dockableBeneathMouse.getComponent());
                double middleX = (dockableBeneathMouse.getComponent().getBounds().getMinX() + dockableBeneathMouse.getComponent().getBounds().getMaxX()) / 2.0;
                if (Math.abs(mouseCoordinate.getX()) <= middleX) {
                    return Position.WEST;
                }
                return Position.EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    private Dockable computeDockableBeneathMouse() {
        PlaceholderList.Filter associateToolbars = this.associateToolbars.dockables();
        int dockableCount = associateToolbars.size();
        if (dockableCount <= 0) {
            return null;
        }
        Point mouseCoordinate = new Point(this.mouseX, this.mouseY);
        JPanel panelBeneathMouse = this.stationHost.getContainerPanel();
        SwingUtilities.convertPointFromScreen(mouseCoordinate, panelBeneathMouse);
        Orientation orientation = this.stationHost.getOrientation();
        switch (orientation) {
            case VERTICAL: {
                Component componentBeneathMouse = ((StationChildHandle)associateToolbars.get(0)).getDisplayer().getComponent();
                double middleY = (componentBeneathMouse.getBounds().getMinY() + componentBeneathMouse.getBounds().getMaxY()) / 2.0;
                double formerDistance = Math.abs(mouseCoordinate.getY() - middleY);
                for (int i = 1; i < dockableCount; ++i) {
                    componentBeneathMouse = ((StationChildHandle)associateToolbars.get(i)).getDisplayer().getComponent();
                    middleY = (componentBeneathMouse.getBounds().getMinY() + componentBeneathMouse.getBounds().getMaxY()) / 2.0;
                    if (Math.abs(mouseCoordinate.getY() - middleY) >= formerDistance) {
                        return ((StationChildHandle)associateToolbars.get(i - 1)).getDockable();
                    }
                    formerDistance = Math.abs(mouseCoordinate.getY() - middleY);
                }
                return ((StationChildHandle)associateToolbars.get(dockableCount - 1)).getDockable();
            }
            case HORIZONTAL: {
                Component componentBeneathMouse = ((StationChildHandle)associateToolbars.get(0)).getDisplayer().getComponent();
                double middleX = (componentBeneathMouse.getBounds().getMinX() + componentBeneathMouse.getBounds().getMaxX()) / 2.0;
                double formerDistance = Math.abs(mouseCoordinate.getX() - middleX);
                for (int i = 1; i < dockableCount; ++i) {
                    componentBeneathMouse = ((StationChildHandle)associateToolbars.get(i)).getDisplayer().getComponent();
                    middleX = (componentBeneathMouse.getBounds().getMinX() + componentBeneathMouse.getBounds().getMaxX()) / 2.0;
                    if (Math.abs(mouseCoordinate.getX() - middleX) >= formerDistance) {
                        return ((StationChildHandle)associateToolbars.get(i - 1)).getDockable();
                    }
                    formerDistance = Math.abs(mouseCoordinate.getX() - middleX);
                }
                return ((StationChildHandle)associateToolbars.get(dockableCount - 1)).getDockable();
            }
        }
        throw new IllegalArgumentException();
    }

    private Position computeItemPositionVSBeneathDockable() {
        Point coordDockableDragged = this.getItem().getComponent().getLocation();
        if (this.getDockableBeneathMouse() != null) {
            Point coordDockableBeneathMouse = this.getDockableBeneathMouse().getComponent().getLocation();
            SwingUtilities.convertPointFromScreen(coordDockableDragged, this.getDockableBeneathMouse().getComponent());
            if (this.getDockableBeneathMouse() == null) {
                return null;
            }
            if (this.getItem() == this.getDockableBeneathMouse()) {
                return Position.CENTER;
            }
            switch (this.stationHost.getOrientation()) {
                case VERTICAL: {
                    if (coordDockableDragged.getY() <= coordDockableBeneathMouse.getY()) {
                        return Position.NORTH;
                    }
                    return Position.SOUTH;
                }
                case HORIZONTAL: {
                    if (coordDockableDragged.getX() <= coordDockableBeneathMouse.getX()) {
                        return Position.EAST;
                    }
                    return Position.WEST;
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    public String toSummaryString() {
        String ln = System.getProperty("line.separator");
        return "\t=> Drag dockable: " + this.getItem() + ln + "\t=> Station target: " + this.getTarget() + ln + "\t=> Dockable beneath mouse:" + this.getDockableBeneathMouse() + ln + "\t=> Closest side:" + (Object)((Object)this.getSideDockableBeneathMouse()) + ln + "\t=> Drag dockable VS dockable beneath mouse:" + (Object)((Object)this.getItemPositionVSBeneathDockable());
    }
}

