/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;

public abstract class OrientationObserver
implements OrientingDockStationListener {
    private Dockable dockable;
    private OrientingDockStation station;
    private DockHierarchyListener listener = new DockHierarchyListener(){

        public void hierarchyChanged(DockHierarchyEvent event) {
            OrientationObserver.this.updateHierarchy();
        }

        public void controllerChanged(DockHierarchyEvent event) {
        }
    };

    public OrientationObserver(Dockable dockable) {
        this.dockable = dockable;
        dockable.addDockHierarchyListener(this.listener);
        this.updateHierarchy();
    }

    public void destroy() {
        this.dockable.removeDockHierarchyListener(this.listener);
    }

    private void updateHierarchy() {
        Dockable item = this.dockable;
        DockStation parent = item.getDockParent();
        OrientingDockStation newParent = null;
        while (parent != null) {
            if (parent instanceof OrientingDockStation) {
                newParent = (OrientingDockStation)parent;
                break;
            }
            item = parent.asDockable();
            if (item == null) {
                parent = null;
                continue;
            }
            parent = item.getDockParent();
        }
        if (newParent != this.station) {
            if (this.station != null) {
                this.station.removeOrientingDockStationListener(this);
            }
            if (newParent != null) {
                newParent.addOrientingDockStationListener(this);
            }
            this.orientationChanged(this.getOrientation());
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    protected abstract void orientationChanged(Orientation var1);

    public Orientation getOrientation() {
        Dockable item = this.dockable;
        DockStation parent = item.getDockParent();
        while (parent != null) {
            if (parent instanceof OrientingDockStation) {
                return ((OrientingDockStation)parent).getOrientationOf(item);
            }
            item = parent.asDockable();
            if (item == null) {
                parent = null;
                continue;
            }
            parent = item.getDockParent();
        }
        return null;
    }

    @Override
    public void changed(OrientingDockStationEvent event) {
        if (event.isAffected(this.dockable)) {
            this.orientationChanged(this.getOrientation());
        }
    }
}

