/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.ToolbarTabDockStation;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class AbstractToolbarDockStation
extends AbstractDockableStation
implements OrientedDockStation,
ExpandableToolbarItem {
    public static final PropertyKey<Boolean> ON_CONFLICT_ENABLE = new PropertyKey("ExpandableToolbarGroupActions.on_conflict_enable", (PropertyFactory)new ConstantPropertyFactory((Object)Boolean.TRUE), true);
    protected DisplayerCollection displayers;
    protected DefaultDisplayerFactoryValue displayerFactory;
    protected DockTitleVersion title;
    protected DefaultStationPaintValue paint;
    protected Orientation orientation = Orientation.HORIZONTAL;
    private final List<OrientingDockStationListener> orientingListeners = new ArrayList<OrientingDockStationListener>();
    private final List<ExpandableToolbarItemListener> expandableListeners = new ArrayList<ExpandableToolbarItemListener>();
    private ExpandedState state = ExpandedState.SHRUNK;
    private ExpandableListener expandableListener = new ExpandableListener();
    private PropertyValue<ExpandableToolbarItemStrategy> expandableStategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        protected void valueChanged(ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeExpandedListener(AbstractToolbarDockStation.this.expandableListener);
            }
            if (newValue != null) {
                newValue.addExpandedListener(AbstractToolbarDockStation.this.expandableListener);
            }
            AbstractToolbarDockStation.this.fireEnablementChanged();
        }
    };
    private PropertyValue<Boolean> onConflictEnable = new PropertyValue<Boolean>(ON_CONFLICT_ENABLE){

        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            AbstractToolbarDockStation.this.fireEnablementChanged();
        }
    };
    private boolean[] expandedEnablementStateCache = new boolean[ExpandedState.values().length];
    private Dockable removal;
    private Background background;

    public AbstractToolbarDockStation() {
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation current) {
                if (current != null) {
                    AbstractToolbarDockStation.this.setOrientation(current);
                }
            }
        };
        this.addDockStationListener((DockStationListener)new DockStationAdapter(){

            public void dockableAdded(DockStation station, Dockable dockable) {
                AbstractToolbarDockStation.this.fireEnablementChanged();
            }

            public void dockableRemoved(DockStation station, Dockable dockable) {
                AbstractToolbarDockStation.this.fireEnablementChanged();
            }
        });
    }

    public void setController(DockController controller) {
        super.setController(controller);
        this.expandableStategy.setProperties(controller);
        this.onConflictEnable.setProperties(controller);
        this.background.setController(controller);
    }

    protected void init(String backgroundId) {
        this.background = new Background(backgroundId);
    }

    protected JPanel createBackgroundPanel() {
        ConfiguredBackgroundPanel panel = new ConfiguredBackgroundPanel(Transparency.DEFAULT);
        panel.setBackground((BackgroundAlgorithm)this.background);
        return panel;
    }

    protected BackgroundAlgorithm getBackgroundAlgorithm() {
        return this.background;
    }

    public Dockable getFrontDockable() {
        return null;
    }

    public void setFrontDockable(Dockable dockable) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    public int indexOf(Dockable dockable) {
        for (int i = 0; i < this.getDockableCount(); ++i) {
            if (this.getDockable(i) != dockable) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener listener) {
        this.orientingListeners.add(listener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener listener) {
        this.orientingListeners.remove(listener);
    }

    @Override
    public Orientation getOrientationOf(Dockable child) {
        return this.getOrientation();
    }

    protected void fireOrientingEvent() {
        OrientingDockStationEvent event = new OrientingDockStationEvent(this);
        for (OrientingDockStationListener listener : this.orientingListeners.toArray(new OrientingDockStationListener[this.orientingListeners.size()])) {
            listener.changed(event);
        }
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.state;
    }

    public void setExpandedState(ExpandedState state, boolean action) {
        if (action) {
            this.setExpandedState(state);
        } else {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpandedState(ExpandedState state) {
        if (this.state != state) {
            DockController controller = this.getController();
            if (controller != null) {
                controller.freezeLayout();
            }
            try {
                ExpandedState oldState = this.state;
                this.state = state;
                if (oldState != ExpandedState.SHRUNK) {
                    this.shrink(oldState);
                }
                if (state == ExpandedState.EXPANDED) {
                    this.expand();
                } else if (state == ExpandedState.STRETCHED) {
                    this.stretch();
                }
                for (ExpandableToolbarItemListener listener : this.expandableListeners) {
                    listener.changed(this, oldState, state);
                }
            }
            finally {
                if (controller != null) {
                    controller.meltLayout();
                }
            }
        }
    }

    @Override
    public boolean isEnabled(ExpandedState state) {
        ExpandableToolbarItemStrategy strategy = (ExpandableToolbarItemStrategy)this.expandableStategy.getValue();
        if (strategy == null) {
            return false;
        }
        boolean hasEnabled = false;
        boolean hasDisabled = false;
        AbstractToolbarDockStation station = null;
        if (this.getExpandedState() == ExpandedState.EXPANDED && this.getDockableCount() == 1) {
            station = this.getDockable(0).asDockStation();
        }
        if (station == null) {
            station = this;
        }
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            if (strategy.isEnabled(station.getDockable(i), state)) {
                hasEnabled = true;
                continue;
            }
            hasDisabled = true;
        }
        if (hasEnabled && hasDisabled) {
            this.onConflictEnable.getValue();
        }
        return hasEnabled;
    }

    private void expand() {
        int i;
        DockController controller = this.getController();
        Dockable focused = null;
        Dockable[] children = new Dockable[this.getDockableCount()];
        for (i = 0; i < children.length; ++i) {
            children[i] = this.getDockable(i);
            if (controller == null || !controller.isFocused(children[i])) continue;
            focused = children[i];
        }
        for (i = children.length - 1; i >= 0; --i) {
            this.remove(this.getDockable(i));
        }
        ToolbarTabDockStation station = new ToolbarTabDockStation();
        for (Dockable child : children) {
            station.drop(child);
        }
        this.drop((Dockable)station);
        if (focused != null) {
            station.setFrontDockable(focused);
            controller.setFocusedDockable(focused, true);
        }
    }

    public void stretch() {
    }

    public void shrink(ExpandedState state) {
        if (state == ExpandedState.EXPANDED) {
            int i;
            DockController controller = this.getController();
            DockStation child = this.getDockable(0).asDockStation();
            Dockable focused = child.getFrontDockable();
            this.remove(this.getDockable(0));
            Dockable[] children = new Dockable[child.getDockableCount()];
            for (i = 0; i < children.length; ++i) {
                children[i] = child.getDockable(i);
            }
            for (i = children.length - 1; i >= 0; --i) {
                child.drag(children[i]);
            }
            for (Dockable next : children) {
                this.drop(next);
            }
            if (focused != null && controller != null) {
                controller.setFocusedDockable(focused, true);
            }
        }
    }

    @Override
    public void addExpandableListener(ExpandableToolbarItemListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.expandableListeners.add(listener);
    }

    @Override
    public void removeExpandableListener(ExpandableToolbarItemListener listener) {
        this.expandableListeners.remove(listener);
    }

    protected ExpandableToolbarItemListener[] expandableListeners() {
        return this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()]);
    }

    private void fireEnablementChanged() {
        for (ExpandedState state : ExpandedState.values()) {
            this.fireEnablementChanged(state);
        }
    }

    private void fireEnablementChanged(ExpandedState state) {
        boolean enabled = this.isEnabled(state);
        if (enabled != this.expandedEnablementStateCache[state.ordinal()]) {
            this.expandedEnablementStateCache[state.ordinal()] = enabled;
            for (ExpandableToolbarItemListener listener : this.expandableListeners()) {
                listener.enablementChanged(this, state, enabled);
            }
        }
    }

    public ToolbarStrategy getToolbarStrategy() {
        SilentPropertyValue value = new SilentPropertyValue(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy result = (ToolbarStrategy)value.getValue();
        value.setProperties((DockController)null);
        return result;
    }

    public boolean canDrag(Dockable dockable) {
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            DockStation child = dockable.asDockStation();
            return child != null && child.getDockableCount() == 0;
        }
        return true;
    }

    protected abstract void remove(Dockable var1);

    public boolean canReplace(Dockable old, Dockable next) {
        return old.getClass() == next.getClass();
    }

    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next);
    }

    public StationDragOperation prepareDrag(Dockable dockable) {
        this.removal = dockable;
        this.getComponent().repaint();
        return new StationDragOperation(){

            public void succeeded() {
                AbstractToolbarDockStation.this.removal = null;
                AbstractToolbarDockStation.this.getComponent().repaint();
            }

            public void canceled() {
                AbstractToolbarDockStation.this.removal = null;
                AbstractToolbarDockStation.this.getComponent().repaint();
            }
        };
    }

    protected Dockable getRemoval() {
        return this.removal;
    }

    protected abstract DefaultDisplayerFactoryValue createDisplayerFactory();

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    protected abstract DockTitleVersion registerTitle(DockController var1);

    protected abstract void discard(DockableDisplayer var1);

    private class ExpandableListener
    implements ExpandableToolbarItemStrategyListener {
        private ExpandableListener() {
        }

        @Override
        public void expanded(Dockable item) {
        }

        @Override
        public void stretched(Dockable item) {
        }

        @Override
        public void shrunk(Dockable item) {
        }

        @Override
        public void enablementChanged(Dockable item, ExpandedState state, boolean enabled) {
            if (item.getDockParent() == AbstractToolbarDockStation.this) {
                AbstractToolbarDockStation.this.fireEnablementChanged(state);
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background(String backgroundId) {
            super(StationBackgroundComponent.KIND, backgroundId);
        }

        public Component getComponent() {
            return AbstractToolbarDockStation.this.getComponent();
        }

        public DockStation getStation() {
            return AbstractToolbarDockStation.this;
        }
    }
}

