/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Rectangle;

public class ColumnDividier
implements Divideable {
    private WizardSplitDockStation station;

    public ColumnDividier(WizardSplitDockStation station) {
        this.station = station;
    }

    public double getDividerAt(int x, int y) {
        double width = this.station.getWidth();
        double height = this.station.getHeight();
        switch (this.station.getSide()) {
            case RIGHT: 
            case LEFT: {
                return (double)x / width;
            }
            case BOTTOM: 
            case TOP: {
                return (double)y / height;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    public Rectangle getDividerBounds(double divider, Rectangle bounds) {
        if (bounds == null) {
            bounds = new Rectangle();
        }
        int gap = this.station.getDividerSize();
        int width = this.station.getWidth() - gap;
        int height = this.station.getHeight() - gap;
        switch (this.station.getSide()) {
            case RIGHT: 
            case LEFT: {
                bounds.x = (int)(divider * (double)width);
                bounds.y = 0;
                bounds.width = gap;
                bounds.height = height + gap;
                break;
            }
            case BOTTOM: 
            case TOP: {
                bounds.x = 0;
                bounds.width = width + gap;
                bounds.y = (int)(divider * (double)height);
                bounds.height = gap;
            }
        }
        return bounds;
    }

    public SplitDockStation.Orientation getOrientation() {
        return this.station.getSide().getHeaderOrientation();
    }

    public double getDivider() {
        switch (this.station.getSide()) {
            case RIGHT: 
            case BOTTOM: {
                return 0.0;
            }
            case LEFT: 
            case TOP: {
                return 1.0;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    public double getActualDivider() {
        return this.getDivider();
    }

    public void setDivider(double dividier) {
    }

    public double validateDivider(double divider) {
        return this.station.getWizardSplitLayoutManager().validateColumnDivider(divider);
    }
}

