/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import javax.swing.Icon;

public class SimpleExpandAction
extends SimpleButtonAction {
    private final DockController controller;
    private int bound = 0;
    private DockActionIcon iconHorizontal;
    private DockActionIcon iconVertical;
    private DockActionIcon iconHoverHorizontal;
    private DockActionIcon iconHoverVertical;
    private DockActionText text;
    private DockActionText tooltip;
    private Action behavior;

    public SimpleExpandAction(DockController controller, Action action) {
        this.controller = controller;
        this.setBehavior(action);
    }

    public Action getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Action behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("behavior must not be null");
        }
        if (this.behavior != behavior) {
            this.behavior = behavior;
            String name = this.name(behavior);
            if (this.iconHorizontal == null) {
                this.iconHorizontal = new DockActionIcon("toolbar.item." + name + ".horizontal", (DockAction)this){

                    protected void changed(Icon oldValue, Icon newValue) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HORIZONTAL, newValue);
                    }
                };
                this.iconVertical = new DockActionIcon("toolbar.item." + name + ".vertical", (DockAction)this){

                    protected void changed(Icon oldValue, Icon newValue) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_VERTICAL, newValue);
                    }
                };
                this.iconHoverHorizontal = new DockActionIcon("toolbar.item." + name + ".hover.horizontal", (DockAction)this){

                    protected void changed(Icon oldValue, Icon newValue) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HOVER_HORIZONTAL, newValue);
                    }
                };
                this.iconHoverVertical = new DockActionIcon("toolbar.item." + name + ".hover.vertical", (DockAction)this){

                    protected void changed(Icon oldValue, Icon newValue) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HOVER_VERTICAL, newValue);
                    }
                };
                this.text = new DockActionText("toolbar.item." + name, (DockAction)this){

                    protected void changed(String oldValue, String newValue) {
                        SimpleExpandAction.this.setText(newValue);
                    }
                };
                this.tooltip = new DockActionText("toolbar.item." + name + ".tooltip", (DockAction)this){

                    protected void changed(String oldValue, String newValue) {
                        SimpleExpandAction.this.setTooltip(newValue);
                    }
                };
            } else {
                this.iconHorizontal.setId("toolbar.item." + name + ".horizontal");
                this.iconVertical.setId("toolbar.item." + name + ".vertical");
                this.iconHoverHorizontal.setId("toolbar.item." + name + ".hover.horizontal");
                this.iconHoverVertical.setId("toolbar.item." + name + ".hover.vertical");
                this.text.setId("toolbar.item." + name);
                this.tooltip.setId("toolbar.item." + name + ".tooltip");
            }
        }
    }

    private String name(Action action) {
        switch (action) {
            case LARGER: {
                return "larger";
            }
            case LARGEST: {
                return "expand";
            }
            case SMALLER: {
                return "smaller";
            }
            case SMALLEST: {
                return "shrink";
            }
        }
        throw new IllegalStateException("unknown action: " + (Object)((Object)action));
    }

    public void bound(Dockable dockable) {
        if (this.bound == 0) {
            this.iconHorizontal.setController(this.controller);
            this.iconVertical.setController(this.controller);
            this.iconHoverHorizontal.setController(this.controller);
            this.iconHoverVertical.setController(this.controller);
            this.text.setController(this.controller);
            this.tooltip.setController(this.controller);
        }
        super.bound(dockable);
        ++this.bound;
    }

    public void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.bound;
        if (this.bound == 0) {
            this.iconHorizontal.setController(null);
            this.iconVertical.setController(null);
            this.iconHoverHorizontal.setController(null);
            this.iconHoverVertical.setController(null);
            this.text.setController(null);
            this.tooltip.setController(null);
        }
    }

    public static enum Action {
        LARGEST,
        LARGER,
        SMALLER,
        SMALLEST;

    }
}

