/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;

public class ExpandableStateController {
    private final ExpandableToolbarItem item;
    private DockController controller;
    private final PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        protected void valueChanged(ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeExpandedListener(ExpandableStateController.this.strategyListener);
            }
            if (newValue != null && ExpandableStateController.this.controller != null) {
                newValue.addExpandedListener(ExpandableStateController.this.strategyListener);
            }
            ExpandableStateController.this.refresh();
        }
    };
    private final ExpandableToolbarItemStrategyListener strategyListener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable item) {
            if (DockUtilities.isAncestor((DockElement)item, (DockElement)ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void shrunk(Dockable item) {
            if (DockUtilities.isAncestor((DockElement)item, (DockElement)ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void expanded(Dockable item) {
            if (DockUtilities.isAncestor((DockElement)item, (DockElement)ExpandableStateController.this.getItem())) {
                ExpandableStateController.this.refresh();
            }
        }

        @Override
        public void enablementChanged(Dockable item, ExpandedState state, boolean enabled) {
        }
    };

    public ExpandableStateController(ExpandableToolbarItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        this.item = item;
        item.addDockHierarchyListener(new DockHierarchyListener(){

            public void hierarchyChanged(DockHierarchyEvent event) {
                ExpandableStateController.this.refresh();
            }

            public void controllerChanged(DockHierarchyEvent event) {
                ExpandableStateController.this.controller = ExpandableStateController.this.getItem().getController();
                ExpandableStateController.this.strategy.setProperties(ExpandableStateController.this.controller);
            }
        });
        this.strategy.setProperties(this.getItem().getController());
        this.refresh();
    }

    public ExpandableToolbarItem getItem() {
        return this.item;
    }

    public void refresh() {
        DockStation station;
        if (this.item != null && (station = this.item.getDockParent()) != null) {
            Dockable current = station.asDockable();
            ExpandableToolbarItemStrategy strategy = (ExpandableToolbarItemStrategy)this.strategy.getValue();
            if (strategy != null) {
                while (current != null) {
                    ExpandedState state = strategy.getState(current);
                    if (state != null) {
                        this.item.setExpandedState(state);
                        return;
                    }
                    station = current.getDockParent();
                    if (station != null) {
                        current = station.asDockable();
                        continue;
                    }
                    current = null;
                }
            }
        }
    }
}

