/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ToolbarDockTitlePoint
extends AbstractDockTitle {
    private Color backgroundColor = UIManager.getColor("Button.background");
    private Color pointColor = this.backgroundColor.darker();
    private static final int POINT_DISTANCE = 2;

    public static DockTitleFactory createFactory(final Color backgroundColor, final Color pointColor) {
        return new DockTitleFactory(){

            public void uninstall(DockTitleRequest request) {
            }

            public void request(DockTitleRequest request) {
                request.answer((DockTitle)new ToolbarDockTitlePoint(request.getVersion(), request.getTarget(), backgroundColor, pointColor));
            }

            public void install(DockTitleRequest request) {
            }
        };
    }

    public static DockTitleFactory createFactory() {
        return new DockTitleFactory(){

            public void uninstall(DockTitleRequest request) {
            }

            public void request(DockTitleRequest request) {
                request.answer((DockTitle)new ToolbarDockTitlePoint(request.getVersion(), request.getTarget()));
            }

            public void install(DockTitleRequest request) {
            }
        };
    }

    public ToolbarDockTitlePoint(DockTitleVersion origin, Dockable dockable, Color backgroundColor, Color pointColor) {
        super(dockable, origin, true);
        this.backgroundColor = backgroundColor;
        this.pointColor = pointColor;
    }

    public ToolbarDockTitlePoint(DockTitleVersion origin, Dockable dockable) {
        super(dockable, origin, true);
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return (BasicTitleViewItem)dockable.getController().getActionViewConverter().createView(action, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(5, size.width), Math.max(5, size.height));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.pointColor);
        if (this.getOrientation().isHorizontal()) {
            int y = this.getHeight() / 2;
            for (int x = this.getWidth() / 6; x <= this.getWidth() - this.getWidth() / 6; x += 2) {
                g.drawLine(x, y - 1, x, y - 1);
                g.drawLine(x, y + 1, x, y + 1);
            }
        } else {
            int x = this.getWidth() / 2;
            for (int y = this.getHeight() / 6; y < this.getHeight() - this.getHeight() / 6; y += 2) {
                g.drawLine(x - 1, y, x - 1, y);
                g.drawLine(x + 1, y, x + 1, y);
            }
        }
    }
}

