/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class DefaultToolbarDockTitle
extends AbstractDockTitle {
    private final Color color;
    private final DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;

    public static DockTitleFactory createFactory(final Color color) {
        return new DockTitleFactory(){

            public void uninstall(DockTitleRequest request) {
            }

            public void request(DockTitleRequest request) {
                request.answer((DockTitle)new DefaultToolbarDockTitle(request.getVersion(), request.getTarget(), color));
            }

            public void install(DockTitleRequest request) {
            }
        };
    }

    public DefaultToolbarDockTitle(DockTitleVersion origin, Dockable dockable, Color color) {
        super(dockable, origin, true);
        this.color = color;
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return (BasicTitleViewItem)dockable.getController().getActionViewConverter().createView(action, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(5, size.width), Math.max(5, size.height));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.repaint();
    }

    public void paintBackground(Graphics g, JComponent component) {
        g.setColor(this.color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isActive()) {
            g.setColor(Color.RED);
            if (this.orientation.isHorizontal()) {
                g.drawLine(1, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                g.drawLine(this.getWidth() / 2, 1, this.getWidth() / 2, this.getHeight() - 1);
            }
        }
    }
}

