/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;

public class CustomizationMenuContentVerticalBox
implements CustomizationMenuContent {
    private final List<CustomizationMenuContent> content = new ArrayList<CustomizationMenuContent>();
    private Box view;
    private DockController controller;

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        for (CustomizationMenuContent item : this.content) {
            item.setController(controller);
        }
    }

    @Override
    public void bind(CustomizationMenuCallback callback) {
        this.view = Box.createVerticalBox();
        this.view.setOpaque(true);
        for (CustomizationMenuContent item : this.content) {
            item.bind(callback);
            if (item.getView() instanceof JComponent) {
                ((JComponent)item.getView()).setAlignmentX(0.0f);
            }
            this.view.add(item.getView());
        }
    }

    @Override
    public void unbind() {
        this.view.removeAll();
        this.view = null;
        for (CustomizationMenuContent item : this.content) {
            item.unbind();
        }
    }

    public void add(CustomizationMenuContent item) {
        this.content.add(item);
        item.setController(this.controller);
    }

    public void add(int index, CustomizationMenuContent item) {
        this.content.add(index, item);
        item.setController(this.controller);
    }

    public void remove(int index) {
        CustomizationMenuContent item = this.content.remove(index);
        item.setController(null);
    }

    public void remove(CustomizationMenuContent item) {
        if (this.content.remove(item)) {
            item.setController(null);
        }
    }

    public int getItemCount() {
        return this.content.size();
    }

    public CustomizationMenuContent getItem(int index) {
        return this.content.get(index);
    }
}

