/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.layout.grid.Column;
import bibliothek.gui.dock.station.toolbar.layout.grid.ColumnItem;
import bibliothek.util.Path;

public abstract class GridPlaceholderList<D, S, P extends PlaceholderListItem<D>>
extends PlaceholderList<ColumnItem<D, S, P>, ColumnItem<D, S, P>, Column<D, S, P>> {
    private PlaceholderListItemConverter<D, P> converter;

    public GridPlaceholderList() {
        this.setConverter(null);
    }

    public Column<D, S, P> createColumn(PlaceholderList<D, S, P> content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        return new ColumnList(content);
    }

    public void setConverter(PlaceholderListItemConverter<D, P> converter) {
        if (converter == null) {
            converter = new PlaceholderListItemConverter<D, P>(){

                public ConvertedPlaceholderListItem convert(int index, P dockable) {
                    return null;
                }

                public P convert(ConvertedPlaceholderListItem item) {
                    return null;
                }

                public void added(P dockable) {
                }
            };
        }
        this.converter = converter;
    }

    public PlaceholderListItemConverter<D, P> getConverter() {
        return this.converter;
    }

    protected Path getPlaceholder(ColumnItem<D, S, P> dockable) {
        return dockable.getPlaceholder();
    }

    protected String toString(ColumnItem<D, S, P> dockable) {
        return dockable.toString();
    }

    protected ColumnItem<D, S, P> toStation(ColumnItem<D, S, P> dockable) {
        return dockable.asStation();
    }

    protected PlaceholderMap getPlaceholders(ColumnItem<D, S, P> station) {
        return station.getPlaceholders();
    }

    protected void setPlaceholders(ColumnItem<D, S, P> station, PlaceholderMap map) {
        station.setPlaceholders(map);
    }

    protected ColumnItem<D, S, P>[] getChildren(ColumnItem<D, S, P> station) {
        return station.getChildren();
    }

    protected abstract S itemToStation(D var1);

    protected abstract D[] getItemChildren(S var1);

    protected abstract Path getItemPlaceholder(D var1);

    protected abstract PlaceholderMap getItemPlaceholders(S var1);

    protected abstract void setItemPlaceholders(S var1, PlaceholderMap var2);

    private class ColumnList
    implements Column<D, S, P> {
        private final PlaceholderList<D, S, P> list;

        public ColumnList(PlaceholderList<D, S, P> list) {
            this.list = list;
        }

        public ColumnItem<D, S, P> asDockable() {
            return this;
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            return this;
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            ColumnItem[] result = new ColumnItem[this.list.dockables().size()];
            int index = 0;
            for (PlaceholderListItem item : this.list.dockables()) {
                result[index++] = new DockableItem(item.asDockable());
            }
            return result;
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return this.list.toMap(GridPlaceholderList.this.converter);
        }

        @Override
        public void setPlaceholders(PlaceholderMap map) {
            this.list.clear();
            this.list.read(map, GridPlaceholderList.this.converter);
        }

        @Override
        public PlaceholderList<D, S, P> getList() {
            return this.list;
        }

        @Override
        public Path getPlaceholder() {
            return null;
        }
    }

    private class StationItem
    implements ColumnItem<D, S, P> {
        private final S item;

        public StationItem(S item) {
            this.item = item;
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            return this;
        }

        @Override
        public Path getPlaceholder() {
            throw new IllegalStateException("a " + this.getClass().getSimpleName() + " must not be asked for its placeholder");
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            D[] children = GridPlaceholderList.this.getItemChildren(this.item);
            ColumnItem[] result = new ColumnItem[children.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new DockableItem(children[i]);
            }
            return result;
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return GridPlaceholderList.this.getItemPlaceholders(this.item);
        }

        @Override
        public void setPlaceholders(PlaceholderMap map) {
            GridPlaceholderList.this.setItemPlaceholders(this.item, map);
        }
    }

    private class DockableItem
    implements ColumnItem<D, S, P> {
        private final D item;

        public DockableItem(D item) {
            this.item = item;
        }

        public String toString() {
            return this.item.toString();
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            Object station = GridPlaceholderList.this.itemToStation(this.item);
            if (station == null) {
                return null;
            }
            return new StationItem(station);
        }

        @Override
        public Path getPlaceholder() {
            return GridPlaceholderList.this.getItemPlaceholder(this.item);
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            throw new IllegalStateException("a " + this.getClass().getSimpleName() + " must not be asked for its children");
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return null;
        }

        @Override
        public void setPlaceholders(PlaceholderMap map) {
        }
    }
}

