/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockableGridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.GridPlaceholderList;
import bibliothek.gui.dock.station.toolbar.layout.ModeledPlaceholderToolbarGrid;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DockablePlaceholderToolbarGrid<P extends PlaceholderListItem<Dockable>>
extends ModeledPlaceholderToolbarGrid<Dockable, DockStation, P> {
    public DockablePlaceholderToolbarGrid() {
        this.init();
    }

    @Override
    protected PlaceholderList<Dockable, DockStation, P> createColumn() {
        return new DockablePlaceholderList();
    }

    @Override
    protected GridPlaceholderList<Dockable, DockStation, P> createGrid() {
        return new DockableGridPlaceholderList();
    }

    @Override
    protected Set<Path> getPlaceholders(Dockable dockable) {
        final PlaceholderStrategy strategy = this.getStrategy();
        if (strategy == null) {
            return Collections.emptySet();
        }
        final HashSet<Path> placeholders = new HashSet<Path>();
        DockUtilities.visit((Dockable)dockable, (DockUtilities.DockVisitor)new DockUtilities.DockVisitor(){

            public void handleDockable(Dockable dockable) {
                Path placeholder = strategy.getPlaceholderFor(dockable);
                if (placeholder != null) {
                    placeholders.add(placeholder);
                }
            }

            public void handleDockStation(DockStation station) {
                PlaceholderMap map = station.getPlaceholders();
                if (map != null) {
                    for (PlaceholderMap.Key key : map.getPlaceholders()) {
                        for (Path placeholder : key.getPlaceholders()) {
                            placeholders.add(placeholder);
                        }
                    }
                }
            }
        });
        return placeholders;
    }

    @Override
    protected void fill(Dockable dockable, ConvertedPlaceholderListItem item) {
        DockStation station;
        Path placeholder;
        PlaceholderStrategy strategy = this.getStrategy();
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(dockable)) != null) {
            item.putString("placeholder", placeholder.toString());
            item.setPlaceholder(placeholder);
        }
        if ((station = dockable.asDockStation()) != null) {
            item.setPlaceholderMap(station.getPlaceholders());
        }
    }
}

