/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockTitle;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class ToolbarGroupTitle
extends ColumnDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        public void uninstall(DockTitleRequest request) {
        }

        public void request(DockTitleRequest request) {
            request.answer((DockTitle)new ToolbarGroupTitle(request.getTarget(), request.getVersion()));
        }

        public void install(DockTitleRequest request) {
        }
    };
    protected TitleColor color;

    public ToolbarGroupTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
        this.setTransparency(Transparency.DEFAULT);
        this.color = new TitleColor("extension.toolbar.group.title", (DockTitle)this, new Color(80, 80, 80)){

            protected void changed(Color oldValue, Color newValue) {
                ToolbarGroupTitle.this.repaint();
            }
        };
        this.addColor((AbstractDockColor)this.color);
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return (BasicTitleViewItem)dockable.getController().getActionViewConverter().createView(action, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    protected Insets getInnerInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected ColumnDockActionSource getSourceFor(Dockable dockable) {
        if (dockable instanceof ToolbarGroupDockStation) {
            return ((ToolbarGroupDockStation)dockable).getExpandActionSource();
        }
        return null;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.repaint();
    }

    public void paintBackground(Graphics g, JComponent component) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(this.color.color());
        if (this.getOrientation().isHorizontal()) {
            RoundRectangle2D.Double rectangleRounded = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight() * 2, 8.0, 8.0);
            g2D.fill(rectangleRounded);
        } else {
            RoundRectangle2D.Double rectangleRounded = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() * 2, this.getHeight(), 8.0, 8.0);
            g2D.fill(rectangleRounded);
        }
        g2D.dispose();
    }
}

