/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.toolbar.group.ExpandToolbarGroupActions;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import javax.swing.SwingUtilities;

public class ToolbarGroupExpander {
    private Actions actions;
    private ToolbarGroupDockStation station;
    private DockController controller;
    private ColumnHandler columnHandler = new ColumnHandler();
    private StrategyHandler strategyHandler = new StrategyHandler();
    private PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        protected void valueChanged(ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeExpandedListener(ToolbarGroupExpander.this.strategyHandler);
            }
            if (newValue != null) {
                newValue.addExpandedListener(ToolbarGroupExpander.this.strategyHandler);
                ToolbarGroupExpander.this.columnHandler.validateAll();
            }
        }
    };

    public ToolbarGroupExpander(ToolbarGroupDockStation station) {
        this.station = station;
        this.setController(station.getController());
        station.getColumnModel().addListener(new ToolbarColumnModelListener<Dockable, StationChildHandle>(){

            @Override
            public void removed(ToolbarColumnModel<Dockable, StationChildHandle> model, ToolbarColumn<Dockable, StationChildHandle> column, int index) {
                column.removeListener(ToolbarGroupExpander.this.columnHandler);
            }

            @Override
            public void inserted(ToolbarColumnModel<Dockable, StationChildHandle> model, ToolbarColumn<Dockable, StationChildHandle> column, int index) {
                column.addListener(ToolbarGroupExpander.this.columnHandler);
            }
        });
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            if (this.actions != null) {
                this.actions.setModel(null);
                this.actions.destroy();
                this.actions = null;
            }
            this.controller = controller;
            this.strategy.setProperties(controller);
            if (controller != null) {
                this.actions = new Actions(controller);
                this.actions.setModel(this.station.getColumnModel());
            }
        }
    }

    public ColumnDockActionSource getActions() {
        return this.actions;
    }

    private ExpandableToolbarItemStrategy getStrategy() {
        return (ExpandableToolbarItemStrategy)this.strategy.getValue();
    }

    private class Actions
    extends ExpandToolbarGroupActions<StationChildHandle> {
        public Actions(DockController controller) {
            super(controller, ToolbarGroupExpander.this.station);
        }

        @Override
        protected void uninstallListener(StationChildHandle item, ComponentListener listener) {
            item.getDockable().getComponent().removeComponentListener(listener);
        }

        @Override
        protected void installListener(StationChildHandle item, ComponentListener listener) {
            item.getDockable().getComponent().addComponentListener(listener);
        }

        @Override
        protected Rectangle getBoundaries(StationChildHandle item) {
            Rectangle result = this.getBoundaries(item.getDockable().getComponent());
            Rectangle title = null;
            if (item.getTitle() != null) {
                title = this.getBoundaries(item.getTitle().getComponent());
                result = result == null ? title : result.union(title);
            }
            return result;
        }

        @Override
        private Rectangle getBoundaries(Component component) {
            Rectangle bounds = component.getBounds();
            if (SwingUtilities.isDescendingFrom(component, ToolbarGroupExpander.this.station.getComponent())) {
                return SwingUtilities.convertRectangle(component.getParent(), bounds, ToolbarGroupExpander.this.station.getComponent());
            }
            return null;
        }
    }

    private class ColumnHandler
    implements ToolbarColumnListener<Dockable, StationChildHandle> {
        private ColumnHandler() {
        }

        @Override
        public void inserted(ToolbarColumn<Dockable, StationChildHandle> column, StationChildHandle item, final Dockable dockable, int index) {
            final ExpandableToolbarItemStrategy strategy = ToolbarGroupExpander.this.getStrategy();
            if (strategy != null) {
                int count = 0;
                int length = column.getDockableCount();
                ExpandedState state = null;
                while (count < length && state == null) {
                    if (count != index) {
                        state = strategy.getState(column.getDockable(count++));
                        continue;
                    }
                    ++count;
                }
                if (state != null) {
                    if (ToolbarGroupExpander.this.controller != null) {
                        final ExpandedState newState = state;
                        ToolbarGroupExpander.this.controller.getHierarchyLock().onRelease(new Runnable(){

                            @Override
                            public void run() {
                                ColumnHandler.this.set(strategy, dockable, newState);
                                ToolbarGroupExpander.this.actions.update(dockable);
                            }
                        });
                    } else {
                        this.set(strategy, dockable, state);
                    }
                }
            }
        }

        @Override
        public void removed(ToolbarColumn<Dockable, StationChildHandle> column, StationChildHandle item, Dockable dockable, int index) {
        }

        public void validateAll() {
            ToolbarColumnModel<Dockable, StationChildHandle> model = ToolbarGroupExpander.this.station.getColumnModel();
            int n = model.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.validate(model.getColumn((Dockable)i));
            }
        }

        public void validate(ToolbarColumn<Dockable, StationChildHandle> column) {
            ExpandableToolbarItemStrategy strategy = ToolbarGroupExpander.this.getStrategy();
            if (strategy != null) {
                int index = 0;
                int length = column.getDockableCount();
                ExpandedState state = null;
                while (index < length && state == null) {
                    state = strategy.getState(column.getDockable(index++));
                }
                while (index < length) {
                    Dockable item = column.getDockable(index++);
                    this.set(strategy, item, state);
                }
            }
        }

        private void set(ExpandableToolbarItemStrategy strategy, Dockable item, ExpandedState state) {
            if (strategy.isEnabled(item, state)) {
                strategy.setState(item, state);
                return;
            }
            ExpandedState smaller = state;
            while (smaller != smaller.smaller()) {
                if (!strategy.isEnabled(item, smaller = smaller.smaller())) continue;
                strategy.setState(item, smaller);
                return;
            }
            ExpandedState larger = state;
            while (larger != larger.larger()) {
                if (!strategy.isEnabled(item, larger = larger.larger())) continue;
                strategy.setState(item, larger);
                return;
            }
        }
    }

    private class StrategyHandler
    implements ExpandableToolbarItemStrategyListener {
        private StrategyHandler() {
        }

        @Override
        public void enablementChanged(Dockable item, ExpandedState state, boolean enabled) {
            ToolbarColumn<Dockable, StationChildHandle> column = ToolbarGroupExpander.this.station.getColumnModel().getColumn(item);
            if (column != null) {
                ToolbarGroupExpander.this.columnHandler.validate(column);
            }
        }

        @Override
        public void expanded(Dockable item) {
        }

        @Override
        public void shrunk(Dockable item) {
        }

        @Override
        public void stretched(Dockable item) {
        }
    }
}

