/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBar;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBarFactory;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlimScrollbar
extends JComponent
implements ColumnScrollBar,
Adjustable {
    private BoundedRangeModel model;
    private Orientation orientation = Orientation.HORIZONTAL;
    private List<AdjustmentListener> listeners = new ArrayList<AdjustmentListener>();
    private boolean hover = false;
    private boolean mousePressed = false;
    private float mouseOffset = 0.0f;
    public static final ColumnScrollBarFactory FACTORY = new ColumnScrollBarFactory(){

        @Override
        public ColumnScrollBar create(ToolbarGroupDockStation station) {
            return new SlimScrollbar();
        }
    };

    public SlimScrollbar() {
        this.model = new DefaultBoundedRangeModel(0, 0, 0, 1);
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdjustmentEvent event = new AdjustmentEvent(SlimScrollbar.this, 0, 0, SlimScrollbar.this.getValue());
                for (AdjustmentListener listener : SlimScrollbar.this.listeners) {
                    listener.adjustmentValueChanged(event);
                }
            }
        });
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SlimScrollbar.this.onMouseEvent(e, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SlimScrollbar.this.mousePressed = (e.getModifiersEx() & 0x1C00) != 0;
                SlimScrollbar.this.onMouseEvent(e, false);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                SlimScrollbar.this.onMouseEvent(e, true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SlimScrollbar.this.onMouseEvent(e, false);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SlimScrollbar.this.hover = false;
                SlimScrollbar.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SlimScrollbar.this.onMouseEvent(e, false);
            }
        };
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private void onMouseEvent(MouseEvent event, boolean mouseDown) {
        int value = this.model.getValue();
        int thumb = this.getThumbSize();
        float track = this.getTrack();
        int position = this.orientation == Orientation.HORIZONTAL ? event.getX() : event.getY();
        if (track > 0.0f) {
            float range = this.model.getMaximum() - this.model.getMinimum();
            float factor = range / track;
            if (mouseDown && !this.mousePressed) {
                this.mouseOffset = position - this.getThumbStart();
                if (this.mouseOffset < 0.0f || this.mouseOffset >= (float)thumb) {
                    this.mouseOffset = thumb / 2;
                }
                this.mousePressed = true;
            }
            if (mouseDown && this.mousePressed) {
                this.setValue((int)(((float)position - this.mouseOffset) * factor));
            }
        }
        this.hover = mouseDown ? true : (this.contains(event.getPoint()) ? value <= position && position <= value + thumb : false);
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(6, 6);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(6, 6);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        int value = this.getThumbStart();
        int thumb = this.getThumbSize();
        Rectangle2D.Double rec = null;
        int baseColorValue = 120;
        if (this.hover) {
            if (this.orientation == Orientation.HORIZONTAL) {
                g2D.setPaint(new GradientPaint(new Point(value, 0), new Color(240, 240, 240), new Point(value, 6), new Color(160, 160, 160)));
                rec = new Rectangle2D.Double(value, 0.0, thumb, 6.0);
            } else {
                g2D.setPaint(new GradientPaint(new Point(0, value), new Color(240, 240, 240), new Point(6, value), new Color(160, 160, 160)));
                rec = new Rectangle2D.Double(0.0, value, 6.0, thumb);
            }
        } else if (this.orientation == Orientation.HORIZONTAL) {
            g2D.setPaint(new GradientPaint(new Point(value, 0), new Color(210, 210, 210), new Point(value, 6), new Color(120, 120, 120)));
            rec = new Rectangle2D.Double(value, 0.0, thumb, 6.0);
        } else {
            g2D.setPaint(new GradientPaint(new Point(0, value), new Color(210, 210, 210), new Point(6, value), new Color(120, 120, 120)));
            rec = new Rectangle2D.Double(0.0, value, 6.0, thumb);
        }
        g2D.fill(rec);
    }

    private int getThumbStart() {
        float range = this.model.getMaximum() - this.model.getMinimum();
        float track = this.getTrack();
        return (int)((float)this.model.getValue() * (track / range));
    }

    private int getThumbSize() {
        float range = this.model.getMaximum() - this.model.getMinimum();
        float extent = this.model.getExtent();
        float track = this.getTrack();
        int thumb = (int)(track * (extent / range));
        thumb = Math.max(thumb, 20);
        thumb = Math.min(thumb, (int)track);
        return thumb;
    }

    private int getTrack() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    @Override
    public void setValues(int required, int available) {
        this.model.setMaximum(required);
        this.model.setExtent(available);
    }

    @Override
    public int getValue() {
        return this.model.getValue();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.revalidate();
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getOrientation() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return 0;
        }
        return 1;
    }

    @Override
    public void setMinimum(int min) {
        this.model.setMinimum(min);
    }

    @Override
    public int getMinimum() {
        return this.model.getMinimum();
    }

    @Override
    public void setMaximum(int max) {
        this.model.setMaximum(max);
    }

    @Override
    public int getMaximum() {
        return this.model.getMaximum();
    }

    @Override
    public void setUnitIncrement(int u) {
    }

    @Override
    public int getUnitIncrement() {
        return 0;
    }

    @Override
    public void setBlockIncrement(int b) {
    }

    @Override
    public int getBlockIncrement() {
        return 0;
    }

    @Override
    public void setVisibleAmount(int v) {
    }

    @Override
    public int getVisibleAmount() {
        return 0;
    }

    @Override
    public void setValue(int v) {
        this.model.setValue(v);
    }
}

