/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;

public class ToolbarMovingImageFactory
implements DockableMovingImageFactory {
    private DockableMovingImageFactory delegate;

    public ToolbarMovingImageFactory(DockableMovingImageFactory delegate) {
        this.delegate = delegate;
    }

    public MovingImage create(DockController controller, DockTitle snatched) {
        ToolbarStrategy strategy = (ToolbarStrategy)controller.getProperties().get(ToolbarStrategy.STRATEGY);
        MovingImage image = null;
        if (strategy.isToolbarPart(snatched.getDockable())) {
            image = this.delegate.create(controller, snatched);
        }
        if (image == null) {
            return null;
        }
        return new OffsetWrapper(image);
    }

    public MovingImage create(DockController controller, Dockable dockable) {
        ToolbarStrategy strategy = (ToolbarStrategy)controller.getProperties().get(ToolbarStrategy.STRATEGY);
        MovingImage image = null;
        if (strategy.isToolbarPart(dockable)) {
            image = this.delegate.create(controller, dockable);
        }
        if (image == null) {
            return null;
        }
        return new OffsetWrapper(image);
    }

    private class OffsetWrapper
    implements MovingImage {
        private MovingImage image;

        public OffsetWrapper(MovingImage image) {
            this.image = image;
        }

        public Point getOffset(Point pressPoint) {
            return new Point(-pressPoint.x, -pressPoint.y);
        }

        public void bind(boolean transparency) {
            this.image.bind(transparency);
        }

        public void unbind() {
            this.image.unbind();
        }

        public Component getComponent() {
            return this.image.getComponent();
        }
    }
}

