/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Orientation;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;

public class ToolbarGroupDockStationLayout {
    private final PlaceholderMap placeholders;
    private final ExpandedState state;

    public ToolbarGroupDockStationLayout(PlaceholderMap map, ExpandedState state) {
        this.placeholders = map;
        this.state = state;
    }

    public PlaceholderMap getPlaceholders() {
        return this.placeholders;
    }

    public ExpandedState getState() {
        return this.state;
    }

    public static void writeOrientation(PlaceholderMap map, Orientation orientation) {
        PlaceholderMap.Key key = map.newKey("group", new Path[0]);
        switch (orientation) {
            case HORIZONTAL: {
                map.putString(key, "orientation", "horizontal");
                break;
            }
            case VERTICAL: {
                map.putString(key, "orientation", "vertical");
            }
        }
    }

    public static Orientation readOrientation(PlaceholderMap map) {
        PlaceholderMap.Key key = map.newKey("group", new Path[0]);
        String orientation = map.getString(key, "orientation");
        if ("horizontal".equals(orientation)) {
            return Orientation.HORIZONTAL;
        }
        if ("vertical".equals(orientation)) {
            return Orientation.VERTICAL;
        }
        return null;
    }
}

