/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarDockStationFactory
implements DockFactory<ToolbarDockStation, ToolbarDockPerspective, ToolbarDockStationLayout> {
    public static final String ID = "ToolbarDockStationFactory";

    public String getID() {
        return ID;
    }

    public ToolbarDockStationLayout getLayout(ToolbarDockStation element, Map<Dockable, Integer> children) {
        PlaceholderMap map = element.getPlaceholders(children);
        return new ToolbarDockStationLayout(map, element.getExpandedState());
    }

    public ToolbarDockStationLayout getPerspectiveLayout(ToolbarDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        PlaceholderMap map = element.getPlaceholders(children);
        return new ToolbarDockStationLayout(map, element.getExpandedState());
    }

    public void setLayout(ToolbarDockStation element, ToolbarDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        element.setExpandedState(layout.getState(), false);
        element.setPlaceholders(layout.getPlaceholders(), children);
    }

    public void setLayout(ToolbarDockStation element, ToolbarDockStationLayout layout, PlaceholderStrategy placeholders) {
        element.setExpandedState(layout.getState(), false);
    }

    public void write(ToolbarDockStationLayout layout, DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_1);
        layout.getPlaceholders().write(out);
        out.writeUTF(layout.getState().name());
    }

    public void write(ToolbarDockStationLayout layout, XElement element) {
        XElement xplaceholders = element.addElement("placeholders");
        layout.getPlaceholders().write(xplaceholders);
        element.addElement("expanded").setString(layout.getState().name());
    }

    public ToolbarDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read((DataInputStream)in);
        version.checkCurrent();
        PlaceholderMap map = new PlaceholderMap(in, placeholders);
        map.setPlaceholderStrategy(null);
        ExpandedState state = ExpandedState.valueOf(in.readUTF());
        return new ToolbarDockStationLayout(map, state);
    }

    public ToolbarDockStationLayout read(XElement element, PlaceholderStrategy strategy) {
        XElement xplaceholders = element.getElement("placeholders");
        XElement xexpanded = element.getElement("expanded");
        PlaceholderMap map = new PlaceholderMap(xplaceholders, strategy);
        map.setPlaceholderStrategy(null);
        ExpandedState state = ExpandedState.SHRUNK;
        if (xexpanded != null) {
            state = ExpandedState.valueOf(xexpanded.getString());
        }
        return new ToolbarDockStationLayout(map, state);
    }

    public void estimateLocations(ToolbarDockStationLayout layout, final LocationEstimationMap children) {
        DockablePlaceholderList.simulatedRead((PlaceholderMap)layout.getPlaceholders(), (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, Dockable>(){

            public Dockable convert(ConvertedPlaceholderListItem item) {
                int id = item.getInt("id");
                int index = item.getInt("index");
                Path placeholder = null;
                if (item.contains("placeholder")) {
                    placeholder = new Path(item.getString("placeholder"));
                }
                children.setLocation(id, (DockableProperty)new ToolbarProperty(index, placeholder));
                int n = children.getSubChildCount(id);
                for (int i = 0; i < n; ++i) {
                    DockLayoutInfo info = children.getSubChild(id, i);
                    info.setLocation((DockableProperty)new ToolbarProperty(index, info.getPlaceholder()));
                }
                return null;
            }
        });
    }

    public ToolbarDockStation layout(ToolbarDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        ToolbarDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    public ToolbarDockStation layout(ToolbarDockStationLayout layout, PlaceholderStrategy placeholders) {
        ToolbarDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    public ToolbarDockPerspective layoutPerspective(ToolbarDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        return new ToolbarDockPerspective(layout, children);
    }

    public void layoutPerspective(ToolbarDockPerspective perspective, ToolbarDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout, children);
    }

    protected ToolbarDockStation createStation() {
        return new ToolbarDockStation();
    }
}

