/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.station.support.ListSpanStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDropInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class ToolbarContainerLayoutManager
implements LayoutManager2 {
    private JComponent parent;
    private ToolbarContainerDockStation station;
    private ListSpanStrategy spans;

    public ToolbarContainerLayoutManager(JComponent parent, ToolbarContainerDockStation station) {
        this.parent = parent;
        this.station = station;
        this.spans = this.createSpans();
    }

    public void setController(DockController controller) {
        this.spans.setController(controller);
    }

    public void setDrawing(ToolbarContainerDropInfo info) {
        if (info == null) {
            this.spans.untease();
        } else {
            int index = info.getIndex();
            Position position = info.getSideDockableBeneathMouse();
            if (position == Position.SOUTH || position == Position.EAST) {
                ++index;
            }
            this.spans.tease(index);
            if (this.station.getOrientation() == Orientation.HORIZONTAL) {
                this.spans.size(index, info.getItem().getComponent().getWidth());
            } else {
                this.spans.size(index, info.getItem().getComponent().getHeight());
            }
        }
    }

    private ListSpanStrategy createSpans() {
        return new ListSpanStrategy("dock.spanFactory.toolbar.container", this.station){

            protected void spanResized() {
                ToolbarContainerLayoutManager.this.parent.revalidate();
            }

            protected boolean isHorizontal() {
                return ToolbarContainerLayoutManager.this.station.getOrientation() == Orientation.HORIZONTAL;
            }

            protected int getNumberOfDockables() {
                return ToolbarContainerLayoutManager.this.station.getDockableCount();
            }
        };
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.spans.reset();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.spans.reset();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.station.getOrientation() == Orientation.VERTICAL) {
            int width = this.spans.getTeasing();
            int height = 0;
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension size = parent.getComponent(i).getPreferredSize();
                width = Math.max(size.width, width);
                height += size.height;
                height += this.spans.getGap(i);
            }
            return new Dimension(width, height += this.spans.getGap(parent.getComponentCount()));
        }
        int width = 0;
        int height = this.spans.getTeasing();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Dimension size = parent.getComponent(i).getPreferredSize();
            height = Math.max(size.height, height);
            width += size.width;
            width += this.spans.getGap(i);
        }
        return new Dimension(width += this.spans.getGap(parent.getComponentCount()), height);
    }

    @Override
    public void layoutContainer(Container parent) {
        block11: {
            int gaps;
            Dimension preferred;
            block10: {
                preferred = this.preferredLayoutSize(parent);
                gaps = 0;
                int n = parent.getComponentCount();
                for (int i = 0; i <= n; ++i) {
                    gaps += this.spans.getGap(i);
                }
                if (this.station.getOrientation() != Orientation.HORIZONTAL) break block10;
                if (preferred.width <= gaps) break block11;
                float factor = (float)parent.getWidth() / (float)(preferred.width - gaps);
                if (factor > 1.0f) {
                    factor = 1.0f;
                } else if (factor < 0.0f) {
                    factor = 0.0f;
                }
                int x = 0;
                int height = parent.getHeight();
                int n2 = parent.getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    Component child = parent.getComponent(i);
                    Dimension size = child.getPreferredSize();
                    int width = (int)((float)size.width * factor);
                    child.setBounds(x += this.spans.getGap(i), 0, width, Math.min(height, size.height));
                    x += width;
                }
                break block11;
            }
            if (preferred.height > gaps) {
                float factor = (float)parent.getHeight() / (float)(preferred.height - gaps);
                if (factor > 1.0f) {
                    factor = 1.0f;
                } else if (factor < 0.0f) {
                    factor = 0.0f;
                }
                int y = 0;
                int width = parent.getWidth();
                int n = parent.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component child = parent.getComponent(i);
                    Dimension size = child.getPreferredSize();
                    int height = (int)((float)size.height * factor);
                    child.setBounds(0, y += this.spans.getGap(i), Math.min(width, size.width), height);
                    y += height;
                }
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.spans.reset();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

