/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ListDockableStationPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarContainerDockPerspective
extends ListDockableStationPerspective {
    public ToolbarContainerDockPerspective() {
        this.setDockables((PerspectivePlaceholderList<PerspectiveDockable>)new PerspectivePlaceholderList());
    }

    public ToolbarContainerDockPerspective(ToolbarContainerDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        this.read(layout, children);
    }

    public void read(ToolbarContainerDockStationLayout layout, final Map<Integer, PerspectiveDockable> children) {
        PlaceholderMap map = layout.getPlaceholders();
        if (!map.getFormat().equals((Object)new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown format: " + map.getFormat());
        }
        if (map.getVersion() != 0) {
            throw new IllegalArgumentException("unknown version: " + map.getVersion());
        }
        PlaceholderMap list = map.getMap(map.newKey("content", new Path[0]), "list");
        PerspectivePlaceholderList dockables = new PerspectivePlaceholderList();
        dockables.read(list, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            public PerspectiveDockable convert(ConvertedPlaceholderListItem item) {
                if (children == null) {
                    return null;
                }
                int id = item.getInt("id");
                PerspectiveDockable dockable = (PerspectiveDockable)children.get(id);
                dockable.setParent((PerspectiveStation)ToolbarContainerDockPerspective.this);
                return dockable;
            }
        });
        this.setDockables((PerspectivePlaceholderList<PerspectiveDockable>)dockables);
    }

    public String getFactoryID() {
        return "ToolbarContainerDockStationFactory";
    }

    @Override
    protected DockableProperty getDockableProperty(int index, Path placeholder, PerspectiveDockable child, PerspectiveDockable target) {
        return new ToolbarContainerProperty(index, placeholder);
    }
}

