/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.ToolbarItemDockable;
import bibliothek.gui.dock.station.ToolbarTabDockStation;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;

public class DefaultToolbarStrategy
implements ToolbarStrategy {
    @Override
    public Dockable ensureToolbarLayer(DockStation station, Dockable dockable) {
        if (station instanceof ToolbarDockStation) {
            return dockable;
        }
        if (station instanceof ToolbarGroupDockStation) {
            if (dockable instanceof ToolbarDockStation) {
                return dockable;
            }
            ToolbarDockStation replacement = new ToolbarDockStation();
            replacement.setOrientation(this.getOrientation(dockable));
            return replacement;
        }
        if (station instanceof ToolbarContainerDockStation || station instanceof ScreenDockStation) {
            if (dockable instanceof ToolbarGroupDockStation) {
                return dockable;
            }
            ToolbarGroupDockStation replacement = new ToolbarGroupDockStation();
            replacement.setOrientation(this.getOrientation(dockable));
            return replacement;
        }
        return null;
    }

    protected Orientation getOrientation(Dockable dockable) {
        Orientation orientation = null;
        if (dockable instanceof ToolbarItemDockable) {
            orientation = ((ToolbarItemDockable)dockable).getOrientation();
        } else if (dockable instanceof AbstractToolbarDockStation) {
            orientation = ((AbstractToolbarDockStation)dockable).getOrientation();
        }
        if (orientation == null) {
            orientation = Orientation.HORIZONTAL;
        }
        return orientation;
    }

    @Override
    public boolean isToolbarGroupPartParent(DockStation parent, Dockable child, boolean strong) {
        if (strong) {
            if (child instanceof ToolbarItemDockable) {
                return parent instanceof ToolbarDockStation;
            }
            if (child instanceof ToolbarDockStation) {
                return parent instanceof ToolbarGroupDockStation;
            }
            if (child instanceof ToolbarGroupDockStation) {
                return parent instanceof ToolbarContainerDockStation || parent instanceof ScreenDockStation || parent instanceof ToolbarContainerDockStation;
            }
            return false;
        }
        if (parent instanceof ScreenDockStation) {
            return true;
        }
        if (child instanceof ToolbarItemDockable && parent instanceof ToolbarTabDockStation) {
            return true;
        }
        if (this.isToolbarParent(parent)) {
            if (child instanceof ToolbarItemDockable || child instanceof ToolbarDockStation) {
                return true;
            }
            return child instanceof ToolbarGroupDockStation && (parent instanceof ToolbarGroupDockStation || parent instanceof ToolbarContainerDockStation);
        }
        return false;
    }

    private boolean isToolbarParent(DockStation station) {
        return station instanceof AbstractToolbarDockStation || station instanceof ToolbarContainerDockStation;
    }

    @Override
    public boolean isToolbarGroupPart(Dockable dockable) {
        return dockable instanceof ToolbarItemDockable || dockable instanceof ToolbarDockStation || dockable instanceof ToolbarGroupDockStation;
    }

    @Override
    public boolean isToolbarPart(Dockable dockable) {
        return dockable instanceof ToolbarGroupDockStation || this.isToolbarGroupPart(dockable);
    }
}

