/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.InserterSource;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Dimension;

public class ScreenToolbarInserter
implements Inserter {
    private final DockController controller;

    public ScreenToolbarInserter(DockController controller) {
        this.controller = controller;
    }

    public StationDropOperation before(InserterSource source) {
        return null;
    }

    protected ToolbarStrategy getStrategy() {
        return (ToolbarStrategy)this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
    }

    public StationDropOperation after(InserterSource source) {
        Dockable child;
        if (source.getOperation() != null || !(source.getParent() instanceof ScreenDockStation)) {
            return null;
        }
        ToolbarStrategy strategy = this.getStrategy();
        if (!strategy.isToolbarPart(child = source.getItem().getDockable())) {
            return null;
        }
        boolean accept = DockUtilities.acceptable((DockStation)source.getParent(), (Dockable)child);
        if (!accept) {
            return null;
        }
        return new Operation(source);
    }

    protected void execute(InserterSource source, Orientation orientation) {
        ToolbarStrategy strategy = this.getStrategy();
        Dockable child = source.getItem().getDockable();
        Dockable item = strategy.ensureToolbarLayer(source.getParent(), child);
        if (item != child) {
            item.setController(this.controller);
            item.asDockStation().drop(child);
            item.setController(null);
        }
        if (orientation != null && item.asDockStation() instanceof OrientedDockStation) {
            ((OrientedDockStation)item).setOrientation(orientation);
        }
        ScreenDockStation station = (ScreenDockStation)source.getParent();
        item.getComponent().validate();
        Dimension size = item.getComponent().getPreferredSize();
        ScreenDockProperty location = new ScreenDockProperty(source.getItem().getTitleX(), source.getItem().getTitleY(), size.width, size.height);
        station.drop(item, location, false);
    }

    private class Operation
    implements StationDropOperation {
        private final InserterSource source;
        private Orientation orientation;

        public Operation(InserterSource source) {
            this.source = source;
            Dockable dockable = source.getItem().getDockable();
            DockStation parent = dockable.getDockParent();
            this.orientation = null;
            if (parent instanceof OrientingDockStation) {
                this.orientation = ((OrientingDockStation)parent).getOrientationOf(dockable);
            } else if (dockable.asDockStation() instanceof OrientedDockStation) {
                this.orientation = ((OrientedDockStation)dockable.asDockStation()).getOrientation();
            }
        }

        public void draw() {
        }

        public void destroy(StationDropOperation next) {
        }

        public boolean isMove() {
            return false;
        }

        public void execute() {
            ScreenToolbarInserter.this.execute(this.source, this.orientation);
        }

        public DockStation getTarget() {
            return this.source.getParent();
        }

        public Dockable getItem() {
            return this.source.getItem().getDockable();
        }

        public CombinerTarget getCombination() {
            return null;
        }

        public DisplayerCombinerTarget getDisplayerCombination() {
            return null;
        }
    }
}

