/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.OrientingDockStation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OrientingDockStationEvent {
    private final OrientingDockStation station;
    private final Set<Dockable> children = new HashSet<Dockable>();

    public OrientingDockStationEvent(OrientingDockStation station) {
        this(station, null);
    }

    public OrientingDockStationEvent(OrientingDockStation station, Dockable[] children) {
        this.station = station;
        if (children == null) {
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.children.add(station.getDockable(i));
            }
        } else {
            for (Dockable child : children) {
                this.children.add(child);
            }
        }
    }

    public OrientingDockStation getStation() {
        return this.station;
    }

    public boolean isAffected(Dockable dockable) {
        return this.children.contains(dockable);
    }

    public Collection<Dockable> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }
}

