/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.DefaultToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverterCallback;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDropInfo;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerLayoutManager;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarContainerDropLayer;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.color.StationColor;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ToolbarContainerDockStation
extends AbstractDockableStation
implements OrientingDockStation,
OrientedDockStation {
    public static final String TITLE_ID = "toolbar.container";
    public static final String DISPLAYER_ID = "toolbar.container";
    public static final Orientation DEFAULT_ORIENTATION = Orientation.VERTICAL;
    private Orientation orientation = DEFAULT_ORIENTATION;
    private int dockablesMaxNumber = -1;
    private JPanel containerPanel;
    private Background background = new Background();
    protected OverpaintablePanelBase mainPanel;
    private BackgroundColor mainPanelBackground;
    private DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private final DisplayerCollection displayers;
    private DockTitleVersion title;
    private final DefaultDisplayerFactoryValue displayerFactory;
    private final DefaultStationPaintValue paint;
    private int indexBeneathMouse = -1;
    private Position sideAboveMouse = null;
    boolean prepareDropDraw = false;
    private Dockable removal = null;
    private final List<OrientingDockStationListener> orientingListeners = new ArrayList<OrientingDockStationListener>();
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            ToolbarContainerDockStation.this.dockables.setStrategy(newValue);
        }
    };
    private DockableShowingManager visibility;
    private VisibleListener visibleListener;
    private ToolbarContainerLayoutManager layoutManager;
    private int sideSnapSize = 10;

    public ToolbarContainerDockStation(Orientation orientation) {
        this(orientation, -1);
    }

    public ToolbarContainerDockStation(Orientation orientation, int maxNumberOfDockables) {
        this.orientation = orientation;
        this.setDockablesMaxNumber(maxNumberOfDockables);
        this.mainPanel = new OverpaintablePanelBase();
        this.mainPanelBackground = new BackgroundColor();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar", (DockStation)this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.toolbar.container", (DockStation)this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, "toolbar.container");
        DockableDisplayerListener listener = new DockableDisplayerListener(){

            public void discard(DockableDisplayer displayer) {
                ToolbarContainerDockStation.this.discard(displayer);
            }

            public void moveableElementChanged(DockableDisplayer displayer) {
            }
        };
        this.displayers.addDockableDisplayerListener(listener);
        this.setTitleIcon(null);
        new OrientationObserver((Dockable)this){

            @Override
            protected void orientationChanged(Orientation current) {
                if (current != null) {
                    ToolbarContainerDockStation.this.setOrientation(current);
                }
            }
        };
        this.visibility = new DockableShowingManager(this.listeners);
        this.visibleListener = new VisibleListener();
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (ToolbarContainerDockStation.this.getDockParent() == null) {
                        ToolbarContainerDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    ToolbarContainerDockStation.this.visibility.fire();
                }
            }
        });
    }

    private JPanel createPanel() {
        ConfiguredBackgroundPanel panel = new ConfiguredBackgroundPanel(Transparency.DEFAULT);
        panel.setBackground((BackgroundAlgorithm)this.background);
        this.layoutManager = new ToolbarContainerLayoutManager((JComponent)panel, this);
        panel.setLayout((LayoutManager)this.layoutManager);
        panel.setBorder((Border)new EmptyBorder(new Insets(3, 3, 3, 3)));
        return panel;
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler((DockComponentRoot)this, this.displayers);
    }

    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    public Dockable getDockable(int index) {
        return ((StationChildHandle)this.dockables.dockables().get(index)).getDockable();
    }

    public Dockable getFrontDockable() {
        return null;
    }

    public void setFrontDockable(Dockable dockable) {
    }

    public PlaceholderMap getPlaceholders() {
        return this.createConverter().getPlaceholders(this);
    }

    public PlaceholderMap getPlaceholders(Map<Dockable, Integer> children) {
        return this.createConverter().getPlaceholders(this, children);
    }

    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            public DockableProperty getLocationAt(Path placeholder) {
                int index = ToolbarContainerDockStation.this.dockables.getDockableIndex(placeholder);
                return new ToolbarContainerProperty(index, placeholder);
            }
        };
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.createConverter().setPlaceholders(this, placeholders);
    }

    public void setPlaceholders(PlaceholderMap placeholders, Map<Integer, Dockable> children) {
        this.createConverter().setPlaceholders(this, new ToolbarContainerConverterCallback(){
            int index = 0;

            @Override
            public StationChildHandle wrap(Dockable dockable) {
                return new StationChildHandle((DockStation)ToolbarContainerDockStation.this, ToolbarContainerDockStation.this.displayers, dockable, ToolbarContainerDockStation.this.title);
            }

            @Override
            public void adding(StationChildHandle handle) {
                ToolbarContainerDockStation.this.listeners.fireDockableAdding(handle.getDockable());
            }

            @Override
            public void added(StationChildHandle handle) {
                handle.updateDisplayer();
                ToolbarContainerDockStation.this.insertAt(handle, this.index++);
                handle.getDockable().setDockParent((DockStation)ToolbarContainerDockStation.this);
                ToolbarContainerDockStation.this.listeners.fireDockableAdded(handle.getDockable());
            }

            @Override
            public void setDockables(DockablePlaceholderList<StationChildHandle> list) {
                ToolbarContainerDockStation.this.setDockables((DockablePlaceholderList<StationChildHandle>)list, false);
            }

            @Override
            public void finished(DockablePlaceholderList<StationChildHandle> list) {
                if (ToolbarContainerDockStation.this.getController() != null) {
                    list.bind();
                    list.setStrategy(ToolbarContainerDockStation.this.getPlaceholderStrategy());
                }
            }
        }, placeholders, children);
    }

    protected ToolbarContainerConverter createConverter() {
        return new DefaultToolbarContainerConverter();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return (PlaceholderStrategy)this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategy.setValue((Object)strategy);
    }

    public DockableProperty getDockableProperty(Dockable child, Dockable target) {
        int index = this.indexOf(child);
        Path placeholder = null;
        PlaceholderStrategy strategy = this.getPlaceholderStrategy();
        if (strategy != null && (placeholder = target != null ? strategy.getPlaceholderFor(target) : strategy.getPlaceholderFor(child)) != null) {
            this.dockables.dockables().addPlaceholder(index, placeholder);
        }
        return new ToolbarContainerProperty(index, placeholder);
    }

    public void aside(AsideRequest request) {
        int index;
        DockableProperty location = request.getLocation();
        Path newPlaceholder = request.getPlaceholder();
        if (location instanceof ToolbarContainerProperty) {
            ToolbarContainerProperty toolbarLocation = (ToolbarContainerProperty)location;
            if (toolbarLocation.getSuccessor() == null) {
                index = this.dockables.getNextListIndex(toolbarLocation.getIndex(), toolbarLocation.getPlaceholder());
                if (newPlaceholder != null) {
                    this.dockables.list().insertPlaceholder(index, newPlaceholder);
                }
            } else {
                index = this.dockables.getListIndex(toolbarLocation.getIndex(), toolbarLocation.getPlaceholder());
                if (newPlaceholder != null) {
                    AsideAnswer answer;
                    DockStation station;
                    this.dockables.list().addPlaceholder(index, newPlaceholder);
                    StationChildHandle handle = (StationChildHandle)((PlaceholderList.Item)this.dockables.list().get(index)).getDockable();
                    if (handle != null && (station = handle.asDockable().asDockStation()) != null && (answer = request.forward(station)).isCanceled()) {
                        return;
                    }
                }
            }
        } else {
            index = this.dockables.dockables().size();
            if (newPlaceholder != null) {
                this.dockables.dockables().insertPlaceholder(index, newPlaceholder);
            }
        }
        request.answer((DockableProperty)new ToolbarContainerProperty(index, newPlaceholder));
    }

    public StationDragOperation prepareDrag(Dockable dockable) {
        this.removal = dockable;
        this.getComponent().repaint();
        return new StationDragOperation(){

            public void succeeded() {
                ToolbarContainerDockStation.this.removal = null;
                ToolbarContainerDockStation.this.getComponent().repaint();
            }

            public void canceled() {
                ToolbarContainerDockStation.this.removal = null;
                ToolbarContainerDockStation.this.getComponent().repaint();
            }
        };
    }

    public void setSideSnapSize(int sideSnapSize) {
        this.sideSnapSize = sideSnapSize;
    }

    public int getSideSnapSize() {
        return this.sideSnapSize;
    }

    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this){

            public Component getComponent() {
                return ToolbarContainerDockStation.this.getComponent();
            }
        }, new ToolbarContainerDropLayer(this)};
    }

    public StationDropOperation prepareDrop(StationDropItem item) {
        DockController controller = this.getController();
        Dockable dockable = item.getDockable();
        if (this.accept(dockable) && dockable.accept((DockStation)this)) {
            if (controller != null && !controller.getAcceptance().accept((DockStation)this, dockable)) {
                return null;
            }
            if (!this.getToolbarStrategy().isToolbarPart(dockable)) {
                return null;
            }
            ToolbarContainerDropInfo result = new ToolbarContainerDropInfo(dockable, this, this.dockables, item.getMouseX(), item.getMouseY()){

                public void execute() {
                    ToolbarContainerDockStation.this.drop(this);
                }

                public void destroy(StationDropOperation next) {
                    if (next == null || next.getTarget() != this.getTarget()) {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(null);
                    }
                    ToolbarContainerDockStation.this.indexBeneathMouse = -1;
                    ToolbarContainerDockStation.this.sideAboveMouse = null;
                    ToolbarContainerDockStation.this.prepareDropDraw = false;
                    ToolbarContainerDockStation.this.mainPanel.repaint();
                }

                @Override
                public int getIndex() {
                    return ToolbarContainerDockStation.this.indexOf(this.getDockableBeneathMouse());
                }

                public void draw() {
                    boolean effect = true;
                    ToolbarContainerDockStation.this.indexBeneathMouse = this.getIndex();
                    if (this.isMove()) {
                        int current;
                        int target = ToolbarContainerDockStation.this.moveIndex(this, ToolbarContainerDockStation.this.indexBeneathMouse);
                        boolean bl = effect = target != (current = ToolbarContainerDockStation.this.indexOf(this.getItem())) && target != current - 1;
                    }
                    if (effect) {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(this);
                        ToolbarContainerDockStation.this.prepareDropDraw = true;
                    } else {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(null);
                        ToolbarContainerDockStation.this.prepareDropDraw = false;
                    }
                    ToolbarContainerDockStation.this.sideAboveMouse = this.getSideDockableBeneathMouse();
                    ToolbarContainerDockStation.this.mainPanel.repaint();
                }
            };
            return result;
        }
        return null;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener listener) {
        this.orientingListeners.add(listener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener listener) {
        this.orientingListeners.remove(listener);
    }

    @Override
    public Orientation getOrientationOf(Dockable child) {
        return this.orientation;
    }

    public void setDockablesMaxNumber(int max) {
        this.dockablesMaxNumber = max;
    }

    public int getDockablesMaxNumber() {
        return this.dockablesMaxNumber;
    }

    protected void fireOrientingEvent() {
        OrientingDockStationEvent event = new OrientingDockStationEvent(this);
        for (OrientingDockStationListener listener : this.orientingListeners.toArray(new OrientingDockStationListener[this.orientingListeners.size()])) {
            listener.changed(event);
        }
    }

    private void drop(ToolbarContainerDropInfo dropInfo) {
        if (this.getDockables().dockables().size() == 0) {
            this.drop(dropInfo.getItem(), 0);
        }
        if (dropInfo.getItemPositionVSBeneathDockable() != Position.CENTER) {
            int indexBeneathMouse = this.indexOf(dropInfo.getDockableBeneathMouse());
            if (dropInfo.isMove()) {
                this.move(dropInfo.getItem(), this.moveIndex(dropInfo, indexBeneathMouse));
            } else {
                int increment = 0;
                if (dropInfo.getSideDockableBeneathMouse() == Position.SOUTH || dropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                    ++increment;
                }
                int dropIndex = indexBeneathMouse + increment;
                this.drop(dropInfo.getItem(), dropIndex);
            }
        }
    }

    private int moveIndex(ToolbarContainerDropInfo dropInfo, int indexBeneathMouse) {
        switch (this.getOrientation()) {
            case VERTICAL: {
                if (dropInfo.getItemPositionVSBeneathDockable() == Position.SOUTH) {
                    if (dropInfo.getSideDockableBeneathMouse() == Position.SOUTH) {
                        return indexBeneathMouse + 1;
                    }
                    return indexBeneathMouse;
                }
                if (dropInfo.getSideDockableBeneathMouse() == Position.SOUTH) {
                    return indexBeneathMouse;
                }
                return indexBeneathMouse - 1;
            }
            case HORIZONTAL: {
                if (dropInfo.getItemPositionVSBeneathDockable() == Position.EAST) {
                    if (dropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                        return indexBeneathMouse + 1;
                    }
                    return indexBeneathMouse;
                }
                if (dropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                    return indexBeneathMouse;
                }
                return indexBeneathMouse - 1;
            }
        }
        throw new IllegalStateException("unknown orientation: " + (Object)((Object)this.getOrientation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof ToolbarContainerProperty) {
            ToolbarContainerProperty toolbar = (ToolbarContainerProperty)property;
            Path placeholder = toolbar.getPlaceholder();
            boolean hasPlaceholder = false;
            int index = -1;
            StationChildHandle presetHandle = null;
            if (placeholder != null && (hasPlaceholder = this.dockables.hasPlaceholder(placeholder))) {
                index = this.dockables.getDockableIndex(placeholder);
                presetHandle = (StationChildHandle)this.dockables.getDockableAt(placeholder);
            }
            if (index == -1) {
                index = toolbar.getIndex();
            }
            if (toolbar.getSuccessor() != null) {
                DockablePlaceholderList<StationChildHandle> list = this.getDockables();
                Dockable preset = null;
                if (presetHandle != null) {
                    preset = presetHandle.asDockable();
                } else if (!hasPlaceholder && index >= 0 && index < list.dockables().size()) {
                    preset = ((StationChildHandle)list.dockables().get(index)).getDockable();
                }
                if (preset != null && preset.asDockStation() != null) {
                    return preset.asDockStation().drop(dockable, property.getSuccessor());
                }
            }
            int max = this.getDockables().dockables().size();
            if (hasPlaceholder && presetHandle == null && toolbar.getSuccessor() != null) {
                Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                DockController controller = this.getController();
                if (controller != null) {
                    controller.freezeLayout();
                }
                try {
                    this.add(replacement, -1, placeholder);
                    if (replacement != dockable && !replacement.asDockStation().drop(dockable, toolbar.getSuccessor())) {
                        replacement.asDockStation().drop(dockable);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (controller != null) {
                        controller.meltLayout();
                    }
                }
            }
            return this.drop(dockable, Math.max(0, Math.min(max, index)));
        }
        return false;
    }

    public void drop(Dockable dockable) {
        this.drop(dockable, this.getDockables().dockables().size());
    }

    private boolean drop(Dockable dockable, int index) {
        return this.add(dockable, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Dockable dockable, int indexWhereInsert) {
        if (this.getToolbarStrategy().isToolbarPart(dockable)) {
            DockController controller = this.getController();
            try {
                if (controller != null) {
                    controller.freezeLayout();
                }
                this.add(dockable, indexWhereInsert);
            }
            finally {
                if (controller != null) {
                    controller.meltLayout();
                }
            }
        }
    }

    public void move(Dockable dockable, DockableProperty property) {
    }

    public boolean canDrag(Dockable dockable) {
        return true;
    }

    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.remove(dockable);
    }

    public boolean canReplace(Dockable old, Dockable next) {
        return old.getClass() == next.getClass();
    }

    public void replace(Dockable old, Dockable next) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        if (controller != null) {
            controller.freezeLayout();
        }
        int index = this.indexOf(old);
        this.remove(old);
        this.add(next, index);
        controller.meltLayout();
    }

    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next);
    }

    public String getFactoryID() {
        return "ToolbarContainerDockStationFactory";
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme((DockStation)this, (DockFactory)new ToolbarContainerDockStationFactory());
    }

    public JPanel getContainerPanel() {
        return this.containerPanel;
    }

    public ToolbarStrategy getToolbarStrategy() {
        SilentPropertyValue value = new SilentPropertyValue(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy result = (ToolbarStrategy)value.getValue();
        value.setProperties((DockController)null);
        return result;
    }

    public boolean accept(Dockable child) {
        if (this.dockablesMaxNumber == -1) {
            return true;
        }
        return this.dockables.dockables().size() < this.dockablesMaxNumber;
    }

    public boolean accept(DockStation station) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private void setDockables(DockablePlaceholderList<StationChildHandle> list, boolean bind) {
        if (this.getController() != null) {
            DockablePlaceholderList<StationChildHandle> oldList = this.getDockables();
            oldList.setStrategy(null);
            oldList.unbind();
        }
        this.dockables = list;
        if (this.getController() != null && bind) {
            list.bind();
            list.setStrategy(this.getPlaceholderStrategy());
        }
    }

    public DockablePlaceholderList<StationChildHandle> getDockables() {
        return this.dockables;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.fireOrientingEvent();
    }

    private int indexOf(Dockable dockable) {
        for (int i = 0; i < this.dockables.dockables().size(); ++i) {
            if (((StationChildHandle)this.dockables.dockables().get(i)).getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking((DockStation)this, (Dockable)dockable);
        try {
            int index = this.indexOf(dockable);
            PlaceholderList.Filter dockables = this.getDockables().dockables();
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            StationChildHandle childHandle = (StationChildHandle)dockables.get(index);
            this.getDockables().remove(index);
            this.getContainerPanel().remove(childHandle.getDisplayer().getComponent());
            childHandle.destroy();
            this.mainPanel.getContentPane().revalidate();
            this.mainPanel.getContentPane().repaint();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(index);
        }
        finally {
            token.release();
        }
    }

    protected boolean add(Dockable dockable, int index) {
        return this.add(dockable, index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(Dockable dockable, int index, Path placeholder) {
        DockUtilities.ensureTreeValidity((DockStation)this, (Dockable)dockable);
        DockUtilities.checkLayoutLocked();
        ToolbarStrategy strategy = this.getToolbarStrategy();
        if (strategy.isToolbarPart(dockable)) {
            Dockable replacement = strategy.ensureToolbarLayer(this, dockable);
            if (replacement != dockable) {
                replacement.setController(this.getController());
                replacement.asDockStation().drop(dockable);
                replacement.setController(null);
                dockable = replacement;
            }
            DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking((DockStation)this, (Dockable)dockable);
            try {
                this.listeners.fireDockableAdding(dockable);
                PlaceholderList.Filter dockables = this.getDockables().dockables();
                StationChildHandle handle = new StationChildHandle((DockStation)this, this.displayers, dockable, this.title);
                if (placeholder != null) {
                    index = this.getDockables().put(placeholder, (PlaceholderListItem)handle);
                } else {
                    dockables.add(index, (Object)handle);
                }
                handle.updateDisplayer();
                this.insertAt(handle, index);
                dockable.setDockParent((DockStation)this);
                this.listeners.fireDockableAdded(dockable);
                this.fireDockablesRepositioned(index + 1);
            }
            finally {
                token.release();
            }
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            return true;
        }
        return false;
    }

    private void insertAt(StationChildHandle handle, int index) {
        Dockable dockable = handle.getDockable();
        dockable.setDockParent((DockStation)this);
        this.getContainerPanel().add(handle.getDisplayer().getComponent(), index);
        this.mainPanel.getContentPane().revalidate();
        this.mainPanel.getContentPane().repaint();
    }

    protected void discard(DockableDisplayer displayer) {
        int index = this.indexOf(displayer.getDockable());
        StationChildHandle handle = (StationChildHandle)this.getDockables().dockables().get(index);
        this.getContainerPanel().remove(displayer.getComponent());
        handle.updateDisplayer();
        this.insertAt(handle, index);
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public void setDockParent(DockStation station) {
        DockStation old = this.getDockParent();
        if (old != null) {
            old.removeDockStationListener((DockStationListener)this.visibleListener);
        }
        super.setDockParent(station);
        if (station != null) {
            station.addDockStationListener((DockStationListener)this.visibleListener);
        }
        this.visibility.fire();
    }

    public void setController(DockController controller) {
        if (this.getController() != controller) {
            if (this.getController() != null) {
                this.unbind(this.dockables);
            }
            super.setController(controller);
            this.paint.setController(controller);
            this.displayerFactory.setController(controller);
            this.layoutManager.setController(controller);
            this.background.setController(controller);
            this.mainPanelBackground.connect(controller);
            this.title = controller == null ? null : controller.getDockTitleManager().getVersion("toolbar.container", BasicDockTitleFactory.FACTORY);
            this.displayers.setController(controller);
            this.placeholderStrategy.setProperties(controller);
            if (controller != null) {
                this.bind(this.dockables, this.title);
            }
            this.visibility.fire();
        }
    }

    private void unbind(DockablePlaceholderList<StationChildHandle> list) {
        list.unbind();
        for (StationChildHandle handle : list.dockables()) {
            handle.setTitleRequest(null);
        }
    }

    private void bind(DockablePlaceholderList<StationChildHandle> list, DockTitleVersion title) {
        list.bind();
        for (StationChildHandle handle : list.dockables()) {
            handle.setTitleRequest(title, true);
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        public void dockableShowingChanged(DockStation station, Dockable dockable, boolean visible) {
            if (dockable == ToolbarContainerDockStation.this) {
                ToolbarContainerDockStation.this.visibility.fire();
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.toolbar.container");
        }

        public Component getComponent() {
            return ToolbarContainerDockStation.this.getComponent();
        }

        public DockStation getStation() {
            return ToolbarContainerDockStation.this;
        }
    }

    protected class OverpaintablePanelBase
    extends OverpaintablePanel {
        public OverpaintablePanelBase() {
            ToolbarContainerDockStation.this.containerPanel = ToolbarContainerDockStation.this.createPanel();
            this.setBasePane(ToolbarContainerDockStation.this.containerPanel);
            this.setContentPane(ToolbarContainerDockStation.this.containerPanel);
            this.setSolid(true);
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        }

        protected void paintOverlay(Graphics g) {
            this.paintRemoval(g);
            DefaultStationPaintValue paint = ToolbarContainerDockStation.this.getPaint();
            if (ToolbarContainerDockStation.this.prepareDropDraw) {
                if (ToolbarContainerDockStation.this.indexBeneathMouse != -1) {
                    Rectangle rectComponentBeneathMouse = ((StationChildHandle)ToolbarContainerDockStation.this.getDockables().dockables().get(ToolbarContainerDockStation.this.indexBeneathMouse)).getDisplayer().getComponent().getBounds();
                    Rectangle rectangleAreaBeneathMouse = ToolbarContainerDockStation.this.getContainerPanel().getBounds();
                    rectComponentBeneathMouse.translate(rectangleAreaBeneathMouse.x, rectangleAreaBeneathMouse.y);
                    switch (ToolbarContainerDockStation.this.getOrientation()) {
                        case VERTICAL: {
                            int y = ToolbarContainerDockStation.this.sideAboveMouse == Position.NORTH ? rectComponentBeneathMouse.y : rectComponentBeneathMouse.y + rectComponentBeneathMouse.height;
                            paint.drawInsertionLine(g, rectComponentBeneathMouse.x, y, rectComponentBeneathMouse.x + rectComponentBeneathMouse.width, y);
                            break;
                        }
                        case HORIZONTAL: {
                            int x = ToolbarContainerDockStation.this.sideAboveMouse == Position.WEST ? rectComponentBeneathMouse.x : rectComponentBeneathMouse.x + rectComponentBeneathMouse.width;
                            paint.drawInsertionLine(g, x, rectComponentBeneathMouse.y, x, rectComponentBeneathMouse.y + rectComponentBeneathMouse.height);
                        }
                    }
                } else {
                    paint.drawDivider(g, ToolbarContainerDockStation.this.getContainerPanel().getBounds());
                }
            }
        }

        private void paintRemoval(Graphics g) {
            if (ToolbarContainerDockStation.this.removal != null) {
                for (StationChildHandle handle : ToolbarContainerDockStation.this.dockables.dockables()) {
                    if (handle.getDockable() != ToolbarContainerDockStation.this.removal) continue;
                    Rectangle bounds = handle.getDisplayer().getComponent().getBounds();
                    ToolbarContainerDockStation.this.getPaint().drawRemoval(g, bounds, bounds);
                    break;
                }
            }
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }

    private class BackgroundColor
    extends StationColor {
        public BackgroundColor() {
            super("toolbar.container.background", (DockStation)ToolbarContainerDockStation.this, null);
        }

        protected void changed(Color oldValue, Color newValue) {
            ToolbarContainerDockStation.this.mainPanel.setBackground(newValue);
        }
    }
}

