/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.ToolbarSeparator;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocator;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.dockable.AncestorMovingImageFactory;
import bibliothek.gui.dock.dockable.DefaultDockableMovingImageFactory;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.frontend.DefaultFrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.DockFrontendExtension;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCacheExtension;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.ToolbarMiniButton;
import bibliothek.gui.dock.station.ToolbarTabDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenFilter;
import bibliothek.gui.dock.station.screen.ScreenDockStationExtension;
import bibliothek.gui.dock.station.screen.ScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.screen.ScreenToolbarDisplayerFactory;
import bibliothek.gui.dock.station.screen.ScreenToolbarDockTitleFactory;
import bibliothek.gui.dock.station.screen.ScreenToolbarInserter;
import bibliothek.gui.dock.station.screen.ToolbarScreenDockStationExtension;
import bibliothek.gui.dock.station.screen.ToolbarWindowConfiguration;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import bibliothek.gui.dock.station.screen.window.DefaultScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.toolbar.ToolbarAttractorStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerPropertyFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationMerger;
import bibliothek.gui.dock.station.toolbar.ToolbarDockableDisplayer;
import bibliothek.gui.dock.station.toolbar.ToolbarFullscreenFilter;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationMerger;
import bibliothek.gui.dock.station.toolbar.ToolbarItemDockableFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarMovingImageFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarPropertyFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarStationPaint;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupPropertyFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupTitle;
import bibliothek.gui.dock.station.toolbar.title.ToolbarDockTitlePoint;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.NullTitleFactory;
import bibliothek.gui.dock.toolbar.ToolbarDockFrontendExtension;
import bibliothek.gui.dock.toolbar.expand.ExpandManager;
import bibliothek.gui.dock.toolbar.item.DockActionItem;
import bibliothek.gui.dock.toolbar.perspective.ToolbarFrontendPerspectiveCacheExtension;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TextManager;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.wizard.WizardSplitDockStationFactory;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ToolbarExtension
implements Extension {
    public static final ViewTarget<BasicTitleViewItem<JComponent>> TOOLBAR_TITLE = new ViewTarget("target TOOLBAR TITLE");

    public void install(final DockController controller) {
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putDefault(ActionType.BUTTON, TOOLBAR_TITLE, (ViewGenerator)new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                BasicButtonHandler handler = new BasicButtonHandler(action, dockable);
                ToolbarMiniButton button = new ToolbarMiniButton((BasicTrigger)handler, (BasicResourceInitializer)handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        converter.putDefault(ActionType.MENU, TOOLBAR_TITLE, (ViewGenerator)new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                BasicMenuHandler handler = new BasicMenuHandler(action, dockable);
                ToolbarMiniButton button = new ToolbarMiniButton((BasicTrigger)handler, (BasicResourceInitializer)handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        converter.putDefault(ActionType.SEPARATOR, TOOLBAR_TITLE, (ViewGenerator)new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
                if (action.shouldDisplay(ViewTarget.TITLE)) {
                    return new ToolbarSeparator(action, Color.LIGHT_GRAY);
                }
                return null;
            }
        });
        converter.putDefault(ActionType.BUTTON, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.BUTTON, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        converter.putDefault(ActionType.CHECK, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.CHECK, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        converter.putDefault(ActionType.DROP_DOWN, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.DROP_DOWN, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        converter.putDefault(ActionType.MENU, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.MENU, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        converter.putDefault(ActionType.RADIO, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.RADIO, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        converter.putDefault(ActionType.SEPARATOR, DockActionItem.TOOLBAR, (ViewGenerator)new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
                return (BasicTitleViewItem)converter.createView(ActionType.SEPARATOR, (DockAction)action, ViewTarget.TITLE, dockable);
            }
        });
        IconManager icons = controller.getIcons();
        icons.setIconDefault("toolbar.item.expand.horizontal", this.loadIcon("expand_horizontal.png"));
        icons.setIconDefault("toolbar.item.expand.vertical", this.loadIcon("expand_vertical.png"));
        icons.setIconDefault("toolbar.item.expand.hover.horizontal", this.loadIcon("expand_hover_horizontal.png"));
        icons.setIconDefault("toolbar.item.expand.hover.vertical", this.loadIcon("expand_hover_vertical.png"));
        icons.setIconDefault("toolbar.item.shrink.horizontal", this.loadIcon("shrink_horizontal.png"));
        icons.setIconDefault("toolbar.item.shrink.vertical", this.loadIcon("shrink_vertical.png"));
        icons.setIconDefault("toolbar.item.shrink.hover.horizontal", this.loadIcon("shrink_hover_horizontal.png"));
        icons.setIconDefault("toolbar.item.shrink.hover.vertical", this.loadIcon("shrink_hover_vertical.png"));
        icons.setIconDefault("toolbar.item.larger.horizontal", this.loadIcon("larger_horizontal.png"));
        icons.setIconDefault("toolbar.item.larger.vertical", this.loadIcon("larger_vertical.png"));
        icons.setIconDefault("toolbar.item.larger.hover.horizontal", this.loadIcon("larger_hover_horizontal.png"));
        icons.setIconDefault("toolbar.item.larger.hover.vertical", this.loadIcon("larger_hover_vertical.png"));
        icons.setIconDefault("toolbar.item.smaller.horizontal", this.loadIcon("smaller_horizontal.png"));
        icons.setIconDefault("toolbar.item.smaller.vertical", this.loadIcon("smaller_vertical.png"));
        icons.setIconDefault("toolbar.item.smaller.hover.horizontal", this.loadIcon("smaller_hover_horizontal.png"));
        icons.setIconDefault("toolbar.item.smaller.hover.vertical", this.loadIcon("smaller_hover_vertical.png"));
        icons.setIconDefault("toolbar.customization.here", this.loadIcon("here.png"));
        icons.setIconDefault("toolbar.customization.check", this.loadIcon("check.png"));
        icons.setIconDefault("toolbar.customization.preferences", this.loadIcon("preferences.png"));
        new ExpandManager(controller);
        final ToolbarFullscreenFilter filter = new ToolbarFullscreenFilter(controller);
        controller.getRegister().addDockRegisterListener((DockRegisterListener)new DockRegisterAdapter(){

            public void dockStationRegistering(DockController controller, DockStation station) {
                if (station instanceof ScreenDockStation) {
                    ((ScreenDockStation)station).addFullscreenFilter((ScreenDockFullscreenFilter)filter);
                }
            }

            public void dockStationUnregistered(DockController controller, DockStation station) {
                if (station instanceof ScreenDockStation) {
                    ((ScreenDockStation)station).removeFullscreenFilter((ScreenDockFullscreenFilter)filter);
                }
            }
        });
        controller.getProperties().addListener(ExpandableToolbarItemStrategy.STRATEGY, (DockPropertyListener)new DockPropertyListener<ExpandableToolbarItemStrategy>(){

            public void propertyChanged(DockProperties properties, PropertyKey<ExpandableToolbarItemStrategy> property, ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
                if (oldValue != null) {
                    oldValue.uninstall(controller);
                }
                if (newValue != null) {
                    newValue.install(controller);
                }
            }
        });
        ((ExpandableToolbarItemStrategy)controller.getProperties().get(ExpandableToolbarItemStrategy.STRATEGY)).install(controller);
        controller.getThemeManager().put(Priority.THEME, "dock.paint.toolbar", ThemeManager.STATION_PAINT_TYPE, (Object)new ToolbarStationPaint(new Color(255, 0, 0, 125), new Color(128, 128, 128, 125)));
    }

    private Icon loadIcon(String name) {
        try {
            InputStream in = this.getClass().getResourceAsStream("/data/bibliothek/gui/toolbar/" + name);
            if (in == null) {
                throw new FileNotFoundException("cannot find file '" + name + "'");
            }
            ImageIcon icon = new ImageIcon(ImageIO.read(in));
            in.close();
            return icon;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void uninstall(DockController controller) {
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putDefault(ActionType.BUTTON, TOOLBAR_TITLE, null);
    }

    public <E> Collection<E> load(DockController controller, ExtensionName<E> extension) {
        if (extension.getName().equals((Object)PropertyTransformer.FACTORY_EXTENSION)) {
            return this.createPropertyFactoryExtension();
        }
        if (extension.getName().equals((Object)DefaultDockRelocator.MERGE_EXTENSION)) {
            return this.createMergerExtension();
        }
        if (extension.getName().equals((Object)DefaultDockRelocator.INSERTER_EXTENSION)) {
            return this.createInserterExtension(controller);
        }
        if (extension.getName().equals((Object)ScreenDockStation.ATTRACTOR_STRATEGY_EXTENSION)) {
            return this.createAttractorStrategies();
        }
        if (extension.getName().equals((Object)DockSituation.DOCK_FACTORY_EXTENSION)) {
            return this.createDockFactories();
        }
        if (extension.getName().equals((Object)DockThemeExtension.DOCK_THEME_EXTENSION)) {
            return this.createDockThemeExtension();
        }
        if (extension.getName().equals((Object)DockTitleVersion.DOCK_TITLE_VERSION_EXTENSION)) {
            return this.createTitleFactories((DockTitleVersion)extension.get("version"));
        }
        if (extension.getName().equals((Object)DisplayerFactory.DISPLAYER_EXTENSION)) {
            return this.createDisplayerFactories(controller, (String)extension.get("name"));
        }
        if (extension.getName().equals((Object)TextManager.TEXT_EXTENSION)) {
            return this.createBundles((Locale)extension.get("locale"));
        }
        if (extension.getName().equals((Object)DefaultScreenDockWindowConfiguration.CONFIGURATION_EXTENSION)) {
            return this.createWindowConfigurationExtension(controller);
        }
        if (extension.getName().equals((Object)DefaultDockableMovingImageFactory.FACTORY_EXTENSION)) {
            return this.createMovingImageFactory();
        }
        if (extension.getName().equals((Object)ScreenDockStation.STATION_EXTENSION)) {
            return this.createScreenDockStationExtension(controller);
        }
        if (extension.getName().equals((Object)DefaultFrontendPerspectiveCache.CACHE_EXTENSION)) {
            return this.createPerspectiveCacheExtensions();
        }
        if (extension.getName().equals((Object)DockFrontend.FRONTEND_EXTENSION)) {
            return this.createFrontendExtensions();
        }
        return null;
    }

    protected Collection<DockablePropertyFactory> createPropertyFactoryExtension() {
        ArrayList<DockablePropertyFactory> result = new ArrayList<DockablePropertyFactory>();
        result.add(new ToolbarPropertyFactory());
        result.add(new ToolbarContainerPropertyFactory());
        result.add(new ToolbarGroupPropertyFactory());
        return result;
    }

    protected Collection<Merger> createMergerExtension() {
        ArrayList<Merger> result = new ArrayList<Merger>();
        result.add(new ToolbarDockStationMerger());
        result.add(new ToolbarGroupDockStationMerger());
        return result;
    }

    protected Collection<Inserter> createInserterExtension(DockController controller) {
        ArrayList<Inserter> result = new ArrayList<Inserter>();
        result.add(new ScreenToolbarInserter(controller));
        return result;
    }

    protected Collection<AttractorStrategy> createAttractorStrategies() {
        ArrayList<AttractorStrategy> result = new ArrayList<AttractorStrategy>();
        result.add(new ToolbarAttractorStrategy());
        return result;
    }

    protected Collection<DockFactory<?, ?, ?>> createDockFactories() {
        ArrayList result = new ArrayList();
        result.add(new ToolbarGroupDockStationFactory());
        result.add(new ToolbarDockStationFactory());
        result.add(new ToolbarContainerDockStationFactory());
        result.add((DockFactory<?, ?, ?>)new ToolbarTabDockStationFactory());
        result.add((DockFactory<?, ?, ?>)new WizardSplitDockStationFactory());
        result.add(new ToolbarItemDockableFactory());
        return result;
    }

    protected Collection<DockTitleFactory> createTitleFactories(DockTitleVersion version) {
        if (version.getID().equals("screen dock")) {
            ArrayList<DockTitleFactory> result = new ArrayList<DockTitleFactory>();
            result.add(new ScreenToolbarDockTitleFactory(version.getController()));
            return result;
        }
        return null;
    }

    protected Collection<DisplayerFactory> createDisplayerFactories(DockController controller, String id) {
        if (id.equals("screen")) {
            ArrayList<DisplayerFactory> result = new ArrayList<DisplayerFactory>();
            result.add(new ScreenToolbarDisplayerFactory(controller));
            return result;
        }
        return null;
    }

    protected Collection<ResourceBundle> createBundles(Locale language) {
        ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>();
        result.add(ResourceBundle.getBundle("data.bibliothek.gui.toolbar.locale.toolbar", language, this.getClass().getClassLoader()));
        return result;
    }

    protected Collection<DockThemeExtension> createDockThemeExtension() {
        DockThemeExtension extension = new DockThemeExtension(){

            public void installed(DockController controller, DockTheme theme) {
                ThemeManager manager = controller.getThemeManager();
                manager.put(Priority.THEME, "dock.displayer.toolbar", ThemeManager.DISPLAYER_FACTORY_TYPE, (Object)ToolbarDockableDisplayer.FACTORY);
                manager.put(Priority.THEME, "dock.displayer.toolbar.simple", ThemeManager.DISPLAYER_FACTORY_TYPE, (Object)ToolbarDockableDisplayer.FACTORY);
                manager.put(Priority.THEME, "dock.displayer.toolbar.group", ThemeManager.DISPLAYER_FACTORY_TYPE, (Object)ToolbarDockableDisplayer.FACTORY);
                manager.put(Priority.THEME, "dock.displayer.toolbar.container", ThemeManager.DISPLAYER_FACTORY_TYPE, (Object)ToolbarDockableDisplayer.FACTORY);
                manager.put(Priority.THEME, "dock.displayer.toolbar.screen", ThemeManager.DISPLAYER_FACTORY_TYPE, (Object)ToolbarDockableDisplayer.FACTORY);
                DockTitleManager titles = controller.getDockTitleManager();
                titles.registerTheme("toolbar.group", ToolbarDockTitlePoint.createFactory());
                titles.registerTheme("toolbar", (DockTitleFactory)NullTitleFactory.INSTANCE);
                titles.registerTheme("toolbar.container", ToolbarGroupTitle.FACTORY);
                titles.registerTheme("toolbar.screen", ToolbarGroupTitle.FACTORY);
            }

            public void install(DockController controller, DockTheme theme) {
            }

            public void uninstall(DockController controller, DockTheme theme) {
            }
        };
        return Collections.singleton(extension);
    }

    protected Collection<ScreenDockWindowConfiguration> createWindowConfigurationExtension(DockController controller) {
        ArrayList<ScreenDockWindowConfiguration> result = new ArrayList<ScreenDockWindowConfiguration>();
        result.add(new ToolbarWindowConfiguration(controller));
        return result;
    }

    protected Collection<DockableMovingImageFactory> createMovingImageFactory() {
        ArrayList<DockableMovingImageFactory> result = new ArrayList<DockableMovingImageFactory>();
        result.add(new ToolbarMovingImageFactory((DockableMovingImageFactory)new AncestorMovingImageFactory(null, 0.5f)));
        return result;
    }

    protected Collection<ScreenDockStationExtension> createScreenDockStationExtension(DockController controller) {
        ArrayList<ScreenDockStationExtension> result = new ArrayList<ScreenDockStationExtension>();
        result.add(new ToolbarScreenDockStationExtension(controller));
        return result;
    }

    protected Collection<FrontendPerspectiveCacheExtension> createPerspectiveCacheExtensions() {
        ArrayList<FrontendPerspectiveCacheExtension> result = new ArrayList<FrontendPerspectiveCacheExtension>();
        result.add(new ToolbarFrontendPerspectiveCacheExtension());
        return result;
    }

    protected Collection<DockFrontendExtension> createFrontendExtensions() {
        ArrayList<DockFrontendExtension> result = new ArrayList<DockFrontendExtension>();
        result.add(new ToolbarDockFrontendExtension());
        return result;
    }
}

