/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.station.AbstractResizeRequestHandler;
import bibliothek.gui.dock.common.layout.RequestDimension;

public class FlapResizeRequestHandler
extends AbstractResizeRequestHandler {
    private FlapDockStation station;

    public FlapResizeRequestHandler(FlapDockStation station) {
        this.station = station;
    }

    @Override
    public void handleResizeRequest(CControl control) {
        boolean horizontal = this.station.getDirection() == FlapDockStation.Direction.SOUTH || this.station.getDirection() == FlapDockStation.Direction.NORTH;
        int n = this.station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = this.station.getDockable(i);
            RequestDimension size = this.getAndClearResizeRequest(dockable);
            if (size == null) continue;
            if (horizontal) {
                if (!size.isWidthSet()) continue;
                this.station.setWindowSize(dockable, size.getWidth());
                continue;
            }
            if (!size.isHeightSet()) continue;
            this.station.setWindowSize(dockable, size.getHeight());
        }
    }
}

