/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CStationContainerListener;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.frontend.FrontendEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultCControlRegister
implements MutableCControlRegister {
    private CControl control;
    private CContentArea content;
    private boolean settingDefaultStations = false;
    private List<CStationContainer> containers = new ArrayList<CStationContainer>();
    private CommonSingleDockableFactory backupFactory;
    private Map<String, CommonMultipleDockableFactory> factories = new HashMap<String, CommonMultipleDockableFactory>();
    private List<CDockable> dockables = new ArrayList<CDockable>();
    private List<SingleCDockable> singleDockables = new ArrayList<SingleCDockable>();
    private List<MultipleCDockable> multiDockables = new ArrayList<MultipleCDockable>();
    private List<CStation<?>> stations = new ArrayList();
    private CStationContainerListener containerListener = new CStationContainerListener(){

        @Override
        public void removed(CStationContainer source, CStation<?> station) {
            DefaultCControlRegister.this.control.removeStation(station);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void added(CStationContainer source, CStation<?> station) {
            try {
                DefaultCControlRegister.this.settingDefaultStations = source == DefaultCControlRegister.this.content;
                DefaultCControlRegister.this.control.addStation(station, true);
            }
            finally {
                DefaultCControlRegister.this.settingDefaultStations = false;
            }
        }
    };

    public DefaultCControlRegister(CControl control) {
        this.control = control;
        this.backupFactory = new CommonSingleDockableFactory(control);
    }

    @Override
    public CControl getControl() {
        return this.control;
    }

    @Override
    public List<CDockable> getDockables() {
        return Collections.unmodifiableList(this.dockables);
    }

    @Override
    public List<MultipleCDockable> getMultipleDockables() {
        return Collections.unmodifiableList(this.multiDockables);
    }

    @Override
    public List<SingleCDockable> getSingleDockables() {
        return Collections.unmodifiableList(this.singleDockables);
    }

    @Override
    public List<CStation<?>> getStations() {
        return Collections.unmodifiableList(this.stations);
    }

    @Override
    public List<CStationContainer> getStationContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    @Override
    public CStationContainer getContainer(CStation<?> child) {
        for (CStationContainer container : this.getStationContainers()) {
            int n = container.getStationCount();
            for (int i = 0; i < n; ++i) {
                if (container.getStation(i) != child) continue;
                return container;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStationContainer(CStationContainer container) {
        if (container == null) {
            throw new NullPointerException("container is null");
        }
        if (this.containers.contains(container)) {
            throw new IllegalArgumentException("container already registered");
        }
        for (CStationContainer child : this.containers) {
            if (!child.getUniqueId().equals(container.getUniqueId())) continue;
            throw new IllegalArgumentException("A container with unique id '" + container.getUniqueId() + "' is already registered");
        }
        this.containers.add(container);
        try {
            this.settingDefaultStations = container == this.content;
            int n = container.getStationCount();
            for (int i = 0; i < n; ++i) {
                this.control.addStation(container.getStation(i), true);
            }
        }
        finally {
            this.settingDefaultStations = false;
        }
        container.addStationContainerListener(this.containerListener);
    }

    @Override
    public Set<String> listSingleBackupFactories() {
        return this.backupFactory.getFactoryIds();
    }

    @Override
    public Set<String> listMultipleDockableFactories() {
        return this.factories.keySet();
    }

    @Override
    public List<MultipleCDockable> listMultipleDockables(MultipleCDockableFactory<?, ?> factory) {
        ArrayList<MultipleCDockable> result = new ArrayList<MultipleCDockable>();
        for (MultipleCDockable dockable : this.multiDockables) {
            if (dockable.getFactory() != factory) continue;
            result.add(dockable);
        }
        return result;
    }

    @Override
    public List<CDockable> listDockablesInMode(ExtendedMode mode) {
        ArrayList<CDockable> list = new ArrayList<CDockable>();
        for (CDockable check : this.dockables) {
            if (!check.isVisible() || check.getExtendedMode() != mode) continue;
            list.add(check);
        }
        return list;
    }

    @Override
    public Set<String> listSingleDockables() {
        HashSet<String> result = new HashSet<String>();
        for (FrontendEntry entry : this.control.intern().listFrontendEntries()) {
            String id = entry.getKey();
            if (!this.isSingleId(id)) continue;
            result.add(this.singleToNormalId(id));
        }
        return result;
    }

    @Override
    public String toSingleId(String id) {
        return "single " + id;
    }

    @Override
    public boolean isSingleId(String id) {
        return id.startsWith("single ");
    }

    @Override
    public String singleToNormalId(String id) {
        return id.substring(7);
    }

    @Override
    public String toMultiId(String id) {
        return "multi " + id;
    }

    @Override
    public boolean isMultiId(String id) {
        return id.startsWith("multi ");
    }

    @Override
    public String multiToNormalId(String id) {
        return id.substring(6);
    }

    @Override
    public void addMultipleDockable(MultipleCDockable dockable) {
        this.dockables.add(dockable);
        this.multiDockables.add(dockable);
    }

    @Override
    public void addSingleDockable(SingleCDockable dockable) {
        this.dockables.add(dockable);
        this.singleDockables.add(dockable);
    }

    @Override
    public SingleCDockable getSingleDockable(String id) {
        for (SingleCDockable dockable : this.singleDockables) {
            if (!dockable.getUniqueId().equals(id)) continue;
            return dockable;
        }
        return null;
    }

    @Override
    public void addStation(CStation<?> station) {
        if (!this.settingDefaultStations) {
            this.checkStationIdentifierUniqueness(station.getUniqueId(), station);
        }
        this.stations.add(station);
    }

    private void checkStationIdentifierUniqueness(String uniqueId, CStation<?> adding) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        if (CContentArea.getCenterIdentifier("ccontrol").equals(uniqueId)) {
            throw new IllegalArgumentException("The id " + uniqueId + " is reserved for special purposes");
        }
        if (CContentArea.getEastIdentifier("ccontrol").equals(uniqueId)) {
            throw new IllegalArgumentException("The id " + uniqueId + " is reserved for special purposes");
        }
        if (CContentArea.getWestIdentifier("ccontrol").equals(uniqueId)) {
            throw new IllegalArgumentException("The id " + uniqueId + " is reserved for special purposes");
        }
        if (CContentArea.getSouthIdentifier("ccontrol").equals(uniqueId)) {
            throw new IllegalArgumentException("The id " + uniqueId + " is reserved for special purposes");
        }
        if (CContentArea.getNorthIdentifier("ccontrol").equals(uniqueId)) {
            throw new IllegalArgumentException("The id " + uniqueId + " is reserved for special purposes");
        }
        for (CStation<?> station : this.stations) {
            if (!station.getUniqueId().equals(uniqueId)) continue;
            if (station == adding) {
                throw new IllegalArgumentException("The station has already been registered");
            }
            throw new IllegalArgumentException("There exists already a station with id: " + uniqueId);
        }
    }

    @Override
    public CommonSingleDockableFactory getBackupFactory() {
        return this.backupFactory;
    }

    @Override
    public CommonMultipleDockableFactory getCommonMultipleDockableFactory(String id) {
        return this.factories.get(id);
    }

    @Override
    public CContentArea getDefaultContentArea() {
        return this.content;
    }

    @Override
    public void putCommonMultipleDockableFactory(String id, CommonMultipleDockableFactory factory) {
        this.factories.put(id, factory);
    }

    @Override
    public CommonMultipleDockableFactory removeCommonMultipleDockableFactory(String id) {
        return this.factories.remove(id);
    }

    @Override
    public boolean removeStationContainer(CStationContainer container) {
        if (this.containers.remove(container)) {
            container.removeStationContainerListener(this.containerListener);
            int n = container.getStationCount();
            for (int i = 0; i < n; ++i) {
                this.control.removeStation(container.getStation(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeMultipleDockable(MultipleCDockable dockable) {
        if (this.dockables.remove(dockable)) {
            this.multiDockables.remove(dockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSingleDockable(SingleCDockable dockable) {
        if (this.dockables.remove(dockable)) {
            this.singleDockables.remove(dockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeStation(CStation<?> station) {
        return this.stations.remove(station);
    }

    @Override
    public void setDefaultContentArea(CContentArea container) {
        this.content = container;
    }

    @Override
    public CDockable getDockable(int index) {
        return this.dockables.get(index);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Map<String, MultipleCDockableFactory<?, ?>> getFactories() {
        HashMap result = new HashMap();
        for (Map.Entry<String, CommonMultipleDockableFactory> entry : this.factories.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getFactory());
        }
        return result;
    }

    @Override
    public MultipleCDockableFactory<?, ?> getFactory(String id) {
        CommonMultipleDockableFactory factory = this.factories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.getFactory();
    }
}

