/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;

public class ListenersHelper<ListenerType, EventType> {
    protected Lock lock = null;
    protected Func2<Object, ListenerType, EventType> callListener = null;
    protected HashSet<ListenerType> listeners = new LinkedHashSet<ListenerType>();
    protected WeakHashMap<ListenerType, Object> weakListeners = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ListenersHelper.class.getName()).log(Level.SEVERE, null, ex);
    }

    public ListenersHelper(Func2<Object, ListenerType, EventType> callListFunc) {
        if (callListFunc == null) {
            throw new IllegalArgumentException("callListFunc==null");
        }
        this.lock = null;
        this.callListener = callListFunc;
    }

    public ListenersHelper(Func2<Object, ListenerType, EventType> callListFunc, Lock sync) {
        if (callListFunc == null) {
            throw new IllegalArgumentException("callListFunc==null");
        }
        this.lock = sync;
        this.callListener = callListFunc;
    }

    public Lock getLock() {
        return this.lock;
    }

    protected Lock createLock() {
        return new ReentrantLock();
    }

    public boolean hasListener(ListenerType listener) {
        if (listener == null) {
            return false;
        }
        if (this.lock != null) {
            this.lock.lock();
            try {
                if (this.listeners.contains(listener)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this.weakListeners.containsKey(listener);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.listeners.contains(listener)) {
            return true;
        }
        return this.weakListeners.containsKey(listener);
    }

    public Set<ListenerType> getListeners() {
        LinkedHashSet<ListenerType> res = new LinkedHashSet<ListenerType>();
        if (this.lock != null) {
            this.lock.lock();
            try {
                res.addAll(this.listeners);
                res.addAll(this.weakListeners.keySet());
            }
            finally {
                this.lock.unlock();
            }
        } else {
            res.addAll(this.listeners);
            res.addAll(this.weakListeners.keySet());
        }
        return res;
    }

    public Closeable addListener(ListenerType listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (this.lock != null) {
            this.lock.lock();
            try {
                Closeable closeable = this.addListener0(listener);
                return closeable;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.addListener0(listener);
    }

    private Closeable addListener0(ListenerType listener) {
        this.listeners.add(listener);
        final ListenerType lstr = listener;
        return new Closeable(){
            private ListenerType l_str;
            {
                this.l_str = lstr;
            }

            @Override
            public void close() throws IOException {
                if (this.l_str != null) {
                    ListenersHelper.this.removeListener(this.l_str);
                    this.l_str = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable addListener(ListenerType listener, boolean weakLink) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        if (this.lock != null) {
            this.lock.lock();
            try {
                if (weakLink) {
                    Closeable closeable = this.addListenerWeak0(listener);
                    return closeable;
                }
                Closeable closeable = this.addListener0(listener);
                return closeable;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (weakLink) {
            return this.addListenerWeak0(listener);
        }
        return this.addListener0(listener);
    }

    private Closeable addListenerWeak0(ListenerType listener) {
        this.weakListeners.put(listener, true);
        final ListenerType lstr = listener;
        return new Closeable(){
            private ListenerType l_str;
            {
                this.l_str = lstr;
            }

            @Override
            public void close() throws IOException {
                if (this.l_str != null) {
                    ListenersHelper.this.removeListener(this.l_str);
                    this.l_str = null;
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeListener(ListenerType listener) {
        if (this.lock != null) {
            this.lock.lock();
            try {
                if (listener == null) return;
                this.listeners.remove(listener);
                this.weakListeners.remove(listener);
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            if (listener == null) return;
            this.listeners.remove(listener);
            this.weakListeners.remove(listener);
        }
    }

    public void fireEvent(EventType event) {
        Object[] lstnrs = null;
        if (this.lock != null) {
            this.lock.lock();
            try {
                lstnrs = this.getListeners().toArray();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            lstnrs = this.getListeners().toArray();
        }
        if (event != null) {
            for (Object lo : lstnrs) {
                if (lo == null) continue;
                Object l = lo;
                this.callListener.apply(l, event);
            }
        }
    }
}

