/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;

public class CloseableSet
implements Closeable {
    protected Object sync = null;
    protected HashSet<Object> links = new LinkedHashSet<Object>();
    protected WeakHashMap<Object, Object> weaklinks = new WeakHashMap();
    private static final Closeable dummy = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CloseableSet.class.getName()).log(Level.SEVERE, null, ex);
    }

    public CloseableSet() {
        this.sync = this;
    }

    public CloseableSet(Closeable ... closeables) {
        this.sync = this;
        if (closeables != null) {
            for (Closeable c : closeables) {
                if (c == null) continue;
                this.add(c);
            }
        }
    }

    public CloseableSet(boolean sync) {
        if (sync) {
            this.sync = this;
        }
    }

    public CloseableSet(boolean sync, Object syncObject) {
        if (syncObject == null) {
            throw new IllegalArgumentException("syncObject==null");
        }
        if (sync) {
            this.sync = syncObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCloseables() {
        if (this.sync != null) {
            Object object = this.sync;
            synchronized (object) {
                ArrayList<Object> cl = new ArrayList<Object>();
                cl.addAll(this.links);
                cl.addAll(this.weaklinks.keySet());
                return cl.toArray();
            }
        }
        ArrayList<Object> cl = new ArrayList<Object>();
        cl.addAll(this.links);
        cl.addAll(this.weaklinks.keySet());
        return cl.toArray();
    }

    public Closeable add(Closeable closeable) {
        return this.add(closeable, false);
    }

    public Closeable add(Runnable closeable) {
        return this.add(closeable, false);
    }

    public Closeable add(Func0 closeable) {
        return this.add(closeable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable add(Closeable closeable, boolean weak) {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                return this.add0(closeable, weak);
            }
        }
        return this.add0(closeable, weak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable add(Runnable closeable, boolean weak) {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                return this.add0(closeable, weak);
            }
        }
        return this.add0(closeable, weak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable add(Func0 closeable, boolean weak) {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                return this.add0(closeable, weak);
            }
        }
        return this.add0(closeable, weak);
    }

    protected Closeable add0(Closeable closeable, boolean weak) {
        if (closeable == null) {
            return dummy;
        }
        if (weak) {
            this.weaklinks.put(closeable, true);
        } else {
            this.links.add(closeable);
        }
        final Closeable cl = closeable;
        return new Closeable(){
            private Closeable c;
            {
                this.c = cl;
            }

            @Override
            public void close() throws IOException {
                if (this.c != null) {
                    CloseableSet.this.remove(this.c);
                    this.c = null;
                }
            }
        };
    }

    protected Closeable add0(Runnable closeable, boolean weak) {
        if (closeable == null) {
            return dummy;
        }
        if (weak) {
            this.weaklinks.put(closeable, true);
        } else {
            this.links.add(closeable);
        }
        final Runnable cl = closeable;
        return new Closeable(){
            private Runnable c;
            {
                this.c = cl;
            }

            @Override
            public void close() throws IOException {
                if (this.c != null) {
                    CloseableSet.this.remove(this.c);
                    this.c = null;
                }
            }
        };
    }

    protected Closeable add0(Func0 closeable, boolean weak) {
        if (closeable == null) {
            return dummy;
        }
        if (weak) {
            this.weaklinks.put(closeable, true);
        } else {
            this.links.add(closeable);
        }
        final Func0 cl = closeable;
        return new Closeable(){
            private Func0 c;
            {
                this.c = cl;
            }

            @Override
            public void close() throws IOException {
                if (this.c != null) {
                    CloseableSet.this.remove(this.c);
                    this.c = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object closeable) {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                this.remove0(closeable);
            }
        } else {
            this.remove0(closeable);
        }
    }

    protected void remove0(Object closeable) {
        if (closeable != null) {
            this.links.remove(closeable);
            this.weaklinks.remove(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                this.removeAll0();
            }
        } else {
            this.removeAll0();
        }
    }

    public void removeAll0() {
        this.links.clear();
        this.weaklinks.clear();
    }

    public void closeAll() {
        this.closeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(boolean removeAll) {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                this.closeAll0(removeAll);
            }
        } else {
            this.closeAll0(removeAll);
        }
    }

    protected void closeAll0(boolean removeAll) {
        for (Object c : this.getCloseables()) {
            if (c instanceof Closeable) {
                try {
                    ((Closeable)c).close();
                    if (!removeAll) continue;
                    this.remove(c);
                }
                catch (IOException ex) {
                    Logger.getLogger(CloseableSet.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (c instanceof Runnable) {
                ((Runnable)c).run();
                continue;
            }
            if (!(c instanceof Func0)) continue;
            ((Func0)c).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object s = this.sync;
        if (s != null) {
            Object object = s;
            synchronized (object) {
                this.closeAll();
            }
        } else {
            this.closeAll();
        }
    }
}

