/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodePopupEvent;

public class TreeNodePopupEventDef<Node extends TreeNode> {
    private static final Logger logger = Logger.getLogger(TreeNodePopupEventDef.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    static final WeakHashMap<TreeNodePopupEvent, List> defaultPaths;
    final TreeNodePopupEvent<Node> self;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodePopupEventDef.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodePopupEventDef.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodePopupEventDef.class.getName(), method, result);
    }

    public TreeNodePopupEventDef(TreeNodePopupEvent<Node> self) {
        if (self == null) {
            throw new IllegalArgumentException("self==null");
        }
        this.self = self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeNode<Node>> getPopupPath() {
        WeakHashMap<TreeNodePopupEvent, List> weakHashMap = defaultPaths;
        synchronized (weakHashMap) {
            LinkedList<TreeNode<Node>> l = defaultPaths.get(this.self);
            if (l == null) {
                l = new LinkedList<TreeNode<Node>>();
                defaultPaths.put(this.self, l);
            }
            return l;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        defaultPaths = new WeakHashMap();
    }
}

