/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeDeepCounterDef;
import xyz.cofe.collection.tree.TreeNodeDeepOffset;

public class TreeNodeDeepOffsetDef<Node extends TreeNodeDeepOffset> {
    private static final Logger logger = Logger.getLogger(TreeNodeDeepOffsetDef.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TreeNodeDeepOffsetDef.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeDeepOffsetDef.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeDeepOffsetDef.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeDeepOffsetDef.class.getName(), method);
    }

    public int getRootOffsetOf(Node node) {
        return this.getRootOffsetOf(node, null);
    }

    private int getRootOffsetOf(Node node, Set visited) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet<Node>();
        }
        if (visited.contains(node)) {
            throw new Error("cycle detect");
        }
        visited.add(node);
        TreeNodeDeepOffset parent = (TreeNodeDeepOffset)node.getParent();
        if (parent == null) {
            return 0;
        }
        TreeNodeDeepOffset sib = (TreeNodeDeepOffset)node.getPreviousSibling();
        if (sib == null) {
            int off = this.getRootOffsetOf(parent, visited);
            return ++off;
        }
        int off = this.getRootOffsetOf(sib, visited);
        int sibncnt = sib.getNodesCount();
        return off += sibncnt;
    }

    public Node deepOffset(Node node, int offset) {
        return this.deepOffset(node, offset, null);
    }

    private Node deepOffset(Node node, int offset, Set visited) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet<Node>();
        }
        if (visited.contains(node)) {
            throw new Error("cycle detect");
        }
        visited.add(node);
        if (offset == 0) {
            return node;
        }
        if (offset > 0) {
            return this.offsetRight(node, offset, visited);
        }
        return this.offsetLeft(node, offset, visited);
    }

    private Node moveNext(Node node, Set visited) {
        TreeNode[] children;
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet();
        }
        if ((children = node.getChildren()) != null && children.length > 0) {
            TreeNodeDeepOffset n = (TreeNodeDeepOffset)children[0];
            return (Node)n;
        }
        Object sib = node.getNextSibling();
        if (sib != null) {
            return (Node)((TreeNodeDeepOffset)sib);
        }
        for (Object p = node.getParent(); p != null; p = p.getParent()) {
            sib = p.getNextSibling();
            if (sib == null) continue;
            return (Node)((TreeNodeDeepOffset)sib);
        }
        return null;
    }

    private Node movePrevious(Node node, Set visited) {
        TreeNodeDeepOffset sib;
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet();
        }
        if ((sib = (TreeNodeDeepOffset)node.getPreviousSibling()) != null) {
            int ncount = sib.getNodesCount();
            if (ncount < 1) {
                return null;
            }
            if (ncount == 1) {
                return (Node)sib;
            }
            return (Node)this.offsetRight(sib, ncount - 1, visited);
        }
        return (Node)((TreeNodeDeepOffset)node.getParent());
    }

    private Node offsetLeft(Node node, int offset, Set visited) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet<Node>();
        }
        visited.add(node);
        if (offset == 0) {
            return node;
        }
        if (offset > 0) {
            return this.offsetRight(node, offset, visited);
        }
        TreeNodeDeepOffset sib = (TreeNodeDeepOffset)node.getPreviousSibling();
        if (sib == null) {
            Node prev = this.movePrevious(node, visited);
            if (prev == null) {
                return null;
            }
            return this.offsetLeft(prev, offset + 1, visited);
        }
        int sibncount = sib.getNodesCount();
        int toff = offset + sibncount;
        if (toff == 0) {
            return (Node)sib;
        }
        if (toff > 0) {
            return (Node)this.offsetRight(sib, toff, visited);
        }
        return (Node)this.offsetLeft(sib, toff, visited);
    }

    private Node offsetRight(Node node, int offset, Set visited) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (visited == null) {
            visited = new LinkedHashSet();
        }
        if (offset == 0) {
            return node;
        }
        if (offset < 0) {
            return null;
        }
        int cnt = node.getNodesCount();
        TreeNode[] children = node.getChildren();
        if (children.length <= 0 && cnt > 1) {
            TreeNodeDeepOffsetDef.logWarning("bag!!! cnt=" + cnt + " children.length=" + children.length, new Object[0]);
            TreeNodeDeepCounterDef.setDeepCounterOf(node, null);
            cnt = node.getNodesCount();
        }
        if (cnt < 1) {
            return null;
        }
        int minoff = 0;
        int maxoff = cnt - 1;
        if (offset < minoff) {
            return null;
        }
        if (offset > maxoff) {
            if (offset < cnt) {
                throw new Error("bag!!");
            }
            Node nextNode = this.moveNext(node, visited);
            if (nextNode == null) {
                return null;
            }
            return this.deepOffset(nextNode, offset - 1, visited);
        }
        if (children == null) {
            throw new Error("bag!!!");
        }
        if (children.length < 0) {
            throw new Error("bag!!!!");
        }
        if (children.length < 1) {
            TreeNodeDeepOffsetDef.logWarning("!! offsetRight, children.length={0}", children.length);
        }
        int offsum = 0;
        TreeNode child = null;
        for (int ci = 0; ci < children.length; ++ci) {
            child = children[ci];
            if (child == null) continue;
            if (!(child instanceof TreeNodeDeepOffset)) {
                throw new Error("bag!!!!!");
            }
            TreeNodeDeepOffset tndo = (TreeNodeDeepOffset)child;
            int ncount = tndo.getNodesCount();
            if (ncount <= 0) {
                throw new Error("bag!!!!!");
            }
            minoff = offsum + 1;
            int mmxoff = minoff + ncount;
            if (offset < minoff || offset >= mmxoff) {
                offsum += ncount;
                continue;
            }
            return (Node)this.deepOffset(tndo, offset - offsum - 1, visited);
        }
        return null;
    }
}

