/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeDeepCounter;

public class TreeNodeDeepCounterDef {
    private static final Logger logger = Logger.getLogger(TreeNodeDeepCounterDef.class.getName());
    public static final WeakHashMap<TreeNode, Integer> deepCounter = new WeakHashMap();

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = TreeNodeDeepCounterDef.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeDeepCounterDef.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeDeepCounterDef.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeDeepCounterDef.class.getName(), method);
    }

    public static void onTreeNodeRemoved(TreeNode tn, Integer index, Object child) {
        TreeNodeDeepCounterDef.setDeepCounterOf(tn, null);
    }

    public static void onTreeNodeAdded(TreeNode tn, Integer index, Object child) {
        TreeNodeDeepCounterDef.setDeepCounterOf(tn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getDeepCounterOf(TreeNode tn) {
        if (tn == null) {
            return null;
        }
        WeakHashMap<TreeNode, Integer> weakHashMap = deepCounter;
        synchronized (weakHashMap) {
            return deepCounter.get(tn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDeepCounterOf(TreeNode tn, Integer v) {
        if (tn == null) {
            return;
        }
        WeakHashMap<TreeNode, Integer> weakHashMap = deepCounter;
        synchronized (weakHashMap) {
            if (v == null) {
                TreeNodeDeepCounterDef.logFiner("reset deep counter for {0}", tn);
                deepCounter.remove(tn);
            } else {
                TreeNodeDeepCounterDef.logFiner("set deep counter for {0} = {1}", tn, v);
                deepCounter.put(tn, v);
            }
            LinkedHashSet<TreeNode> visited = new LinkedHashSet<TreeNode>();
            visited.add(tn);
            Object ptn = tn.getParent();
            if (ptn != null) {
                TreeNodeDeepCounterDef.resetDeepCounterOf(ptn, visited);
            }
        }
    }

    protected static void resetDeepCounterOf(TreeNode tn, Set<TreeNode> visited) {
        if (tn == null) {
            return;
        }
        if (visited.contains(tn)) {
            return;
        }
        deepCounter.remove(tn);
        visited.add(tn);
        TreeNodeDeepCounterDef.resetDeepCounterOf(tn.getParent(), visited);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNodesCountOf(TreeNode tn) {
        if (tn == null) {
            return -1;
        }
        TreeNode treeNode = tn;
        synchronized (treeNode) {
            TreeNode[] children;
            Integer c = TreeNodeDeepCounterDef.getDeepCounterOf(tn);
            if (c != null) {
                return c;
            }
            int sum = 0;
            for (TreeNode ctn : children = tn.getChildren()) {
                if (ctn == null) continue;
                if (ctn instanceof TreeNodeDeepCounter) {
                    TreeNodeDeepCounter tndc = (TreeNodeDeepCounter)ctn;
                    int count = tndc.getNodesCount();
                    if (count < 0) {
                        TreeNodeDeepCounterDef.logFiner("can't eval deep counter of {0} - return {1}", tndc, count);
                        return -3;
                    }
                    sum += count;
                    continue;
                }
                TreeNodeDeepCounterDef.logFiner("can't eval deep counter of {0} not instanceof TreeNodeDeepCounter", ctn);
                return -2;
            }
            TreeNodeDeepCounterDef.setDeepCounterOf(tn, ++sum);
            TreeNodeDeepCounterDef.logFiner("cache deep counter of {0} - sum={1}", tn, sum);
            return sum;
        }
    }
}

