/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.tree.PopupTreeNode;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAdded;
import xyz.cofe.collection.tree.TreeNodeAdding;
import xyz.cofe.collection.tree.TreeNodeDeepCounter;
import xyz.cofe.collection.tree.TreeNodeDeepOffset;
import xyz.cofe.collection.tree.TreeNodeDeepOffsetDef;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeNotifier;
import xyz.cofe.collection.tree.TreeNodePopupEvent;
import xyz.cofe.collection.tree.TreeNodeRemoved;
import xyz.cofe.collection.tree.TreeNodeRemoving;
import xyz.cofe.collection.tree.TreeNodeSetParent;
import xyz.cofe.collection.tree.TreeNodeUpdateParent;

public abstract class IndexTreeNode<Node extends TreeNode>
extends PopupTreeNode<Node>
implements TreeNodeDeepCounter<Node>,
TreeNodeDeepOffset<Node> {
    private static final Logger logger = Logger.getLogger(IndexTreeNode.class.getName());
    protected Integer nodesCount = null;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = IndexTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(IndexTreeNode.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(IndexTreeNode.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(IndexTreeNode.class.getName(), method);
    }

    @Override
    public int getNodesCount() {
        return (Integer)this.syncrun(new Func0(){

            public Object apply() {
                TreeNode[] children;
                Integer ncnt = IndexTreeNode.this.nodesCount;
                if (ncnt != null) {
                    return ncnt;
                }
                int sum = 0;
                for (TreeNode ctn : children = IndexTreeNode.this.getChildren()) {
                    if (ctn == null) continue;
                    if (ctn instanceof TreeNodeDeepCounter) {
                        TreeNodeDeepCounter tndc = (TreeNodeDeepCounter)ctn;
                        int count = tndc.getNodesCount();
                        if (count < 0) {
                            IndexTreeNode.logFiner("can't eval deep counter of {0} - return {1}", new Object[]{tndc, count});
                            return -3;
                        }
                        sum += count;
                        continue;
                    }
                    IndexTreeNode.logFiner("can't eval deep counter of {0} not instanceof TreeNodeDeepCounter", new Object[]{ctn});
                    return -2;
                }
                IndexTreeNode.logFiner("cache deep counter of {0} - sum={1}", new Object[]{this, ++sum});
                IndexTreeNode.this.setNodesCount(sum);
                return sum;
            }
        }, "getNodesCount", new Object[0]);
    }

    @Override
    public Node deepOffset(int offset) {
        return (Node)new TreeNodeDeepOffsetDef<IndexTreeNode>().deepOffset(this, offset);
    }

    @Override
    public int getRootOffset() {
        return new TreeNodeDeepOffsetDef<IndexTreeNode>().getRootOffsetOf(this);
    }

    protected void resetNodesCount() {
        this.syncrun(new Func0(){

            public Object apply() {
                IndexTreeNode.this.nodesCount = null;
                return null;
            }
        }, "resetNodesCount", new Object[0]);
    }

    protected void setNodesCount(final int cnt) {
        this.syncrun(new Func0(){

            public Object apply() {
                IndexTreeNode.this.nodesCount = cnt;
                return null;
            }
        }, "resetNodesCount", new Object[0]);
    }

    @Override
    public void popup(final TreeNodeEvent<Node> ev) {
        this.syncrun(new Func0(){

            public Object apply() {
                if (ev instanceof TreeNodeAdded || ev instanceof TreeNodeRemoving || ev instanceof TreeNodeRemoved || ev instanceof TreeNodeAdding) {
                    IndexTreeNode.this.resetNodesCount();
                }
                if (ev instanceof TreeNodePopupEvent) {
                    TreeNodePopupEvent tnpe = (TreeNodePopupEvent)ev;
                    List l = tnpe.getPopupPath();
                    if (l != null) {
                        int cycles = 0;
                        for (TreeNode o : l) {
                            if (this != o) continue;
                            ++cycles;
                        }
                        if (cycles > 1) {
                            throw new Error("cycle detected");
                        }
                    }
                    l.add(this);
                    IndexTreeNode.this.fireTreeNodeEvent(ev);
                    Object pnode = IndexTreeNode.this.getParent();
                    if (pnode instanceof TreeNodeNotifier) {
                        ((TreeNodeNotifier)pnode).popup(ev);
                    }
                }
                return null;
            }
        }, "popup", ev);
    }

    @Override
    public void onTreeNodeAdded(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                IndexTreeNode.this.resetNodesCount();
                if (this.val$child instanceof TreeNodeSetParent) {
                    TreeNodeSetParent tn = (TreeNodeSetParent)((Object)this.val$child);
                    tn.setParent(IndexTreeNode.this);
                }
                TreeNodeAdded ev = new TreeNodeAdded(IndexTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                IndexTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeAdded", index, child);
    }

    @Override
    public void onTreeNodeAdding(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                IndexTreeNode.this.resetNodesCount();
                TreeNodeAdding ev = new TreeNodeAdding(IndexTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                IndexTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeAdding", index, child);
    }

    @Override
    public void onTreeNodeRemoved(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                IndexTreeNode.this.resetNodesCount();
                if (this.val$child instanceof TreeNodeUpdateParent) {
                    ((TreeNodeUpdateParent)((Object)this.val$child)).updateParent(IndexTreeNode.this, null);
                }
                TreeNodeRemoved ev = new TreeNodeRemoved(IndexTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                IndexTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeRemoved", index, child);
    }

    @Override
    public void onTreeNodeRemoving(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                IndexTreeNode.this.resetNodesCount();
                TreeNodeRemoving ev = new TreeNodeRemoving(IndexTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                IndexTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeRemoving", index, child);
    }
}

