/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.iterators.EmptyIterable;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.EventMapListener;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.collection.map.SimpleMapAdapter;
import xyz.cofe.collection.set.ClassSet;

public class ClassNode
implements NodesExtracter {
    private static final Logger logger = Logger.getLogger(ClassNode.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected final Map<Class, Set<NodesExtracter>> typedExtracter;
    protected final ClassSet types;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public ClassNode() {
        this.lock = new ReentrantLock();
        Map<Object, Object> typedExtracter = new LinkedHashMap();
        this.types = new ClassSet(true);
        LockEventMap<Class, Set<NodesExtracter>> ev_typedExtracter = new LockEventMap<Class, Set<NodesExtracter>>(typedExtracter, this.lock);
        typedExtracter = ev_typedExtracter;
        this.typedExtracter = typedExtracter;
        this.syncTypes(this.types, ev_typedExtracter);
    }

    public ClassNode(Lock lock) {
        this(null, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassNode(ClassNode src, Lock lock) {
        this.lock = lock == null ? new ReentrantLock() : lock;
        Map<Object, Object> typedExtracter = new LinkedHashMap();
        this.types = new ClassSet(true);
        LockEventMap<Class, Set<NodesExtracter>> ev_typedExtracter = new LockEventMap<Class, Set<NodesExtracter>>(typedExtracter, lock);
        typedExtracter = ev_typedExtracter;
        this.typedExtracter = typedExtracter;
        this.syncTypes(this.types, ev_typedExtracter);
        if (src != null) {
            try {
                src.lock.lock();
                this.typedExtracter.putAll(src.typedExtracter);
            }
            finally {
                src.lock.unlock();
            }
        }
    }

    public ClassNode clone() {
        return new ClassNode(this, null);
    }

    public ClassNode clone(Lock lock) {
        return new ClassNode(this, lock);
    }

    private Closeable syncTypes(final ClassSet types, EventMap<Class, Set<NodesExtracter>> map) {
        SimpleMapAdapter<Class, Set<NodesExtracter>> mapListener = new SimpleMapAdapter<Class, Set<NodesExtracter>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void removed(Set<NodesExtracter> value, EventMap<Class, Set<NodesExtracter>> map, Class key) {
                try {
                    ClassNode.this.lock.lock();
                    if (types != null && key != null) {
                        types.remove(key);
                    }
                }
                finally {
                    ClassNode.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void added(Set<NodesExtracter> value, EventMap<Class, Set<NodesExtracter>> map, Class key) {
                try {
                    ClassNode.this.lock.lock();
                    if (types != null && key != null) {
                        types.add(key);
                    }
                }
                finally {
                    ClassNode.this.lock.unlock();
                }
            }
        };
        return map.addEventMapListener((EventMapListener<Class, Set<NodesExtracter>>)mapListener);
    }

    public <T> ClassNode adds(Class<T> cls, NodesExtracter<T, ?> ne) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (ne == null) {
            throw new IllegalArgumentException("ne==null");
        }
        this.add(cls, ne);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class cls, NodesExtracter ne) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (ne == null) {
            throw new IllegalArgumentException("ne==null");
        }
        try {
            this.lock.lock();
            Set<NodesExtracter> setne = this.typedExtracter.get(cls);
            if (setne == null) {
                setne = new LinkedHashSet<NodesExtracter>();
                this.typedExtracter.put(cls, setne);
            }
            setne.add(ne);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class cls, NodesExtracter ne) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        if (ne == null) {
            throw new IllegalArgumentException("ne==null");
        }
        try {
            this.lock.lock();
            Set<NodesExtracter> setne = this.typedExtracter.get(cls);
            if (setne == null) {
                return;
            }
            setne.remove(ne);
            if (setne.isEmpty()) {
                this.typedExtracter.remove(cls);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        try {
            this.lock.lock();
            Set<NodesExtracter> setne = this.typedExtracter.get(cls);
            if (setne == null) {
                return;
            }
            setne.clear();
            if (setne.isEmpty()) {
                this.typedExtracter.remove(cls);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        try {
            this.lock.lock();
            this.typedExtracter.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        try {
            this.lock.lock();
            boolean bl = this.typedExtracter.containsKey(cls);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class[] getClasses() {
        try {
            this.lock.lock();
            Class[] classArray = this.types.toArray(new Class[0]);
            return classArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesExtracter[] getNodeExtracters(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        try {
            this.lock.lock();
            Set<NodesExtracter> childrenExtr = this.typedExtracter.get(cls);
            if (childrenExtr == null) {
                NodesExtracter[] nodesExtracterArray = null;
                return nodesExtracterArray;
            }
            NodesExtracter[] nodesExtracterArray = childrenExtr.toArray(new NodesExtracter[0]);
            return nodesExtracterArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesExtracter[] extractersOf(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls==null");
        }
        try {
            Iterator<Class<Object>> iterator;
            this.lock.lock();
            Set<NodesExtracter> childrenExtr = this.typedExtracter.get(cls);
            if (childrenExtr != null) {
                NodesExtracter[] nodesExtracterArray = childrenExtr.toArray(new NodesExtracter[0]);
                return nodesExtracterArray;
            }
            Collection<Class> matchParents = this.types.getAssignableFrom(cls, true, false);
            LinkedHashSet<Class> matchedCls = new LinkedHashSet<Class>();
            if (matchParents != null) {
                for (Class clazz : matchParents) {
                    if (clazz == null) continue;
                    matchedCls.add(clazz);
                    if (clazz.isInterface()) continue;
                }
            }
            childrenExtr = new LinkedHashSet<NodesExtracter>();
            for (Class<Object> clazz : matchedCls) {
                Set<NodesExtracter> snet = this.typedExtracter.get(clazz);
                childrenExtr.addAll(snet);
            }
            if (childrenExtr != null && childrenExtr.size() > 0) {
                iterator = childrenExtr.toArray(new NodesExtracter[0]);
                return iterator;
            }
            iterator = new NodesExtracter[]{};
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable fetch(Object node) {
        if (node == null) {
            return Iterators.empty();
        }
        try {
            this.lock.lock();
            Class<?> cls = node.getClass();
            NodesExtracter[] extrs = this.extractersOf(cls);
            Iterable iterable = this.fetch(node, extrs);
            return iterable;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Iterable fetch(Object node, NodesExtracter ... set) {
        Iterable<Object> itr = null;
        for (NodesExtracter ne : set) {
            Iterable i;
            if (ne == null || (i = ne.extract(node)) == null || i instanceof EmptyIterable) continue;
            itr = itr == null ? i : Iterators.sequence(itr, i);
        }
        return itr == null ? Iterators.empty() : itr;
    }

    public Iterable extract(Object from) {
        return this.fetch(from);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

