/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.TreeNode;

public class BasicTreeNodeEvent<Node extends TreeNode> {
    private static final Logger logger = Logger.getLogger(BasicTreeNodeEvent.class.getName());
    protected TreeNode source;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = BasicTreeNodeEvent.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(BasicTreeNodeEvent.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(BasicTreeNodeEvent.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(BasicTreeNodeEvent.class.getName(), method);
    }

    public BasicTreeNodeEvent(TreeNode<Node> source) {
        this.source = source;
    }

    public TreeNode<Node> getSource() {
        return this.source;
    }
}

