/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import xyz.cofe.collection.BasicVisitor;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Visitor;
import xyz.cofe.collection.iterators.TreeIterable;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkItreator;
import xyz.cofe.collection.iterators.TreeWalkType;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeGetNodePath;
import xyz.cofe.collection.tree.TreeNodeSetParent;
import xyz.cofe.collection.tree.TreeNodeUpdateParent;
import xyz.cofe.common.Reciver;

public abstract class AbstractTreeNode<Node extends TreeNode>
implements TreeNode<Node>,
TreeNodeSetParent<Node>,
TreeNodeUpdateParent<Node>,
TreeNodeGetNodePath<Node> {
    protected Node parent = null;
    protected static NodesExtracter defaultNodesExtracter = new NodesExtracter(){

        public Iterable extract(Object from) {
            if (from instanceof TreeNode) {
                return Arrays.asList(((TreeNode)from).getChildren());
            }
            return null;
        }
    };

    protected Object syncrun(Func0 run, String method, Object ... args) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        return run.apply();
    }

    public static List getNodePath(TreeNode node) {
        LinkedList<TreeNode> path = new LinkedList<TreeNode>();
        TreeNode n = node;
        while (true) {
            if (path.contains(n)) {
                throw new Error("cycle detected");
            }
            path.add(0, n);
            Object p = n.getParent();
            if (p == null) break;
            n = p;
        }
        return path;
    }

    @Override
    public List<Node> getNodePath() {
        return (List)this.syncrun(new Func0(){

            public Object apply() {
                return AbstractTreeNode.getNodePath(AbstractTreeNode.this);
            }
        }, "getNodePath", new Object[0]);
    }

    @Override
    public Node getParent() {
        return (Node)((TreeNode)this.syncrun(new Func0(){

            public Object apply() {
                return AbstractTreeNode.this.parent;
            }
        }, "getParent", new Object[0]));
    }

    @Override
    public void setParent(Node tn) {
        this.syncrun(new Func0((TreeNode)tn){
            final /* synthetic */ TreeNode val$tn;
            {
                this.val$tn = treeNode;
            }

            public Object apply() {
                AbstractTreeNode.this.parent = this.val$tn;
                return null;
            }
        }, "setParent", tn);
    }

    @Override
    public boolean updateParent(Node oldparent, Node newparent) {
        return (Boolean)this.syncrun(new Func0((TreeNode)oldparent, (TreeNode)newparent){
            final /* synthetic */ TreeNode val$oldparent;
            final /* synthetic */ TreeNode val$newparent;
            {
                this.val$oldparent = treeNode;
                this.val$newparent = treeNode2;
            }

            public Object apply() {
                if (AbstractTreeNode.this.parent == this.val$oldparent) {
                    AbstractTreeNode.this.parent = this.val$newparent;
                    return true;
                }
                return false;
            }
        }, "updateParent", oldparent, newparent);
    }

    public static int getIndex(TreeNode thisNode) {
        if (thisNode == null) {
            throw new IllegalArgumentException("thisNode==null");
        }
        Object parent = thisNode.getParent();
        if (parent == null) {
            return -1;
        }
        if (!(parent instanceof TreeNode)) {
            return -1;
        }
        TreeNode parentTN = (TreeNode)parent;
        TreeNode[] siblings = parentTN.getChildren();
        if (siblings == null) {
            return -1;
        }
        int idx = -1;
        for (idx = 0; idx < siblings.length; ++idx) {
            TreeNode sibling = siblings[idx];
            if (sibling == null || sibling != thisNode) continue;
            return idx;
        }
        return -1;
    }

    @Override
    public int getIndex() {
        return (Integer)this.syncrun(new Func0(){

            public Object apply() {
                return AbstractTreeNode.getIndex(AbstractTreeNode.this);
            }
        }, "getIndex", new Object[0]);
    }

    @Override
    public Node getSibling(int offset) {
        final AbstractTreeNode self = this;
        final int foffset = offset;
        return (Node)((TreeNode)this.syncrun(new Func0(){

            public Object apply() {
                Object o = AbstractTreeNode.getSibling(self, foffset);
                return (TreeNode)o;
            }
        }, "getSibling", offset));
    }

    @Override
    public Node getNextSibling() {
        return this.getSibling(1);
    }

    @Override
    public Node getPreviousSibling() {
        return this.getSibling(-1);
    }

    public static Object getSibling(TreeNode thisNode, int offset) {
        if (thisNode == null) {
            throw new IllegalArgumentException("thisNode==null");
        }
        if (offset == 0) {
            return thisNode;
        }
        Object parent = thisNode.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof TreeNode)) {
            return null;
        }
        TreeNode parentTN = (TreeNode)parent;
        TreeNode[] siblings = parentTN.getChildren();
        if (siblings == null) {
            return null;
        }
        int selfIdx = -1;
        int idx = -1;
        for (idx = 0; idx < siblings.length; ++idx) {
            TreeNode sibling = siblings[idx];
            if (sibling == null || sibling != thisNode) continue;
            selfIdx = idx;
        }
        if (selfIdx < 0) {
            return null;
        }
        int targetIdx = selfIdx + offset;
        if (targetIdx < 0) {
            return null;
        }
        if (targetIdx >= siblings.length) {
            return null;
        }
        return siblings[targetIdx];
    }

    public Iterable<TreeWalk<Node>> tree(final TreeWalkType walkType) {
        return (Iterable)this.syncrun(new Func0(){

            public Object apply() {
                return AbstractTreeNode.tree(AbstractTreeNode.this, walkType);
            }
        }, "tree", new Object[]{walkType});
    }

    @Override
    public Iterable<TreeWalk<Node>> tree() {
        return AbstractTreeNode.tree(this, null);
    }

    public static <Node extends TreeNode> Iterable<TreeWalk<Node>> tree(TreeNode<Node> start, TreeWalkType walkType) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (walkType == null) {
            walkType = TreeWalkType.ByBranchForward;
        }
        final TreeWalkType ftwt = walkType;
        final NodesExtracter next = defaultNodesExtracter;
        final TreeNode<Node> root = start;
        Iterable itr = new Iterable(){

            public Iterator iterator() {
                return new TreeWalkItreator<Object>(root, next, 0, 1, ftwt, null, null);
            }
        };
        return itr;
    }

    public static <Node extends TreeNode> Iterable<TreeWalk<Node>> tree(TreeNode<Node> start, TreeWalkType walkType, final Func1<Boolean, TreeNode<Node>> follow) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (walkType == null) {
            walkType = TreeWalkType.ByBranchForward;
        }
        final TreeWalkType ftwt = walkType;
        final NodesExtracter next = new NodesExtracter(){

            public Iterable extract(Object from) {
                if (from instanceof TreeNode) {
                    TreeNode tn = (TreeNode)from;
                    if (follow != null && !((Boolean)follow.apply(tn)).booleanValue()) {
                        return null;
                    }
                    return Arrays.asList(tn.getChildren());
                }
                return null;
            }
        };
        final TreeNode<Node> root = start;
        Iterable itr = new Iterable(){

            public Iterator iterator() {
                return new TreeWalkItreator<Object>(root, next, 0, 1, ftwt, null, null);
            }
        };
        return itr;
    }

    public static <Node extends TreeNode> Iterable<Node> walk(TreeNode<Node> start, final Func1<Boolean, TreeNode<Node>> follow) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        NodesExtracter next = new NodesExtracter(){

            public Iterable extract(Object from) {
                if (from instanceof TreeNode) {
                    TreeNode tn = (TreeNode)from;
                    if (follow != null && !((Boolean)follow.apply(tn)).booleanValue()) {
                        return null;
                    }
                    return Arrays.asList(tn.getChildren());
                }
                return null;
            }
        };
        TreeIterable<TreeNode<Node>> titr = new TreeIterable<TreeNode<Node>>(start, next);
        return titr;
    }

    public static <Node extends TreeNode> Iterable<Node> walk(TreeNode<Node> start) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        NodesExtracter next = defaultNodesExtracter;
        TreeIterable<TreeNode<Node>> titr = new TreeIterable<TreeNode<Node>>(start, next);
        return titr;
    }

    @Override
    public Iterable<Node> walk() {
        return (Iterable)this.syncrun(new Func0(){

            public Object apply() {
                return AbstractTreeNode.walk(AbstractTreeNode.this);
            }
        }, "walk", new Object[0]);
    }

    public static <Node extends TreeNode> void visit(Visitor<Node> visitor, TreeNode<Node> startNode) {
        NodesExtracter next = defaultNodesExtracter;
        BasicVisitor.visit(visitor, startNode, next);
    }

    @Override
    public void visit(final Reciver<Stack<Node>> visiter) {
        if (visiter == null) {
            throw new IllegalArgumentException("visiter==null");
        }
        this.syncrun(new Func0(){

            public Object apply() {
                AbstractTreeNode.this.visit(new Func1<Boolean, Stack<Node>>(){

                    @Override
                    public Boolean apply(Stack<Node> stack) {
                        visiter.recive(stack);
                        return true;
                    }
                });
                return null;
            }
        }, "visit", visiter, visiter);
    }

    @Override
    public void visit(final Reciver<Stack<Node>> visiterEnter, final Reciver<Stack<Node>> visiterExit) {
        if (visiterEnter == null) {
            throw new IllegalArgumentException("visiterEnter==null");
        }
        if (visiterExit == null) {
            throw new IllegalArgumentException("visiterExit==null");
        }
        this.syncrun(new Func0(){

            public Object apply() {
                AbstractTreeNode.this.visit(new Func1<Boolean, Stack<Node>>(){

                    @Override
                    public Boolean apply(Stack<Node> stack) {
                        visiterEnter.recive(stack);
                        return true;
                    }
                }, new Func1<Object, Stack<Node>>(){

                    @Override
                    public Object apply(Stack<Node> stack) {
                        visiterExit.recive(stack);
                        return null;
                    }
                });
                return null;
            }
        }, "visit", visiterEnter, visiterExit);
    }

    @Override
    public void visit(final Func1<Boolean, Stack<Node>> visiter, final Func1<Object, Stack<Node>> exitVisiter) {
        final AbstractTreeNode self = this;
        this.syncrun(new Func0(){

            public Object apply() {
                AbstractTreeNode.visit(visiter, exitVisiter, self);
                return null;
            }
        }, "visit", visiter, exitVisiter);
    }

    public void visit(final Func1<Boolean, Stack<Node>> visiter) {
        final AbstractTreeNode self = this;
        this.syncrun(new Func0(){

            public Object apply() {
                AbstractTreeNode.visit(visiter, null, self);
                return null;
            }
        }, "visit", visiter);
    }

    public static <Node extends TreeNode> void visit(final Func1<Boolean, Stack<Node>> visiter, final Func1<Object, Stack<Node>> exitVisiter, TreeNode<Node> startNode) {
        AbstractTreeNode.visit(new BasicVisitor<Node>(){
            Stack<Node> path = new Stack();

            @Override
            public void exit(Node obj) {
                if (exitVisiter != null) {
                    exitVisiter.apply(this.path);
                }
                this.path.pop();
                super.exit(obj);
            }

            @Override
            public boolean enter(Node obj) {
                this.path.push(obj);
                if (visiter == null) {
                    return true;
                }
                return (Boolean)visiter.apply(this.path);
            }
        }, startNode);
    }

    public static <Node extends TreeNode> void visit(final Func1<Boolean, Stack<Node>> visiter, TreeNode<Node> startNode) {
        AbstractTreeNode.visit(new BasicVisitor<Node>(){
            Stack<Node> path = new Stack();

            @Override
            public void exit(Node obj) {
                this.path.pop();
                super.exit(obj);
            }

            @Override
            public boolean enter(Node obj) {
                if (visiter == null) {
                    return true;
                }
                this.path.push(obj);
                return (Boolean)visiter.apply(this.path);
            }
        }, startNode);
    }
}

