/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Pair;
import xyz.cofe.collection.Predicate;

public class Table<Row, Column, Value> {
    protected Value defItem = null;
    protected Map<Row, Map<Column, Value>> items = new TreeMap<Row, Map<Column, Value>>();
    protected Collection<Row> rows = new TreeSet<Row>();
    protected Collection<Column> columns = new TreeSet<Column>();
    protected Collection<Listener<Row, Column, Value>> listeners = new HashSet<Listener<Row, Column, Value>>();
    protected Comparator<Row> rowComparator = null;

    public Table(Value defaultItem) {
        this.defItem = defaultItem;
    }

    public void addListener(Listener<Row, Column, Value> listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener<Row, Column, Value> listener) {
        this.listeners.remove(listener);
    }

    public Collection<Listener<Row, Column, Value>> getListeners() {
        return this.listeners;
    }

    protected void fireEvent(Event<Row, Column, Value> event) {
        for (Listener<Row, Column, Value> l : this.getListeners()) {
            l.tableEvent(event);
        }
    }

    protected void fireValueChanged(Row row, Column column, Value value) {
        ValueChagnedEvent<Row, Column, Value> e = new ValueChagnedEvent<Row, Column, Value>(this, row, column, value);
        this.fireEvent(e);
    }

    protected void fireRowAdded(Row row) {
        RowAddedEvent e = new RowAddedEvent(this, row);
        this.fireEvent(e);
    }

    protected void fireRowDeleted(Row row) {
        RowDeletedEvent e = new RowDeletedEvent(this, row);
        this.fireEvent(e);
    }

    protected void fireColumnAdded(Column column) {
        ColumnAddedEvent e = new ColumnAddedEvent(this, column);
        this.fireEvent(e);
    }

    protected void fireColumnDeleted(Column column) {
        ColumnDeletedEvent e = new ColumnDeletedEvent(this, column);
        this.fireEvent(e);
    }

    protected void fireCleared() {
        ClearedEvent e = new ClearedEvent(this);
        this.fireEvent(e);
    }

    public void copyFrom(Table<? extends Row, ? extends Column, ? extends Value> src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        this.items = new TreeMap<Row, Map<Column, Value>>();
        this.rows = this.rowComparator != null ? new TreeSet<Row>(this.rowComparator) : new TreeSet<Row>();
        this.columns = new TreeSet<Column>();
        Table<Row, Column, Value> tsrc = src;
        Value oi = tsrc.getDefItem();
        this.setDefItem(oi == null ? null : (Value)oi);
        for (Row r : src.rows_direct()) {
            Iterator<Column> iterator = src.columns_direct().iterator();
            while (iterator.hasNext()) {
                Column c;
                Row or = r;
                Column oc = c = iterator.next();
                oi = tsrc.get(or, oc);
                this.set(r, c, oi == null ? null : (Value)oi);
            }
        }
    }

    public Comparator<Row> getRowComparator() {
        return this.rowComparator;
    }

    public void setRowComparator(Comparator<Row> newRowOrder) {
        this.rowComparator = newRowOrder;
        TreeSet<Object> nrows = null;
        nrows = newRowOrder != null ? new TreeSet<Row>(newRowOrder) : new TreeSet();
        nrows.addAll(this.rows);
        this.rows = nrows;
    }

    public Iterable<Value> getRowValues(Row row, Predicate<Column> colPred) {
        if (row == null) {
            throw new IllegalArgumentException("row==null");
        }
        final Row r = row;
        Convertor conv = new Convertor<Column, Value>(){

            @Override
            public Value convert(Column col) {
                Object v = Table.this.get(r, col);
                return v;
            }
        };
        if (colPred != null) {
            return Iterators.convert(Iterators.predicate(this.columns_direct(), colPred), conv);
        }
        return Iterators.convert(this.columns_direct(), conv);
    }

    public Iterable<Value> getColumnValues(Column column, Predicate<Row> rowPred) {
        if (column == null) {
            throw new IllegalArgumentException("column==null");
        }
        final Column col = column;
        Convertor conv = new Convertor<Row, Value>(){

            @Override
            public Value convert(Row row) {
                Object v = Table.this.get(row, col);
                return v;
            }
        };
        if (rowPred != null) {
            return Iterators.convert(Iterators.predicate(this.rows_direct(), rowPred), conv);
        }
        return Iterators.convert(this.rows_direct(), conv);
    }

    public Iterable<Pair<Row, Value>> getColumnRowValues(Column column, Predicate<Row> rowPred) {
        if (column == null) {
            throw new IllegalArgumentException("column==null");
        }
        final Column col = column;
        Convertor conv = new Convertor<Row, Pair<Row, Value>>(){

            @Override
            public Pair<Row, Value> convert(Row row) {
                Object v = Table.this.get(row, col);
                return new BasicPair(row, v);
            }
        };
        if (rowPred != null) {
            return Iterators.convert(Iterators.predicate(this.rows_direct(), rowPred), conv);
        }
        return Iterators.convert(this.rows_direct(), conv);
    }

    public Iterable<Pair<Column, Value>> getRowColumnValues(Row row, Predicate<Column> columnPred) {
        if (row == null) {
            throw new IllegalArgumentException("row==null");
        }
        final Row r = row;
        Convertor conv = new Convertor<Column, Pair<Column, Value>>(){

            @Override
            public Pair<Column, Value> convert(Column col) {
                Object v = Table.this.get(r, col);
                return new BasicPair(col, v);
            }
        };
        if (columnPred != null) {
            return Iterators.convert(Iterators.predicate(this.columns_direct(), columnPred), conv);
        }
        return Iterators.convert(this.columns_direct(), conv);
    }

    public Value getDefItem() {
        return this.defItem;
    }

    public void setDefItem(Value defItem) {
        this.defItem = defItem;
    }

    public boolean isRowExists(Row r) {
        return this.items.containsKey(r);
    }

    public boolean isColumnExists(Column c) {
        return this.columns.contains(c);
    }

    public Iterable<Row> rows() {
        return this.copyRows() ? this.rows_copy() : this.rows_direct();
    }

    protected boolean copyRows() {
        return false;
    }

    protected boolean copyColumns() {
        return false;
    }

    protected Iterable<Row> rows_copy() {
        return new ArrayList<Row>(this.rows);
    }

    protected Iterable<Row> rows_direct() {
        return this.rows;
    }

    public Iterable<Column> columns() {
        return this.copyColumns() ? this.columns_copy() : this.columns_direct();
    }

    protected Iterable<Column> columns_copy() {
        return new ArrayList<Column>(this.columns);
    }

    protected Iterable<Column> columns_direct() {
        return this.columns;
    }

    public void addRow(Row r) {
        this.items.put(r, new TreeMap());
        this.rows.add(r);
        this.fireRowAdded(r);
    }

    public void addColumn(Column c) {
        this.columns.add(c);
        this.fireColumnAdded(c);
    }

    public void clear() {
        this.items.clear();
        this.rows.clear();
        this.columns.clear();
        this.fireCleared();
    }

    public void removeRow(Row r) {
        if (this.items.containsKey(r)) {
            this.items.remove(r);
        }
        if (this.rows.contains(r)) {
            this.rows.remove(r);
        }
        this.fireRowDeleted(r);
    }

    public void removeColumn(Column c) {
        if (this.columns.contains(c)) {
            this.columns.remove(c);
        }
        for (Row r : this.items.keySet()) {
            if (!this.items.get(r).containsKey(c)) continue;
            this.items.get(r).remove(c);
        }
        this.fireColumnDeleted(c);
    }

    public int rowsCount() {
        return this.rows.size();
    }

    public int columnsCount() {
        return this.columns.size();
    }

    protected void normalize() {
        for (Row r : this.rows_direct()) {
            if (this.items.containsKey(r)) continue;
            this.items.put(r, new TreeMap());
        }
        for (Row r : this.rows_direct()) {
            Map<Column, Value> rData = this.items.get(r);
            for (Column c : this.columns_direct()) {
                if (rData.containsKey(c)) continue;
                rData.put(c, this.defItem);
            }
        }
    }

    public void set(Row r, Column c, Value i) {
        boolean needNorm = false;
        if (!this.isRowExists(r)) {
            this.addRow(r);
            needNorm = true;
        }
        if (!this.isColumnExists(c)) {
            this.addColumn(c);
            needNorm = true;
        }
        if (needNorm) {
            this.normalize();
        }
        this.items.get(r).put(c, i);
        this.fireValueChanged(r, c, i);
    }

    public Value get(Row r, Column c) {
        if (!this.isRowExists(r)) {
            return this.defItem;
        }
        if (this.items.get(r).containsKey(c)) {
            return this.items.get(r).get(c);
        }
        return this.defItem;
    }

    public static class Adapter<Row, Column, Value>
    implements Listener<Row, Column, Value> {
        @Override
        public void tableEvent(Event<Row, Column, Value> event) {
            Event e;
            if (event instanceof ValueChagnedEvent) {
                ValueChagnedEvent ve = (ValueChagnedEvent)event;
                this.valueChanged(ve.getTable(), ve.getRow(), ve.getColumn(), ve.getValue());
            }
            if (event instanceof RowAddedEvent) {
                e = (RowAddedEvent)event;
                this.rowAdded(e.getTable(), ((RowChagnedEvent)e).getRow());
            }
            if (event instanceof RowDeletedEvent) {
                e = (RowDeletedEvent)event;
                this.rowDeleted(e.getTable(), ((RowChagnedEvent)e).getRow());
            }
            if (event instanceof ColumnAddedEvent) {
                e = (ColumnAddedEvent)event;
                this.columnAdded(e.getTable(), ((ColumnChagnedEvent)e).getColumn());
            }
            if (event instanceof ColumnDeletedEvent) {
                e = (ColumnDeletedEvent)event;
                this.columnDeleted(e.getTable(), ((ColumnChagnedEvent)e).getColumn());
            }
            if (event instanceof ClearedEvent) {
                e = (ClearedEvent)event;
                this.cleared(e.getTable());
            }
        }

        protected void cleared(Table<Row, Column, Value> table) {
        }

        protected void valueChanged(Table<Row, Column, Value> table, Row row, Column column, Value value) {
        }

        protected void rowAdded(Table<Row, Column, Value> table, Row row) {
        }

        protected void rowDeleted(Table<Row, Column, Value> table, Row row) {
        }

        protected void columnAdded(Table<Row, Column, Value> table, Column column) {
        }

        protected void columnDeleted(Table<Row, Column, Value> table, Column column) {
        }
    }

    public static class ClearedEvent<R, C, V>
    extends Event<R, C, V> {
        public ClearedEvent(Table<R, C, V> table) {
            super(table);
        }
    }

    public static class ColumnDeletedEvent<R, C, V>
    extends ColumnChagnedEvent<R, C, V> {
        public ColumnDeletedEvent(Table<R, C, V> table, C column) {
            super(table, column);
        }
    }

    public static class ColumnAddedEvent<R, C, V>
    extends ColumnChagnedEvent<R, C, V> {
        public ColumnAddedEvent(Table<R, C, V> table, C column) {
            super(table, column);
        }
    }

    public static class ColumnChagnedEvent<R, C, V>
    extends Event<R, C, V> {
        protected C column = null;

        public ColumnChagnedEvent(Table<R, C, V> table, C column) {
            super(table);
            this.column = column;
        }

        public C getColumn() {
            return this.column;
        }
    }

    public static class RowDeletedEvent<R, C, V>
    extends RowChagnedEvent<R, C, V> {
        public RowDeletedEvent(Table<R, C, V> table, R row) {
            super(table, row);
        }
    }

    public static class RowAddedEvent<R, C, V>
    extends RowChagnedEvent<R, C, V> {
        public RowAddedEvent(Table<R, C, V> table, R row) {
            super(table, row);
        }
    }

    public static class RowChagnedEvent<R, C, V>
    extends Event<R, C, V> {
        protected R row = null;

        public RowChagnedEvent(Table<R, C, V> table, R row) {
            super(table);
            this.row = row;
        }

        public R getRow() {
            return this.row;
        }
    }

    public static class ValueChagnedEvent<R, C, V>
    extends Event<R, C, V> {
        protected R row = null;
        protected C column = null;
        protected V value = null;

        public ValueChagnedEvent(Table<R, C, V> table, R row, C column, V value) {
            super(table);
            this.row = row;
            this.column = column;
            this.value = value;
        }

        public R getRow() {
            return this.row;
        }

        public C getColumn() {
            return this.column;
        }

        public V getValue() {
            return this.value;
        }
    }

    public static class Event<R, C, V> {
        protected Table<R, C, V> table = null;

        public Event(Table<R, C, V> table) {
            this.table = table;
        }

        public Table<R, C, V> getTable() {
            return this.table;
        }
    }

    public static interface Listener<R, C, V> {
        public void tableEvent(Event<R, C, V> var1);
    }
}

