/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.set;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.collection.set.EventSetAction;
import xyz.cofe.collection.set.EventSetAdapter;
import xyz.cofe.collection.set.EventSetArgs;
import xyz.cofe.collection.set.EventSetArgsDeleted;
import xyz.cofe.collection.set.EventSetArgsInserted;
import xyz.cofe.collection.set.EventSetListener;
import xyz.cofe.collection.set.SetWrapper;
import xyz.cofe.common.GetListenersHelper;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;

public class BasicEventSet<E>
extends SetWrapper<E>
implements EventSet<E>,
GetListenersHelper {
    private static final Logger logger = Logger.getLogger(BasicEventSet.class.getName());
    private ListenersHelper<EventSetListener<E>, EventSetArgs<E>> listeners = new ListenersHelper(new Func2<Object, EventSetListener<E>, EventSetArgs<E>>(){

        @Override
        public Object apply(EventSetListener<E> listener, EventSetArgs<E> e) {
            listener.eventSet(e);
            return null;
        }
    });
    protected final Queue<EventSetArgs<E>> eventQueue = new LinkedList<EventSetArgs<E>>();
    protected volatile boolean cancelForEach = true;
    protected volatile boolean cancelForAll = false;
    private boolean removeAll_checkContains = false;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = BasicEventSet.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(BasicEventSet.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(BasicEventSet.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public BasicEventSet() {
        super(new LinkedHashSet());
    }

    public BasicEventSet(Set<E> set) {
        super(set);
    }

    @Override
    public ListenersHelper getListenersHelper() {
        return this.listeners;
    }

    @Override
    public Collection<EventSetListener<E>> getEventSetListeners() {
        return this.listeners.getListeners();
    }

    @Override
    public Closeable onAdded(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        Closeable ch = this.addEventSetListener(new EventSetAdapter<E>(){

            @Override
            protected void inserted(E item) {
                listener.recive(item);
            }
        });
        return ch;
    }

    @Override
    public Closeable onRemoved(final Reciver<E> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        Closeable ch = this.addEventSetListener(new EventSetAdapter<E>(){

            @Override
            protected void deleted(E item) {
                listener.recive(item);
            }
        });
        return ch;
    }

    @Override
    public Closeable addEventSetListener(EventSetListener<E> listener) {
        return this.listeners.addListener(listener);
    }

    @Override
    public Closeable addEventSetListener(EventSetListener<E> listener, boolean weak) {
        return this.listeners.addListener(listener, weak);
    }

    @Override
    public void removeEventSetListener(EventSetListener<E> listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean containsEventSetListener(EventSetListener<E> listener) {
        return this.listeners.hasListener(listener);
    }

    protected void fireEventSet(EventSetArgs<E> args) {
        this.listeners.fireEvent(args);
    }

    @Override
    public Closeable onChanged(final Func3<Object, ? super E, ? super E, ? super E> fn, boolean weak) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.addEventSetListener(new EventSetListener<E>(){

            @Override
            public void eventSet(EventSetArgs<E> args) {
                if (args instanceof EventSetArgsInserted) {
                    EventSetArgsInserted ev = (EventSetArgsInserted)args;
                    Object added = ev.getAddedItem();
                    if (added == null) {
                        BasicEventSet.logWarning("EventSetArgsInserted added null element", new Object[]{added});
                    }
                    if (fn != null) {
                        fn.apply(null, null, added);
                    }
                } else if (args instanceof EventSetArgsDeleted) {
                    EventSetArgsDeleted ev = (EventSetArgsDeleted)args;
                    Object deleted = ev.getRemovedItem();
                    if (deleted == null) {
                        BasicEventSet.logWarning("EventSetArgsDeleted removed null element", new Object[]{deleted});
                    }
                    if (fn != null) {
                        fn.apply(null, deleted, null);
                    }
                }
            }
        }, weak);
    }

    @Override
    public Closeable onChanged(Func3<Object, ? super E, ? super E, ? super E> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        return this.onChanged(fn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventSetArgs<E> addEventToQueue(EventSetArgs<E> event) {
        Queue<EventSetArgs<E>> queue = this.eventQueue;
        synchronized (queue) {
            this.addEventToQueue0(event);
        }
        return event;
    }

    private void addEventToQueue0(EventSetArgs<E> event) {
        if (event != null) {
            this.eventQueue.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireQueueEvents() {
        Queue<EventSetArgs<E>> queue = this.eventQueue;
        synchronized (queue) {
            this.fireQueueEvents0();
        }
    }

    private void fireQueueEvents0() {
        EventSetArgs<E> event;
        while ((event = this.eventQueue.poll()) != null) {
            this.listeners.fireEvent(event);
        }
    }

    protected EventSetArgs<E> createInserting(E e) {
        return new EventSetArgs<E>(this, EventSetAction.Inserting, e);
    }

    protected EventSetArgs<E> createInserted(E e) {
        return new EventSetArgsInserted<E>(this, e);
    }

    protected EventSetArgs<E> createDeleting(E e) {
        return new EventSetArgs<E>(this, EventSetAction.Deleting, e);
    }

    protected EventSetArgs<E> createDeleted(E e) {
        return new EventSetArgsDeleted<E>(this, e);
    }

    protected Object lockRun(Func0 run) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        Object r = run.apply();
        return r;
    }

    protected Object lockRun(Func0 run, LockMethod method) {
        if (run == null) {
            throw new IllegalArgumentException("run==null");
        }
        return this.lockRun(run);
    }

    @Override
    public boolean add(final E e) {
        boolean r = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                if (BasicEventSet.this.cancelForAll || BasicEventSet.this.cancelForEach) {
                    EventSetArgs<Object> esa = BasicEventSet.this.createInserting(e);
                    BasicEventSet.this.fireEventSet(esa);
                    if (esa.isCancel()) {
                        return false;
                    }
                }
                boolean r = (Boolean)BasicEventSet.this.lockRun(new Func0(){

                    public Object apply() {
                        return BasicEventSet.this.add0(e);
                    }
                }, new LockMethod("add", true));
                return r;
            }
        }, new LockMethod("add#precheck", false));
        this.fireQueueEvents();
        return r;
    }

    private boolean add0(E e) {
        boolean r = BasicEventSet.super.add(e);
        if (r) {
            EventSetArgs<E> args = this.createInserted(e);
            this.addEventToQueue(args);
        }
        return r;
    }

    @Override
    public boolean addAll(final Collection<? extends E> c) {
        if (this.cancelForEach && !this.cancelForAll) {
            if (c == null) {
                return false;
            }
            Func0<Boolean> fn = new Func0<Boolean>(){

                @Override
                public Boolean apply() {
                    int count = 0;
                    int addedCount = 0;
                    for (final Object e : c) {
                        ++count;
                        EventSetArgs esa = BasicEventSet.this.createInserting(e);
                        BasicEventSet.this.fireEventSet(esa);
                        if (esa.isCancel()) {
                            return false;
                        }
                        Func0 fn = new Func0(){

                            public Object apply() {
                                return BasicEventSet.this.add0(e);
                            }
                        };
                        boolean added = (Boolean)BasicEventSet.this.lockRun(fn, new LockMethod("addAll", true));
                        if (!added) continue;
                        ++addedCount;
                    }
                    return addedCount > 0 && count > 0 || count == 0;
                }
            };
            boolean r = (Boolean)this.lockRun(fn, new LockMethod("addAll#precheck", false));
            this.fireQueueEvents();
            return r;
        }
        Func0 fnCancelForAll = null;
        if (this.cancelForAll) {
            fnCancelForAll = new Func0(){

                public Object apply() {
                    if (c == null) {
                        return false;
                    }
                    boolean cancel = false;
                    for (Object e : c) {
                        EventSetArgs esa = BasicEventSet.this.createInserting(e);
                        BasicEventSet.this.fireEventSet(esa);
                        if (!esa.isCancel()) continue;
                        cancel = true;
                        break;
                    }
                    if (cancel) {
                        return false;
                    }
                    return null;
                }
            };
        }
        boolean r = false;
        final Func0 fnAddAllSuper = new Func0(){

            public Object apply() {
                int count = 0;
                int added = 0;
                for (Object e : c) {
                    ++count;
                    if (!BasicEventSet.this.add0(e)) continue;
                    ++added;
                }
                return count > 0 && added > 0;
            }
        };
        if (fnCancelForAll == null) {
            r = (Boolean)this.lockRun(fnAddAllSuper, new LockMethod("addAll", true));
        } else {
            final Func0 ffnCancelForAll = fnCancelForAll;
            Func0 fn = new Func0(){

                public Object apply() {
                    Boolean preCheck = (Boolean)ffnCancelForAll.apply();
                    if (preCheck != null && !preCheck.booleanValue()) {
                        return false;
                    }
                    return BasicEventSet.this.lockRun(fnAddAllSuper, new LockMethod("addAll", true));
                }
            };
            r = (Boolean)this.lockRun(fn, new LockMethod("addAll#precheck", false));
        }
        this.fireQueueEvents();
        return r;
    }

    @Override
    public void clear() {
        if (this.cancelForAll) {
            final Func0<Boolean> delPreCheck = new Func0<Boolean>(){

                @Override
                public Boolean apply() {
                    for (Object e : BasicEventSet.this) {
                        EventSetArgs args = BasicEventSet.this.createDeleting(e);
                        BasicEventSet.this.fireEventSet(args);
                        if (!args.isCancel()) continue;
                        return false;
                    }
                    return true;
                }
            };
            this.lockRun(new Func0(){

                public Object apply() {
                    Boolean r = (Boolean)delPreCheck.apply();
                    if (r != null && !r.booleanValue()) {
                        return null;
                    }
                    Object[] deleted = BasicEventSet.super.toArray();
                    BasicEventSet.this.lockRun(new Func0(){

                        public Object apply() {
                            BasicEventSet.super.clear();
                            return null;
                        }
                    }, new LockMethod("clear", true));
                    for (Object oe : deleted) {
                        try {
                            Object e = oe;
                            EventSetArgs<Object> args = BasicEventSet.this.createDeleted(e);
                            BasicEventSet.this.addEventToQueue(args);
                        }
                        catch (ClassCastException ex) {
                            BasicEventSet.logException(ex);
                        }
                    }
                    return null;
                }
            }, new LockMethod("clear#precheck", false));
            this.fireQueueEvents();
            return;
        }
        if (this.cancelForEach) {
            Func0 fnPrecheck = new Func0(){

                public Object apply() {
                    for (final Object e : BasicEventSet.this) {
                        EventSetArgs args = BasicEventSet.this.createDeleting(e);
                        BasicEventSet.this.fireEventSet(args);
                        if (args.isCancel()) continue;
                        boolean r = false;
                        r = (Boolean)BasicEventSet.this.lockRun(new Func0(){

                            public Object apply() {
                                return BasicEventSet.this.remove0(e);
                            }
                        }, new LockMethod("clear", true));
                    }
                    return null;
                }
            };
            this.lockRun(fnPrecheck, new LockMethod("clear#precheck", false));
            this.fireQueueEvents();
            return;
        }
        if (!this.cancelForAll || !this.cancelForEach) {
            Func0 clearFn = new Func0(){

                public Object apply() {
                    Object[] deleted = BasicEventSet.super.toArray();
                    BasicEventSet.super.clear();
                    for (Object oe : deleted) {
                        try {
                            Object e = oe;
                            EventSetArgs<Object> args = BasicEventSet.this.createDeleted(e);
                            BasicEventSet.this.addEventToQueue(args);
                        }
                        catch (ClassCastException ex) {
                            BasicEventSet.logException(ex);
                        }
                    }
                    return null;
                }
            };
            this.lockRun(clearFn, new LockMethod("clear", true));
            this.fireQueueEvents();
        }
    }

    @Override
    public boolean remove(final Object o) {
        final Func0 fnPrecheck = new Func0(){

            public Object apply() {
                if (BasicEventSet.this.cancelForAll || BasicEventSet.this.cancelForEach) {
                    try {
                        EventSetArgs<Object> args = BasicEventSet.this.createDeleting(o);
                        BasicEventSet.this.fireEventSet(args);
                        if (args.isCancel()) {
                            return false;
                        }
                        return null;
                    }
                    catch (ClassCastException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
                return null;
            }
        };
        Func0 fnMain = new Func0(){

            public Object apply() {
                Object rc = fnPrecheck.apply();
                if (rc instanceof Boolean && !((Boolean)rc).booleanValue()) {
                    return false;
                }
                boolean r = (Boolean)BasicEventSet.this.lockRun(new Func0(){

                    public Object apply() {
                        return BasicEventSet.this.remove0(o);
                    }
                }, new LockMethod("remove", true));
                return r;
            }
        };
        boolean r = (Boolean)this.lockRun(fnMain, new LockMethod("remove#precheck", false));
        this.fireQueueEvents();
        return r;
    }

    protected boolean remove0(Object o) {
        boolean r = super.remove(o);
        if (r) {
            try {
                EventSetArgs<Object> args = this.createDeleted(o);
                this.addEventToQueue(args);
            }
            catch (ClassCastException ex) {
                BasicEventSet.logException(ex);
            }
        }
        return r;
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        if (this.cancelForAll) {
            final AtomicInteger changed = new AtomicInteger(0);
            if (c != null) {
                Func0 fnPrecheck = new Func0(){

                    public Object apply() {
                        for (final Object o2del : c) {
                            try {
                                Object e = o2del;
                                if (BasicEventSet.this.removeAll_checkContains && !BasicEventSet.this.contains(e)) continue;
                                EventSetArgs args = BasicEventSet.this.createDeleting(e);
                                BasicEventSet.this.fireEventSet(args);
                                if (!args.isCancel()) continue;
                                return false;
                            }
                            catch (ClassCastException ex) {
                                ex.printStackTrace();
                            }
                        }
                        for (final Object o2del : c) {
                            boolean bl = (Boolean)BasicEventSet.this.lockRun(new Func0(){

                                public Object apply() {
                                    boolean res = BasicEventSet.this.remove0(o2del);
                                    if (res) {
                                        changed.incrementAndGet();
                                    }
                                    return res;
                                }
                            }, new LockMethod("removeAll", true));
                        }
                        return null;
                    }
                };
                this.lockRun(fnPrecheck, new LockMethod("removeAll#precheck", false));
                this.fireQueueEvents();
            }
            return changed.get() > 0;
        }
        if (this.cancelForEach) {
            final AtomicInteger changed = new AtomicInteger(0);
            if (c != null) {
                Func0 fn = new Func0(){

                    public Object apply() {
                        for (final Object o2del : c) {
                            try {
                                Object e = o2del;
                                if (BasicEventSet.this.removeAll_checkContains && !BasicEventSet.this.contains(e)) continue;
                                EventSetArgs args = BasicEventSet.this.createDeleting(e);
                                BasicEventSet.this.fireEventSet(args);
                                if (args.isCancel()) {
                                    continue;
                                }
                            }
                            catch (ClassCastException ex) {
                                BasicEventSet.logException(ex);
                            }
                            BasicEventSet.this.lockRun(new Func0(){

                                public Object apply() {
                                    boolean res = BasicEventSet.this.remove0(o2del);
                                    if (res) {
                                        changed.incrementAndGet();
                                    }
                                    return res;
                                }
                            }, new LockMethod("removeAll", true));
                        }
                        return null;
                    }
                };
                this.lockRun(fn, new LockMethod("removeAll#precheck", false));
            }
            this.fireQueueEvents();
            return changed.get() > 0;
        }
        final AtomicInteger changed = new AtomicInteger(0);
        this.lockRun(new Func0(){

            public Object apply() {
                if (c != null) {
                    for (Object o2del : c) {
                        if (!BasicEventSet.this.remove0(o2del)) continue;
                        changed.incrementAndGet();
                    }
                }
                return null;
            }
        }, new LockMethod("removeAll", true));
        this.fireQueueEvents();
        return changed.get() > 0;
    }

    protected void retainsPrepare2Delete(Collection<?> coll2retains, Collection toDelete) {
        for (E e : this) {
            if (coll2retains.contains(e)) continue;
            toDelete.add(e);
        }
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        if (this.cancelForEach || this.cancelForAll) {
            Func0 fn = new Func0(){

                public Object apply() {
                    if (c == null) {
                        BasicEventSet.this.clear();
                        return true;
                    }
                    LinkedList toDel = new LinkedList();
                    BasicEventSet.this.retainsPrepare2Delete(c, toDel);
                    boolean r = BasicEventSet.this.removeAll(toDel);
                    return r;
                }
            };
            Object r = this.lockRun(fn, new LockMethod("retainAll", false));
            if (r instanceof Boolean) {
                return (Boolean)r;
            }
            return true;
        }
        return this.retainsStd(c);
    }

    protected boolean retainsStd(final Collection<?> c) {
        Func0 fn = new Func0(){

            public Object apply() {
                Object[] before = BasicEventSet.this.toArray();
                boolean res = (Boolean)BasicEventSet.this.lockRun(new Func0(){

                    public Object apply() {
                        return BasicEventSet.super.retainAll(c);
                    }
                }, new LockMethod("retainAll#std", true));
                Object[] after = BasicEventSet.this.toArray();
                ArrayList<Object> removed = new ArrayList<Object>();
                for (Object o1 : before) {
                    if (o1 == null) continue;
                    boolean isRemoved = true;
                    for (Object o2 : after) {
                        if (o2 == null || !o1.equals(o2)) continue;
                        isRemoved = false;
                        break;
                    }
                    if (!isRemoved) continue;
                    removed.add(o1);
                }
                for (Object e : removed) {
                    if (e == null) continue;
                    try {
                        Object e2 = e;
                        EventSetArgs args = BasicEventSet.this.createDeleted(e2);
                        BasicEventSet.this.addEventToQueue(args);
                    }
                    catch (ClassCastException classCastException) {}
                }
                return res;
            }
        };
        boolean r = (Boolean)this.lockRun(fn, new LockMethod("retainAll#prepare", false));
        return r;
    }

    @Override
    public boolean contains(final Object o) {
        boolean res = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.contains(o);
            }
        }, new LockMethod("contains", false));
        return res;
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        boolean res = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.containsAll(c);
            }
        }, new LockMethod("containsAll", false));
        return res;
    }

    @Override
    public int size() {
        int res = (Integer)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.size();
            }
        }, new LockMethod("size", false));
        return res;
    }

    @Override
    public Object[] toArray() {
        Object[] res = (Object[])this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.toArray();
            }
        }, new LockMethod("toArray", false));
        return res;
    }

    @Override
    public <T> T[] toArray(final T[] a) {
        Object[] res = (Object[])this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.toArray(a);
            }
        }, new LockMethod("toArray", false));
        return res;
    }

    @Override
    public boolean isEmpty() {
        boolean r = (Boolean)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.isEmpty();
            }
        }, new LockMethod("isEmpty", false));
        return r;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator i = (Iterator)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.iterator();
            }
        }, new LockMethod("iterator", false));
        return i;
    }

    @Override
    public Set<E> getWrappedSet() {
        Set s = (Set)this.lockRun(new Func0(){

            public Object apply() {
                return BasicEventSet.super.getWrappedSet();
            }
        }, new LockMethod("getWrappedSet", false));
        return s;
    }
}

