/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Iterators;

public class UnionMap<K, V>
implements Map<K, V> {
    protected Map<K, V> readMap = null;
    protected Iterable<Map> writeMaps = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(UnionMap.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Map<K, V> getReadMap() {
        return this.readMap;
    }

    public void setReadMap(Map<K, V> readMap) {
        this.readMap = readMap;
    }

    public Iterable<Map> getWriteMaps() {
        return this.writeMaps;
    }

    public void setWriteMaps(Iterable<Map> writeMaps) {
        this.writeMaps = writeMaps;
    }

    public void setWriteMaps(Map ... maps) {
        this.writeMaps = Iterators.array(maps);
    }

    @Override
    public int size() {
        if (this.readMap == null) {
            return 0;
        }
        return this.readMap.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.readMap == null) {
            return true;
        }
        return this.readMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.readMap == null) {
            return false;
        }
        return this.readMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.readMap == null) {
            return false;
        }
        return this.readMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.readMap == null) {
            return null;
        }
        return this.readMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        V r = null;
        if (this.writeMaps != null) {
            for (Map m : this.writeMaps) {
                if (m == null) continue;
                r = m.put(key, value);
            }
        }
        return r;
    }

    @Override
    public V remove(Object key) {
        V r = null;
        if (this.writeMaps != null) {
            for (Map m : this.writeMaps) {
                if (m == null) continue;
                r = m.remove(key);
            }
        }
        return r;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> ms) {
        if (this.writeMaps != null) {
            for (Map m : this.writeMaps) {
                if (m == null) continue;
                m.putAll(ms);
            }
        }
    }

    @Override
    public void clear() {
        if (this.writeMaps != null) {
            for (Map m : this.writeMaps) {
                if (m == null) continue;
                m.clear();
            }
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.readMap == null) {
            return new HashSet();
        }
        return this.readMap.keySet();
    }

    @Override
    public Collection<V> values() {
        if (this.readMap == null) {
            return new HashSet();
        }
        return this.readMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.readMap == null) {
            return new HashSet<Map.Entry<K, V>>();
        }
        return this.readMap.entrySet();
    }
}

